<?php
  /**
   * Database Backup
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: backup.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  require_once(BASEPATH . "lib/class_dbtools.php");
  Registry::set('dbTools',new dbTools());
  $tools = Registry::get("dbTools");
?>
<?php if($user->userlevel !=9):?>
<?php Filter::msgAlert(lang('ADMINONLY'));?>
<?php else:?>
<?php
  if (isset($_GET['backupok']) && $_GET['backupok'] == "1")
      Filter::msgOk(lang('DB_CREATED'),1,1);

  if (isset($_GET['restore']) && $_GET['restore'] == "1")
      Filter::msgOk(lang('DB_RESTORED'),1,1);
	    
  if (isset($_GET['create']) && $_GET['create'] == "1")
      $tools->doBackup('',false);

  if (isset($_POST['backup_file']))
      $tools->doRestore($_POST['backup_file']);
?>
<h1><img src="../images/database.png" alt="" /><?php echo lang('DB_TITLE');?></h1>
<p class="info"><?php echo lang('DB_INFO');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=backup&amp;create=1" class="add"><?php echo lang('DB_DOBACKUP');?></a></span><?php echo lang('DB_SUB');?></h2>
  </div>
  <div class="block-content">
      <div id="backup">
		<?php
		  $dir = BASEPATH . 'admin/backups/';
		  if (is_dir($dir)):
			  $getDir = dir($dir);
			  while (false !== ($file = $getDir->read())):
				  if ($file != "." && $file != ".." && $file != "index.php"):
					  if ($file == $core->sbackup):
						  echo '<div class="db-backup new">';
						  echo '<span class="filename">';
						  echo str_replace(".sql", "", $file) . '</span>';
						  echo '<a href="' . ADMINURL . '/backups/' . $file . '" title="' .lang('DOWNLOAD').': '. $file . '" class="download tooltip">' . lang('DOWNLOAD') . '</a>';
						  echo '<a href="javascript:void(0);" title="' .lang('DELETE').': '. $file . '" class="delete tooltip">' . lang('DELETE') . '</a>';
						  echo '</div>';
					  else:
						  echo '<div class="db-backup" id="item_' . $file . '">';
						  echo '<span class="filename">' . str_replace(".sql", "", $file) . '</span>';
						  echo ' <a href="' . ADMINURL . '/backups/' . $file . '" title="' .lang('DOWNLOAD').': '. $file . '" class="download tooltip">' . lang('DOWNLOAD') . '</a>';
						  echo '<a href="javascript:void(0);" title="' .lang('DELETE').': '. $file . '" class="delete tooltip">' . lang('DELETE') . '</a>';
						  echo '</div>';
		
					  endif;
				  endif;
			  endwhile;
			  $getDir->close();
		  endif;
		?>
      </div>
        <form action="" method="post" id="admin_form" name="admin_form">
          <table class="display" cellspacing="0">
            <tr>
              <td><strong><?php echo lang('DB_DORESTORE');?>:</strong>
                <?php
				  if (is_dir($dir)):
					  $getDir = dir($dir);
					  echo '&nbsp;&nbsp;<select name="backup_file" class="custombox" style="width:250px">';
					  while (false !== ($file = $getDir->read())):
						  if ($file != "." && $file != ".." && $file != "index.php"):
							  echo '<option value="' . $file . '">' . $file . '</option>';
						  endif;
					  endwhile;
					  echo '</select>';
					  $getDir->close();
				  endif;
                ?>
                &nbsp;&nbsp;
                <button type="submit" class="button-alt button-blue"><?php echo lang('DB_RESTORE');?></button></td>
            </tr>
          </table>
        </form>
  </div>
</div>
<div id="dialog-confirm" style="display:none;" title="<?php echo lang('DB_DELETE');?>">
  <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span><?php echo lang('DELCONFIRM');?></p>
</div>
<script type="text/javascript"> 
// <![CDATA[
$(document).ready(function () {
    $('a.delete').live('click', function () {
        var parent = $(this).parent();
		var id = parent.attr('id').replace('item_', '')
		var title = $(this).attr('rel');
        $("#dialog-confirm").data({
            'delid': id,
            'parent': parent,
			'title': title
        }).dialog('open');
        return false;
    });

    $("#dialog-confirm").dialog({
        resizable: false,
        bgiframe: true,
        autoOpen: false,
        width: 400,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            '<?php echo lang('DELETE');?>': function () {
                var parent = $(this).data('parent');
                var id = $(this).data('delid');
				var title = $(this).data('title');

                $.ajax({
                    type: 'post',
                    url: "controller.php",
                    data: 'deleteBackup=' + id,
                    beforeSend: function () {
                        parent.animate({
                            'backgroundColor': '#FFBFBF'
                        }, 400);
                    },
                    success: function (msg) {
                        parent.fadeOut(400, function () {
                            parent.remove();
                        });
						$("html, body").animate({scrollTop:0}, 600);
						$("#msgholder").html(msg);
                    }
                });

                $(this).dialog('close');
            },
            '<?php echo lang('CANCEL');?>': function () {
                $(this).dialog('close');
            }
        }
    });
});
// ]]>
</script>
<?php endif;?>