<?php
  /**
   * Event Calendar
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: calendar.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  require_once(BASEPATH . "lib/class_calendar.php");
  Registry::set('Calendar',new Calendar());
  $cal = Registry::get("Calendar");
?>
<h1><img src="../images/calendar-large.png" alt="" /><?php echo lang('CAL_TITLE');?></h1>
<p class="info"><?php echo lang('CAL_INFO');?></p>
<?php echo lang('CAL_SUB');?>
<div class="block-border">
  <div class="block-content">
     <div id="cal-wrap"><?php $cal->renderCalendar();?></div>
  </div>
</div>
<script type="text/javascript">
// <![CDATA[
  function loadList() {
	  $.ajax({
		  url: "controller.php",
		  cache: false,
		  success: function (html) {
			  $("#cal-wrap").html(html);
		  }
	  });
  }

  $(document).ready(function () {
	  $("a.changedate").live("click", function () {
		  var parent = $(this);
		  var caldata = $(this).attr('id').replace('item_', '');
		  var month = caldata.split(":")[0];
		  var year = caldata.split(":")[1];
		  $.ajax({
			  type: "POST",
			  url: "controller.php",
			  data: {
				  'year': year,
				  'month': month
			  },
			  success: function (data, status) {
				  $("#cal-wrap").fadeIn("fast", function () {
					  $(this).html(data);
				  });
			  }
		  });
		  return false;
	  });
  });
// ]]>
</script>