<?php
  /**
   * Clients
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: clients.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("users", Filter::$id);?>
<h1><img src="../images/users.png" alt="" /><?php echo lang('CLIENT_TITLE');?></h1>
<p class="info"><?php echo lang('CLIENT_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('CLIENT_SUB') . $row->fname.' '.$row->lname;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('USERNAME');?>:</th>
          <td><input name="username" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->username;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PASSWORD');?>:</th>
          <td><input name="password" type="text" class="inputbox" size="55" />
            <?php echo tooltip(lang('PASSWORD_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('EMAIL');?>: <?php echo required();?></th>
          <td><input name="email" type="text" class="inputbox" value="<?php echo $row->email;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('COMPANY');?>:</th>
          <td><input name="company" type="text" class="inputbox" value="<?php echo $row->company;?>" size="55"   /></td>
        </tr>
        <tr>
          <th><?php echo lang('FNAME');?>: <?php echo required();?></th>
          <td><input name="fname" type="text" class="inputbox" value="<?php echo $row->fname;?>" size="55"   /></td>
        </tr>
        <tr>
          <th><?php echo lang('LNAME');?>: <?php echo required();?></th>
          <td><input name="lname" type="text" class="inputbox" value="<?php echo $row->lname;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('ADDRESS');?>:</th>
          <td><input name="address" type="text" class="inputbox" value="<?php echo $row->address;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('CITY');?>:</th>
          <td><input name="city" type="text" class="inputbox" value="<?php echo $row->city;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('STATE');?>:</th>
          <td><input name="state" type="text" class="inputbox" value="<?php echo $row->state;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('COUNTRY');?>:</th>
          <td><input name="country" type="text" class="inputbox" value="<?php echo $row->country;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('ZIP');?>:</th>
          <td><input name="zip" type="text" class="inputbox" value="<?php echo $row->zip;?>" size="20" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PHONE');?>:</th>
          <td><input name="phone" type="text" class="inputbox" value="<?php echo $row->phone;?>" size="20" /></td>
        </tr>
        <tr>
          <th><?php echo lang('CREATED');?>:</th>
          <td><input name="created" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->created;?>" size="20" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('STAFF_LASTLOGIN');?>:</th>
          <td><input name="lastlogin" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->lastlogin;?>" size="20" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('STAFF_LASTIP');?>:</th>
          <td><input name="lastip" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->lastip;?>" size="20" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('NOTES');?>:</th>
          <td><textarea name="notes" cols="45" rows="5"><?php echo $row->notes;?></textarea></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('STAFF_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=clients" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
      <input name="username" type="hidden" value="<?php echo $row->username;?>" />
      <input name="userlevel" type="hidden" value="1" />
    </form>
  </div>
</div>
<?php echo $core->doForm("processUser");?>
<?php break;?>
<?php case"add": ?>
<?php $plist = $content->getProjectList();?>
<h1><img src="../images/users.png" alt="" /><?php echo lang('CLIENT_TITLE1');?></h1>
<p class="info"><?php echo lang('CLIENT_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('CLIENT_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('USERNAME');?>: <?php echo required();?></th>
          <td><input name="username" type="text" class="inputbox" size="55"  /></td>
        </tr>
        <tr>
          <th><?php echo lang('PASSWORD');?>: <?php echo required();?></th>
          <td><input name="password" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('EMAIL');?>: <?php echo required();?></th>
          <td><input name="email" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('COMPANY');?>:</th>
          <td><input name="company" type="text" class="inputbox" size="55"   /></td>
        </tr>
        <tr>
          <th><?php echo lang('FNAME');?>: <?php echo required();?></th>
          <td><input name="fname" type="text" class="inputbox" size="55"   /></td>
        </tr>
        <tr>
          <th><?php echo lang('LNAME');?>: <?php echo required();?></th>
          <td><input name="lname" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('ADDRESS');?>:</th>
          <td><input name="address" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('CITY');?>:</th>
          <td><input name="city" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('STATE');?>:</th>
          <td><input name="state" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('COUNTRY');?>:</th>
          <td><input name="country" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('ZIP');?>:</th>
          <td><input name="zip" type="text" class="inputbox" size="20" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PHONE');?>:</th>
          <td><input name="phone" type="text" class="inputbox" size="20" /></td>
        </tr>
        <tr>
          <th><?php echo lang('NOTES');?>:</th>
          <td><textarea name="notes" cols="45" rows="5"></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('STAFF_NOTIFY');?>:</th>
          <td><input type="checkbox" name="notify" class="checkbox" value="1" />
          <?php echo tooltip(lang('STAFF_NOTIFY_T'));?></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('CLIENT_ADD');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=clients" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="userlevel" type="hidden" value="1" />
    </form>
  </div>
</div>
<?php echo $core->doForm("processUser");?>
<?php break;?>
<?php default: ?>
<?php $clientrow = $user->getClients();?>
<h1><img src="../images/users.png" alt="" /><?php echo lang('CLIENT_TITLE2');?></h1>
<p class="info"><?php echo lang('CLIENT_INFO2');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <tr>
        <td class="subtitle"><select name="select" class="custombox" id="clientfilter" style="width:200px">
            <option value="NA"><?php echo lang('CLIENT_RESET');?></option>
            <?php echo $user->getClientFilter();?>
          </select></td>
        <td align="center" class="subtitle"><form action="" method="post" id="dForm">
            <strong> <?php echo lang('FROM');?></strong>
            <input name="fromdate" type="text" style="margin-right:3px" class="inputbox-sml" size="10" id="fromdate" />
            <strong> <?php echo lang('TO');?></strong>
            <input name="enddate" type="text" class="inputbox-sml" size="10" id="enddate" />
            <input name="find" type="submit" class="button-alt button-blue" value="<?php echo lang('FIND');?>" />
          </form></td>
        <td align="right" class="subtitle"><?php echo $pager->items_per_page();?> &nbsp;&nbsp; <?php echo $pager->jump_menu();?></td>
      </tr>
    </table>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=clients&amp;action=add" class="add"><?php echo lang('CLIENT_ADD');?></a></span><?php echo lang('CLIENT_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('COMPANY');?></th>
          <th class="left"><?php echo lang('NAME');?></th>
          <th class="left"><?php echo lang('EMAIL');?></th>
          <th><?php echo lang('PROJECTS');?></th>
          <th><?php echo lang('BALANCE');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="8"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <?php if(!$clientrow):?>
      <tr>
        <td colspan="8"><?php echo Filter::msgAlert(lang('CLIENT_NOCLIENTS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($clientrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->company;?></td>
        <td><?php echo $row->fullname;?></td>
        <td><a href="index.php?do=email&amp;emailid=<?php echo urlencode($row->email);?>"><?php echo $row->email;?></a></td>
        <td align="center"><?php echo $row->projects;?></td>
        <td align="center"><?php echo ($row->balance) ? $row->balance : "0.00";?></td>
        <td align="center"><a href="index.php?do=clients&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->fullname;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->fullname;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->fullname;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('CLIENT_DELCLIENT'),"deleteUser");?> 
<script type="text/javascript"> 
// <![CDATA[  
$(document).ready(function () {
    $('#clientfilter').change(function () {
		var res = $("#clientfilter option:selected").val();
		(res == "NA" ) ? window.location.href = 'index.php?do=clients' : window.location.href = 'index.php?do=clients&sort=' + res;
    })
});
$(function () {
    var dates = $('#fromdate, #enddate').datepicker({
        defaultDate: "+1w",
        changeMonth: false,
        numberOfMonths: 2,
        dateFormat: 'yy-mm-dd',
        onSelect: function (selectedDate) {
            var option = this.id == "fromdate" ? "minDate" : "maxDate";
            var instance = $(this).data("datepicker");
            var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
            dates.not(this).datepicker("option", option, date);
        }
    });
});
// ]]>
</script>
<?php break;?>
<?php endswitch;?>