<?php
  /**
   * Configuration
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: config.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php if($user->userlevel !=9):?>
<?php Filter::msgAlert(lang('ADMINONLY'));?>
<?php else:?>
<h1><img src="../images/config.png" alt="" /><?php echo lang('CONF_TITLE');?></h1>
<p class="info"><?php echo lang('CONF_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('CONF_SUB');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('CONF_COMPANY');?>: <?php echo required();?></th>
          <td><input name="company" type="text" class="inputbox" value="<?php echo $core->company;?>" size="55"/>
            <?php echo tooltip(lang('CONF_COMPANY_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_URL');?>: <?php echo required();?></th>
          <td><input name="site_url" type="text" class="inputbox" value="<?php echo $core->site_url;?>" size="55"/>
            <?php echo tooltip(lang('CONF_URL_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_EMAIL');?>: <?php echo required();?></th>
          <td><input name="site_email" type="text" class="inputbox" value="<?php echo $core->site_email;?>" size="55"/>
            <?php echo tooltip(lang('CONF_EMAIL_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_ADDRESS');?>: <?php echo required();?></th>
          <td><input name="address" type="text" class="inputbox" value="<?php echo $core->address;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_CITY');?>: <?php echo required();?></th>
          <td><input name="city" type="text" class="inputbox" value="<?php echo $core->city;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_STATE');?>: <?php echo required();?></th>
          <td><input name="state" type="text" class="inputbox" value="<?php echo $core->state;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_ZIP');?>: <?php echo required();?></th>
          <td><input name="zip" type="text" class="inputbox" value="<?php echo $core->zip;?>" size="10"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_PHONE');?>:</th>
          <td><input name="phone" type="text" class="inputbox" value="<?php echo $core->phone;?>" size="20"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_FAX');?>:</th>
          <td><input name="fax" type="text" class="inputbox" value="<?php echo $core->fax;?>" size="20"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_OFFLINE');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="enable_offline" value="1" <?php getChecked($core->enable_offline, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="enable_offline"  value="0" <?php getChecked($core->enable_offline, 0); ?> /></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_OFFLINEINFO');?>:</th>
          <td><textarea name="offline_info" cols="45" rows="5"><?php echo $core->offline_info;?></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_LOGO');?>:</th>
          <td><input name="logo" type="file" size="40" class="fileinput mask" /></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_DELLOGO');?>:</th>
          <td><input name="dellogo" type="checkbox" value="1" class="checkbox"/>
            <?php echo tooltip(lang('CONF_DELLOGO_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_SDATE');?>:</th>
          <td><select class="custombox" name="short_date" style="width:250px">
              <?php echo $core->getShortDate();?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_LDATE');?>:</th>
          <td><select class="custombox" name="long_date" style="width:250px">
              <?php echo $core->getLongDate();?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_TZ');?>:</th>
          <td><?php echo $core->getTimezones();?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_WEEK');?>:</th>
          <td><select class="custombox" name="weekstart" style="width:250px">
              <?php echo $core->weekList();?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_REGYES');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="enable_reg" value="1" <?php getChecked($core->enable_reg, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="enable_reg" value="0" <?php getChecked($core->enable_reg, 0); ?> />
            <?php echo tooltip(lang('CONF_REGYES_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_TAX');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="enable_tax"  value="1" <?php getChecked($core->enable_tax, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="enable_tax"  value="0" <?php getChecked($core->enable_tax, 0); ?> /></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_TAXNAME');?>:</th>
          <td><input name="tax_name" type="text" class="inputbox" value="<?php echo $core->tax_name;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_TAXRATE');?>:</th>
          <td><input name="tax_rate" type="text" class="inputbox" value="<?php echo $core->tax_rate * 100;?>" size="10"/>
            %</td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_TAXNO');?>:</th>
          <td><input name="tax_number" type="text" class="inputbox" value="<?php echo $core->tax_number;?>" size="55"/>
          <?php echo tooltip(lang('CONF_TAXNO_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_UPLOADS');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="enable_uploads" id="enable_uploads-1" value="1" <?php getChecked($core->enable_uploads, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="enable_uploads" id="enable_uploads-2" value="0" <?php getChecked($core->enable_uploads, 0); ?> /></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_AFT');?>:</th>
          <td><input name="file_types" type="text" class="inputbox" value="<?php echo $core->file_types;?>" size="55"/>
            <?php echo tooltip(lang('CONF_AFT_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_MFS');?>:</th>
          <td><input name="file_max" type="text" class="inputbox" value="<?php echo $core->file_max/1048576;?>" size="10"/>
            MB <?php echo tooltip(lang('CONF_MFS_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_IPP');?>:</th>
          <td><input name="perpage" type="text" class="inputbox" value="<?php echo $core->perpage;?>" size="5" />
            <?php echo tooltip(lang('CONF_IPP_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_CURRENCY');?>: <?php echo required();?></th>
          <td><input name="currency" type="text" class="inputbox" value="<?php echo $core->currency;?>" size="5"/>
            <?php echo tooltip(lang('CONF_CURRENCY_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_CURSYMBOL');?>:</th>
          <td><input name="cur_symbol" type="text" class="inputbox" value="<?php echo $core->cur_symbol;?>" size="5"/>
            <?php echo tooltip(lang('CONF_CURSYMBOL_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('CONF_MAILER');?>:</th>
          <td><select class="custombox" name="mailer" id="mailerchange" style="width:150px">
              <option value="PHP"<?php if ($core->mailer == "PHP") echo "selected=\"selected\"";?>>PHP Mailer</option>
              <option value="SMTP"<?php if ($core->mailer == "SMTP") echo "selected=\"selected\"";?>>SMTP Mailer</option>
            </select>
            <?php echo tooltip(lang('CONF_MAILER_T'));?></td>
        </tr>
        <tr class="showsmtp">
          <th><?php echo lang('CONF_SMTP_HOST');?>:</th>
          <td><input name="smtp_host" type="text" class="inputbox" value="<?php echo $core->smtp_host;?>" size="55" />
            <?php echo tooltip(lang('CONF_SMTP_HOST_T'));?></td>
        </tr>
        <tr class="showsmtp">
          <th><?php echo lang('CONF_SMTP_USER');?>:</th>
          <td><input name="smtp_user" type="text" class="inputbox" value="<?php echo $core->smtp_user;?>" size="55" /></td>
        </tr>
        <tr class="showsmtp">
          <th><?php echo lang('CONF_SMTP_PASS');?>:</th>
          <td><input name="smtp_pass" type="text" class="inputbox" value="<?php echo $core->smtp_pass;?>" size="55"/></td>
        </tr>
        <tr class="showsmtp">
          <th><?php echo lang('CONF_SMTP_PORT');?>:</th>
          <td><input name="smtp_port" type="text" class="inputbox" value="<?php echo $core->smtp_port;?>" size="5" />
            <?php echo tooltip(lang('CONF_SMTP_PORT_T'));?></td>
        </tr>
        <tr>
          <td colspan="2"><input type="submit" name="dosubmit" class="button button-green" value="<?php echo lang('CONF_UPDATE');?>" /></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processConfig");?> 
<script type="text/javascript">
 $(".mask").filestyle({ 
     image: "../images/file-button.png",
     imageheight : 29,
     imagewidth : 75,
     width : 230
 });
// <![CDATA[
$(document).ready(function () {
	var res2 = '<?php echo $core->mailer;?>';
		(res2 == "SMTP" ) ? $('.showsmtp').show() : $('.showsmtp').hide();
    $('#mailerchange').change(function () {
		var res = $("#mailerchange option:selected").val();
		(res == "SMTP" ) ? $('.showsmtp').show() : $('.showsmtp').hide();
	});
});
// ]]>
</script>
<?php endif;?>