<?php
  /**
   * Controller
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: controller.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  
  require_once("init.php");
  if (!$user->is_Admin())
    redirect_to("login.php");
?>
<?php
  /* == Proccess Configuration == */
  if (isset($_POST['processConfig'])):
      $core->processConfig();
  endif;
?>
<?php
  /* == Proccess Gateway == */
  if (isset($_POST['processGateway']))
      : if (intval($_POST['processGateway']) == 0 || empty($_POST['processGateway']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->processGateway();
  endif;
?>
<?php
  /* == Proccess News == */
  if (isset($_POST['processNews'])):
      if (intval($_POST['processNews']) == 0 || empty($_POST['processNews'])):
          redirect_to("index.php?do=news");
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0;
      $content->processNews();
  endif;
  
  /* == Delete News == */
  if (isset($_POST['deleteNews'])):
      if (intval($_POST['deleteNews']) == 0 || empty($_POST['deleteNews'])):
          die();
      endif;

      $id = intval($_POST['deleteNews']);
      $db->delete("news", "id='" . $id . "'");

      $title = sanitize($_POST['title']);
	  print ($db->affected()) ? Filter::msgOk(str_replace("[NEWS]", $title, lang('NEWS_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Email == */
  if (isset($_POST['processEmail']))
      : if (intval($_POST['processEmail']) == 0 || empty($_POST['processEmail']))
      : die();
  endif;
  $content->processEmail();
  endif;
?>
<?php
  /* == Proccess Project == */
  if (isset($_POST['processProject']))
      : if (intval($_POST['processProject']) == 0 || empty($_POST['processProject']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->processProject();
  endif;

  /* == Delete Project == */
  if (isset($_POST['deleteProject']))
      : if (intval($_POST['deleteProject']) == 0 || empty($_POST['deleteProject']))
      : die();
  endif;
  
  $id = intval($_POST['deleteProject']);
  $res = $db->delete("projects", "id='" . $id . "'");
  $db->delete("permissions", "project_id='" . $id . "'");
  $db->delete("tasks", "project_id='" . $id . "'");
  $db->delete("submissions", "project_id='" . $id . "'");
  $db->delete("invoices", "project_id='" . $id . "'");
  $db->delete("invoice_data", "project_id='" . $id . "'");
  $db->delete("invoice_payments", "project_id='" . $id . "'");
  
  $filename = getValue("filename", "project_files", "project_id='" . $id . "'");
  @unlink(UPLOADS . 'data/'.$filename);
  
  $db->delete("project_files", "project_id='" . $id . "'");
  $title = sanitize($_POST['title']);
  
  print ($res) ? Filter::msgOk(str_replace("[PROJECT]", $title, lang('PROJ_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Project Type == */
  if (isset($_POST['processProjectType'])):
      if (intval($_POST['processProjectType']) == 0 || empty($_POST['processProjectType'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0;
      $content->processProjectType();
  endif;

  /* == Delete Project Type == */
  if (isset($_POST['deleteProjectType'])):
      if (intval($_POST['deleteProjectType']) == 0 || empty($_POST['deleteProjectType'])):
          die();
      endif;

      $id = intval($_POST['deleteProjectType']);
      $db->delete("project_types", "id='" . $id . "'");
      $title = sanitize($_POST['title']);

      print ($db->affected()) ? Filter::msgOk(str_replace("[TYPE]", $title, lang('TYPE_DELTYPE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Project Task == */
  if (isset($_POST['processProjectTask'])):
      if (intval($_POST['processProjectTask']) == 0 || empty($_POST['processProjectTask'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
      $content->processProjectTask();
  endif;

  /* == Delete Project Task == */
  if (isset($_POST['deleteProjectTask'])):
      if (intval($_POST['deleteProjectTask']) == 0 || empty($_POST['deleteProjectTask'])):
          die();
      endif;

      $id = intval($_POST['deleteProjectTask']);
      $db->delete("tasks", "id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[TASK]", $title, lang('TASK_DELTASK_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Project Submission == */
  if (isset($_POST['processSubmission']))
      : if (intval($_POST['processSubmission']) == 0 || empty($_POST['processSubmission']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->processProjectSubmission();
  endif;

  /* == Delete Project Submission == */
  if (isset($_POST['deleteSubmission']))
      : if (intval($_POST['deleteSubmission']) == 0 || empty($_POST['deleteSubmission']))
      : die();
  endif;
  
  $id = intval($_POST['deleteSubmission']);
  $db->delete("submissions", "id='" . $id . "'");
  $title = sanitize($_POST['title']);
  
  print ($db->affected()) ? Filter::msgOk(str_replace("[SUBMISSION]", $title, lang('SUBS_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Project File == */
  if (isset($_POST['processProjectFile'])):
      if (intval($_POST['processProjectFile']) == 0 || empty($_POST['processProjectFile'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0;
      $content->processProjectFile();
  endif;

  /* == Delete Project File == */
  if (isset($_POST['deleteProjectFile'])):
      if (empty($_POST['deleteProjectFile'])):
          die();
      endif;

      list($id, $filename) = explode(":", $_POST['deleteProjectFile']);
      @unlink(UPLOADS . '/data/' . $filename);

      $db->delete("project_files", "id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[FILE]", $title, lang('FILE_DELFILE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));

  endif;
?>
<?php
  /* == Update Invoice == */
  if (isset($_POST['updateInvoice']))
      : if (intval($_POST['updateInvoice']) == 0 || empty($_POST['updateInvoice']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->updateInvoice();
  endif;

  /* == Add Invoice == */
  if (isset($_POST['addInvoice']))
      : if (intval($_POST['addInvoice']) == 0 || empty($_POST['addInvoice']))
      : die();
  endif;
  $content->addInvoice();
  endif;
  
  /* == Send Invoice == */
  if (isset($_POST['sendInvoice']))
      : if (intval($_POST['sendInvoice']) == 0 || empty($_POST['sendInvoice']))
      : die();
  endif;
  $id = intval($_POST['sendInvoice']); 
  $content->sendInvoice($id);
  endif;
  
  /* == Delete Invoice == */
  if (isset($_POST['deleteInvoice']))
      : if (empty($_POST['deleteInvoice']))
      : die();
  endif;
  
  list($id, $pid) = explode(":",$_POST['deleteInvoice']);

  $res = $db->delete("invoices", "id='" . (int)$id . "'");
  $db->delete("invoice_payments", "invoice_id='" . (int)$id . "'");
  $db->delete("invoice_data", "invoice_id='" . (int)$id . "'");
  $row = $db->first("SELECT SUM(amount_paid) as amtotal FROM invoices WHERE project_id = '" . (int)$pid . "' GROUP BY project_id");
  
  $pdata['b_status'] = ($row) ? $row->amtotal : 0.00;
  $db->update("projects", $pdata, "id='" . (int)$pid . "'");
  
  $title = sanitize($_POST['title']);
  
  print ($res) ? Filter::msgOk(str_replace("[INVOICE]", $title, lang('INVC_DELETEINV_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
  
  /* == Load Invoice Entries == */
  if (isset($_POST['loadInvoiceEntries'])):
      if (intval($_POST['loadInvoiceEntries']) == 0 || empty($_POST['loadInvoiceEntries'])):
          die();
      endif;
      $id = intval($_POST['loadInvoiceEntries']);
      $content->loadInvoiceEntries($id);
  endif;
  
  /* == Process Invoice Entry == */
  if (isset($_POST['processInvoiceEntry'])):
      if (intval($_POST['processInvoiceEntry']) == 0 || empty($_POST['processInvoiceEntry'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
      $content->processInvoiceEntry();
  endif;
  
  /* == Delete Invoice Entry == */
  if (isset($_POST['deleteInvoiceEntry'])):
      if (empty($_POST['deleteInvoiceEntry'])):
          die();
      endif;
      $content->deleteInvoiceEntry($_POST['deleteInvoiceEntry']);
  endif;
  
  /* == Load Invoice Records == */
  if (isset($_POST['loadInvoiceRecords'])):
      if (intval($_POST['loadInvoiceRecords']) == 0 || empty($_POST['loadInvoiceRecords'])):
          die();
      endif;
      $id = intval($_POST['loadInvoiceRecords']);
      $content->loadInvoiceRecords($id);
  endif;
  
  /* == Process Invoice Record == */
  if (isset($_POST['processInvoiceRecord'])):
      if (intval($_POST['processInvoiceRecord']) == 0 || empty($_POST['processInvoiceRecord'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
      $content->processInvoiceRecord();
  endif;
  
  /* == Delete Invoice Record == */
  if (isset($_POST['deleteInvoiceRecord'])):
      if (empty($_POST['deleteInvoiceRecord'])):
          die();
      endif;
      $content->deleteInvoiceRecord($_POST['deleteInvoiceRecord']);
  endif;
?>
<?php
  /* == Proccess User == */
  if (isset($_POST['processUser'])):
      if (intval($_POST['processUser']) == 0 || empty($_POST['processUser'])):
          die();
      endif;
      Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0;
      $user->processUser();
  endif;

  /* == Delete User== */
  if (isset($_POST['deleteUser'])):
      if (intval($_POST['deleteUser']) == 0 || empty($_POST['deleteUser'])):
          die();
      endif;

      $id = intval($_POST['deleteUser']);
      if ($id == 1):
          Filter::msgError(lang('STAFF_DELUSER_ERR1'));
      else:
          if ($projects = $db->fetch_all("SELECT id FROM projects WHERE client_id = '$id'")):
              foreach ($projects as $row):
                  $db->delete("invoice_data", "project_id='" . $row->id . "'");
                  $db->delete("invoice_payments", "project_id='" . $row->id . "'");
                  $db->delete("invoices", "project_id='" . $row->id . "'");
                  $db->delete("project_files", "project_id='" . $row->id . "'");
                  $db->delete("submissions", "project_id='" . $row->id . "'");
                  $db->delete("tasks", "project_id='" . $row->id . "'");
				  $db->delete("time_billing", "project_id='" . $row->id . "'");
              endforeach;
          endif;
          $db->delete("projects", "client_id='" . $id . "'");
          $db->delete("users", "id='" . $id . "'");
          $username = sanitize($_POST['title']);

          print ($db->affected()) ? Filter::msgOk(str_replace("[USERNAME]", $username, lang('STAFF_DELUSER_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
      endif;
  endif;
?>
<?php
  /* == Proccess Time Billing Record == */
  if (isset($_POST['processTimeRecord']))
      : if (intval($_POST['processTimeRecord']) == 0 || empty($_POST['processTimeRecord']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->processTimeRecord();
  endif;

  /* == Delete Time Billing Record == */
  if (isset($_POST['deleteTimeBillingRecord'])):
      if (empty($_POST['deleteTimeBillingRecord'])):
          die();
      endif;
	  
  $id = intval($_POST['deleteTimeBillingRecord']);
  $db->delete("time_billing", "id='" . $id . "'");
  $title = sanitize($_POST['title']);
  
  print ($db->affected()) ? Filter::msgOk(str_replace("[TIMEBILL]", $title, lang('BILL_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
  
  /* == Delete Time Billing == */
  if (isset($_POST['deleteTimeBilling'])):
      if (empty($_POST['deleteTimeBilling'])):
          die();
      endif;
	  
  $id = intval($_POST['deleteTimeBilling']);
  $db->delete("time_billing", "project_id='" . $id . "'");
  $title = sanitize($_POST['title']);
  
  print ($db->affected()) ? Filter::msgOk(str_replace("[TIMEBILL]", $title, lang('BILL_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
  
  /* == Create Time Billing Report == */
  if (isset($_GET['action']) and $_GET['action'] == "createTimeReport"):

	  $sql = "SELECT tb.*,"
	  . "\n tb.created as cdate,"
	  . "\n p.title as ptitle, ts.title as tasktitle, CONCAT(u.fname,' ',u.lname) as fullname"
	  . "\n FROM time_billing as tb"
	  . "\n LEFT JOIN projects as p ON p.id = tb.project_id"
	  . "\n LEFT JOIN tasks as ts ON ts.id = tb.task_id"
	  . "\n LEFT JOIN users as u ON u.id = tb.client_id";
	  
	  $result = $db->fetch_all($sql);
	  
      $type = "vnd.ms-excel";
	  $date = date('m-d-Y H:i');
	  $title = "Exported from the " . $core->company . " on $date";
	  
      header("Pragma: public");
      header("Expires: 0");
      header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
      header("Content-Type: application/force-download");
      header("Content-Type: application/octet-stream");
      header("Content-Type: application/download");
	  header("Content-Type: application/$type");
      header("Content-Disposition: attachment;filename=temp_" . time() . ".xls");
      header("Content-Transfer-Encoding: binary ");
	  
	  print '
	  <table width="100%" cellpadding="1" cellspacing="2" border="1">
	  <caption>' . $title . '</caption>
	    <thead>
		<tr>
		  <td>#</th>
		  <td>' . lang('BILL_RECNAME') . '</td>
		  <td>' . lang('PROJ_NAME') . '</td>
		  <td>' . lang('INVC_CNAME') . '</td>
		  <td>' . lang('TASK_NAME') . '</td>
		  <td>' . lang('CREATED') . '</td>
		  <td>' . lang('HOURS') . '</td>
		  <td>' . lang('DESC') . '</td>
		</tr>
		</thead>';
		foreach ($result as $v) {
			print '<tr>
			  <td>'.$v->id.'</td>
			  <td>'.$v->title.'</td>
			  <td>'.$v->ptitle.'</td>
			  <td>'.$v->fullname.'</td>
			  <td>'.$v->tasktitle.'</td>
			  <td>'.Filter::dodate($core->long_date, $v->cdate).'</td>
			  <td>'.$v->hours.'</td>
			  <td>'.sanitize($v->description).'</td>
			</tr>';
		}
	  print '</table>';
	  unset($v);
	  exit();
  endif;
?>
<?php
  /* == Create Transaction Report == */
  if (isset($_GET['action']) and $_GET['action'] == "createReport"):
  
	  $sql = "SELECT ip.*,"
	  . "\n ip.created as cdate,"
	  . "\n p.title as ptitle, i.title as ititle, CONCAT(u.fname,' ',u.lname) as fullname"
	  . "\n FROM invoice_payments as ip"
	  . "\n LEFT JOIN projects as p ON p.id = ip.project_id"
	  . "\n LEFT JOIN invoices as i ON i.id = ip.invoice_id"
	  . "\n LEFT JOIN users as u ON u.id = i.client_id";
	  
	  $result = $db->fetch_all($sql);
	  
      $type = "vnd.ms-excel";
	  $date = date('m-d-Y H:i');
	  $title = "Exported from the " . $core->company . " on $date";

      header("Pragma: public");
      header("Expires: 0");
      header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
      header("Content-Type: application/force-download");
      header("Content-Type: application/octet-stream");
      header("Content-Type: application/download");
	  header("Content-Type: application/$type");
      header("Content-Disposition: attachment;filename=temp_" . time() . ".xls");
      header("Content-Transfer-Encoding: binary ");
	  
	  print '
	  <table width="100%" cellpadding="1" cellspacing="2" border="1">
	  <caption>' . $title . '</caption>
	    <thead>
		<tr>
		  <td>#</th>
		  <td>' . lang('PROJ_NAME') . '</td>
		  <td>' . lang('INVC_CNAME') . '</td>
		  <td>#' . lang('TRANS_INVOICE') . '</td>
		  <td>' . lang('TRANS_PAYDATE') . '</td>
		  <td>' . lang('PAYMETHOD') . '</td>
		  <td>' . lang('AMOUNT') . '</td>
		  <td>' . lang('INFO') . '</td>
		</tr>
		</thead>';
		foreach ($result as $v) {
			print '<tr>
			  <td>'.$v->id.'</td>
			  <td>'.$v->ptitle.'</td>
			  <td>'.$v->fullname.'</td>
			  <td>'.$v->ititle.'</td>
			  <td>'.Filter::dodate($core->long_date, $v->cdate).'</td>
			  <td>'.$v->method.'</td>
			  <td>'.$v->amount.'</td>
			  <td>'.$v->description.'</td>
			</tr>';
		}
	  print '</table>';
	  unset($v);
	  exit();
  endif;
?>
<?php
  /* == Proccess Support Ticket == */
  if (isset($_POST['processSupportTicket'])):
      if (intval($_POST['processSupportTicket']) == 0 || empty($_POST['processSupportTicket'])):
          die();
      endif;
      Filter::$id = intval($_POST['id']); 
      $content->processSupportTicket();
  endif;

  /* == Reply Support Ticket == */
  if (isset($_POST['replySupportTicket'])):
      if (intval($_POST['replySupportTicket']) == 0 || empty($_POST['replySupportTicket'])):
          die();
      endif;
      Filter::$id = intval($_POST['replySupportTicket']); 
      $content->replySupportTicket();
  endif;

  /* == Load Support Ticket == */
  if (isset($_POST['loadReplyEntries'])):
      if (intval($_POST['loadReplyEntries']) == 0 || empty($_POST['loadReplyEntries'])):
          die();
      endif;
	  
      Filter::$id = intval($_POST['loadReplyEntries']);
      $resrow = $content->getResponseByTicketId();

      if ($resrow):
          print '<ul id="reply-list">';
          foreach ($resrow as $trow):
              $class = ($trow->user_type == "client") ? 'row-client' : 'row-staff';
              print '<li class="' . $class . '">'
			  . '<strong>' . lang('CREATED') . '</strong>: ' . $trow->cdate . ' - <strong>' . lang('AUTHOR') . '</strong>: ' . $trow->name . ' (' . $trow->user_type . ')'
			  . '<span class="delete">'
			  . '<a href="javascript:void(0);" class="delete" id="item_' . $trow->id . '" rel="' . Filter::dodate($core->long_date, $trow->created) . '>"><img src="../images/trash.png" alt="" class="tooltip" title="' . lang('DELETE') . '" /></a>'
			  . '</span>';
              print '<div>' . cleanOut($trow->body) . '</div></li>';
          endforeach;
          print '</ul>';
      endif;
  endif;

  /* == Delete Support Reply == */
  if (isset($_POST['deleteSupportReply'])):
      if (intval($_POST['deleteSupportReply']) == 0 || empty($_POST['deleteSupportReply'])):
          die();
      endif;

      $id = intval($_POST['deleteSupportReply']);
	  $db->delete("support_responses", "id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[REPLY]", $title, lang('SUP_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
  
  /* == Delete Support Ticket == */
  if (isset($_POST['deleteSupportTicket'])):
      if (intval($_POST['deleteSupportTicket']) == 0 || empty($_POST['deleteSupportTicket'])):
          die();
      endif;

      $id = intval($_POST['deleteSupportTicket']);
      $db->delete("support_tickets", "id='" . $id . "'");
	  $db->delete("support_responses", "ticket_id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[TICKET]", $title, lang('SUP_DELTICKET_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Load Calendar == */
  if (isset($_POST['month'])):
	require_once(BASEPATH . "lib/class_calendar.php");
	Registry::set('Calendar',new Calendar());
	$cal = Registry::get("Calendar");
	
	$cal->renderCalendar();
  endif;
?>
<?php
  /* == Delete SQL Backup == */
  if (isset($_POST['deleteBackup'])) :
	$action = @unlink(BASEPATH . 'admin/backups/'.sanitize($_POST['deleteBackup']));
  
  print ($action) ? Filter::msgOk(lang('DB_DELETE_OK')) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Visual Form == */
  if (isset($_POST['processVisualForm'])):
      if (intval($_POST['processVisualForm']) == 0 || empty($_POST['processVisualForm'])):
          die();
      endif;
	  require_once(BASEPATH . "lib/class_forms.php");
	  Registry::set('Forms',new Forms());
	  $forms = Registry::get("Forms");
	  
	  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0;
      $forms->processForm();
  endif;
  
  if(isset($_GET['formmanage'])):
	require_once(BASEPATH . "lib/class_forms.php");
	Registry::set('Forms',new Forms());
	$forms = Registry::get("Forms");
  
	/* == Load Form Data == */
	if(isset($_GET['getformdata']) && intval($_GET['formid'])):
	  $forms->getFormData($_GET['formid']);
	endif;
  
	/* == Save Form Data== */
	if(isset($_GET['saveformdata']) && intval($_GET['formid'])):
	  Filter::$id = (isset($_GET['formid'])) ? $_GET['formid'] : 0;
	  $forms->saveFormData();
	endif;
  endif;
  
  /* == Delete Visual Form == */
  if (isset($_POST['deleteVisualForm'])):
      if (intval($_POST['deleteVisualForm']) == 0 || empty($_POST['deleteVisualForm'])):
          die();
      endif;

	  require_once(BASEPATH . "lib/class_forms.php");
	  Registry::set('Forms',new Forms());
	  $forms = Registry::get("Forms");
	  
      $id = intval($_POST['deleteVisualForm']);
      $db->delete("forms", "id='" . $id . "'");
	  $db->delete("forms_data", "form_id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[FORM]", $title, lang('FORM_DELFORM_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
  
  /* == Delete Visual Form Data == */
  if (isset($_POST['deleteFormData'])):
      if (intval($_POST['deleteFormData']) == 0 || empty($_POST['deleteFormData'])):
          die();
      endif;

	  require_once(BASEPATH . "lib/class_forms.php");
	  Registry::set('Forms',new Forms());
	  $forms = Registry::get("Forms");
	  
      $id = intval($_POST['deleteFormData']);
	  $db->delete("forms_data", "id='" . $id . "'");
      $title = sanitize($_POST['title']);

	  print ($db->affected()) ? Filter::msgOk(str_replace("[FORMDATA]", $title, lang('FORM_DELDATA_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Proccess Message == */
  if (isset($_POST['processMessage']))
      : if (intval($_POST['processMessage']) == 0 || empty($_POST['processMessage']))
      : die();
  endif;
  Filter::$id = (isset($_POST['id'])) ? $_POST['id'] : 0; 
  $content->processMessage();
  endif;

  /* == Delete Message == */
  if (isset($_POST['deleteMessage']))
      : if (intval($_POST['deleteMessage']) == 0 || empty($_POST['deleteMessage']))
      : die();
  endif;
  
  $id = intval($_POST['deleteMessage']);
  $db->delete("messages", "id='" . $id . "'");
  $title = sanitize($_POST['title']);
  
  print ($db->affected()) ? Filter::msgOk(str_replace("[MESSAGE]", $title, lang('MSG_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Make Pdf == */
  if (isset($_GET['dopdf'])):
      if (intval($_GET['dopdf']) == 0 || empty($_GET['dopdf'])):
          die();
      endif;
	  
	  Filter::$id = intval($_GET['dopdf']);
	  $title = sanitize($_GET['title']);
	  ob_start();
	  require_once(BASEPATH . 'admin/print_pdf.php');
	  $pdf_html = ob_get_contents();
	  ob_end_clean();

	  require_once(BASEPATH . 'lib/dompdf/dompdf_config.inc.php');
	  $dompdf = new DOMPDF();
	  $dompdf->load_html($pdf_html);
	  $dompdf->render();
	  $dompdf->stream($title . ".pdf");
  endif;
?>