<?php
  /**
   * Project Files
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: files.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("project_files", Filter::$id);?>
<?php $typerow = $content->getProjectList();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('FILE_TITLE');?></h1>
<p class="info"><?php echo lang('FILE_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FILE_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('FILE_SELPROJ');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('FILE_SELPROJ');?> ---</option>
              <?php if ($typerow):?>
              <?php foreach ($typerow as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == $row->project_id) echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th width="200"><?php echo lang('FILE_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="filedesc" cols="20" rows="1" id="bodycontent"><?php echo $row->filedesc;?></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_VER');?>:</th>
          <td><input name="version" type="text" class="inputbox" value="<?php echo $row->version;?>" size="5" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_ATTACH');?>:</th>
          <td><input name="filename" type="file" size="40" class="fileinput mask" /></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('FILE_UPDATE');?>" class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=files" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectFile");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
 $(".mask").filestyle({ 
     image: "../images/file-button.png",
     imageheight : 29,
     imagewidth : 75,
     width : 230
 });
// ]]>
</script>
<?php break;?>
<?php case"add":?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('FILE_TITLE1');?></h1>
<p class="info"><?php echo lang('FILE_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FILE_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('FILE_SELPROJ');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">-- <?php echo lang('FILE_SELPROJ');?> --</option>
              <?php if ($content->getProjectList()):?>
              <?php foreach ($content->getProjectList() as $prow):?>
              <option value="<?php echo $prow->id;?>"><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th width="200"><?php echo lang('FILE_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" size="55"/></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="filedesc" cols="20" rows="1" id="bodycontent"></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_VER');?>:</th>
          <td><input name="version" type="text" class="inputbox" value="1.00" size="5" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_ATTACH');?>: <?php echo required();?></th>
          <td><input name="filename" type="file" size="40" class="fileinput mask" /></td>
        </tr>
        <tr>
          <td><input name="addfile" type="submit" value="<?php echo lang('FILE_ADD');?>" class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=files" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectFile");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
 $(".mask").filestyle({ 
     image: "../images/file-button.png",
     imageheight : 29,
     imagewidth : 75,
     width : 230
 });
// ]]>
</script>
<?php break;?>
<?php default:?>
<?php $filerow = $content->getProjectFiles();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('FILE_TITLE2');?></h1>
<p class="info"><?php echo lang('FILE_INFO2') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=files&amp;action=add" class="add"><?php echo lang('FILE_ADD');?></a></span><?php echo lang('FILE_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('FILE_NAME');?></th>
          <th class="left"><?php echo lang('PROJ_NAME');?></th>
          <th class="left"><?php echo lang('FILESIZE');?></th>
          <th><?php echo lang('DOWNLOAD');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$filerow):?>
      <tr>
        <td colspan="7"><?php echo Filter::msgInfo(lang('FILE_NOFILES'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($filerow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><a href="index.php?do=projects&amp;action=edit&amp;id=<?php echo $row->pid;?>"><?php echo $row->ptitle;?></a></td>
        <td><?php echo getSize($row->filesize);?></td>
        <td align="center"><a href="<?php echo UPLOADURL . 'data/' . $row->filename;?>"><img src="../images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD');?>"/></a></td>
        <td align="center"><a href="index.php?do=files&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id.':'.$row->filename;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE') . $row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('FILE_DELFILE'),"deleteProjectFile");?>
<?php break;?>
<?php endswitch;?>