<?php
  /**
   * Form Builder
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: forms.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  require_once(BASEPATH . "lib/class_forms.php");
  Registry::set('Forms',new Forms());
  $forms = Registry::get("Forms");
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("forms", Filter::$id);?>
<h1><img src="../images/forms-large.png" alt="" /><?php echo lang('FORM_TITLE');?></h1>
<p class="info"><?php echo lang('FORM_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FORM_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('FORM_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_EMAIL');?>: <?php echo required();?></th>
          <td><input name="mailto" type="text" class="inputbox" value="<?php echo $row->mailto;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_MSG');?>: <?php echo required();?></th>
          <td><input name="sendmessage" type="text" class="inputbox" value="<?php echo $row->sendmessage;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_BTN');?>: <?php echo required();?></th>
          <td><input name="submit_btn" type="text" class="inputbox" value="<?php echo $row->submit_btn;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_CAPTCHA');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="captcha" value="1" <?php getChecked($row->captcha, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="captcha" value="0" <?php getChecked($row->captcha, 0); ?> /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_ACTIVE');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="active" value="1" <?php getChecked($row->active, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="active" value="0" <?php getChecked($row->active, 0); ?> /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="template" cols="20" rows="1" id="bodycontent"><?php echo $row->template;?></textarea></td>
        </tr>
        <tr>
          <td colspan="2"><strong><?php echo lang('FORM_NOTE');?></strong></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('FORM_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=forms" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processVisualForm");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:400});
  });
</script>
<?php break;?>
<?php case"add": ?>
<h1><img src="../images/forms-large.png" alt="" /><?php echo lang('FORM_TITLE1');?></h1>
<p class="info"><?php echo lang('FORM_INFO') . lang('FORM_INFO1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FORM_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('FORM_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_EMAIL');?>: <?php echo required();?></th>
          <td><input name="mailto" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_MSG');?>: <?php echo required();?></th>
          <td><input name="sendmessage" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_BTN');?>: <?php echo required();?></th>
          <td><input name="submit_btn" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_CAPTCHA');?>:</th>
          <td><?php echo lang('YES');?>
            <input name="captcha" type="radio" value="1" checked="checked" />
            <?php echo lang('NO');?>
            <input type="radio" name="captcha" value="0" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FORM_ACTIVE');?>:</th>
          <td><?php echo lang('YES');?>
            <input name="active" type="radio" value="1" checked="checked" />
            <?php echo lang('NO');?>
            <input name="active" type="radio" value="0" /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="template" cols="20" rows="1" id="bodycontent"><?php echo "&lt;div align=&quot;center&quot;&gt; &lt;table width=&quot;600&quot; cellspacing=&quot;5&quot; cellpadding=&quot;5&quot; border=&quot;0&quot; style=&quot;background: none repeat scroll 0% 0% rgb(244, 244, 244); border: 1px solid rgb(102, 102, 102);&quot;&gt; &lt;tbody&gt; &lt;tr&gt; &lt;th style=&quot;background-color: rgb(204, 204, 204);&quot;&gt;Hello Admin&lt;/th&gt; &lt;/tr&gt; &lt;tr&gt; &lt;td valign=&quot;top&quot; style=&quot;text-align: left;&quot;&gt;You have a new [FORMNAME] request: &lt;hr /&gt; [FORMDATA] &lt;/td&gt; &lt;/tr&gt; &lt;/tbody&gt; &lt;/table&gt;&lt;/div&gt;";?></textarea></td>
        </tr>
        <tr>
          <td colspan="2"><strong><?php echo lang('FORM_NOTE');?></strong></td>
        </tr>
        <tr>
          <td><input name="add" type="submit" value="<?php echo lang('FORM_ADD');?>"  class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=forms" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processVisualForm");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:400});
  });
</script>
<?php break;?>
<?php case"fields": ?>
<h1><img src="../images/forms-large.png" alt="" /><?php echo lang('FORM_TITLE2');?></h1>
<p class="info"><?php echo lang('FORM_INFO2');?></p>
<div class="block-border">
  <div class="block-content">
    <div id="formbuilder"></div>
  </div>
</div>
<script type="text/javascript" src="../assets/js/forms.js"></script> 
<script type="text/javascript"> 
// <![CDATA[
$(function () {
    $('#formbuilder').formbuilder({
        'save_url': 'controller.php?formid=<?php echo Filter::$id;?>&saveformdata=1&formmanage',
        'load_url': 'controller.php?formid=<?php echo Filter::$id;?>&getformdata=1&formmanage',
            messages: {
                save: "<?php echo lang('FORM_F_SAVE');?>",
                text: "<?php echo lang('FORM_F_TEXT');?>",
                picker: "<?php echo lang('FORM_F_DATE');?>",
                uploader: "<?php echo lang('FORM_F_FILE');?>",
                title: "<?php echo lang('FORM_F_TITLE');?>",
                paragraph: "<?php echo lang('FORM_F_PARA');?>",
                checkboxes: "<?php echo lang('FORM_F_CHECK');?>",
                radio: "<?php echo lang('FORM_F_RADIO');?>",
                select: "<?php echo lang('FORM_F_SELECT');?>",
                datepicker: "<?php echo lang('FORM_F_PICKER');?>",
                text_field: "<?php echo lang('FORM_F_TEXT');?>",
                label: "<?php echo lang('FORM_F_LABEL');?>",
                paragraph_field: "<?php echo lang('FORM_F_PARAFIELD');?>",
                select_options: "<?php echo lang('FORM_F_SELECTO');?>",
                add: "<?php echo lang('FORM_F_ADD');?>",
                checkbox_group: "<?php echo lang('FORM_F_CHECKG');?>",
                remove_message: "<?php echo lang('FORM_F_REMOVEM');?>",
                remove: "<?php echo lang('FORM_F_REMOVE');?>",
                radio_group: "<?php echo lang('FORM_F_RADIOG');?>",
                selections_message: "<?php echo lang('FORM_F_MULTI');?>",
                hide: "<?php echo lang('FORM_F_HIDE');?>",
                required: "<?php echo lang('FORM_F_REQ');?>",
                show: "<?php echo lang('FORM_F_SHOW');?>",
				cancel: "<?php echo lang('CANCEL');?>"
            }
    });
    $(function () {
        $("#formbuilder ul").sortable({
            opacity: 0.7,
            cursor: 'move'
        });
    });
});
// ]]>
</script>
<div id="dialog-confirm" style="display:none;" title="<?php echo lang('FORM_REMFIELD');?>">
  <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span><?php echo lang('FORM_F_REMOVEM');?></p>
</div>
<?php break;?>
<?php case"viewdata": ?>
<?php $datarow = $forms->getFormSubmittedData();?>
<h1><img src="../images/forms-large.png" alt="" /><?php echo lang('FORM_TITLE2');?></h1>
<p class="info"><?php echo lang('FORM_INFO2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=forms" class="add"><?php echo lang('FORM_BACK');?></a></span><?php echo lang('FORM_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('FORM_SUBMITTED');?></th>
          <th><?php echo lang('FORM_VIEWD');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <tbody>
        <?php if(!$datarow):?>
        <tr>
          <td colspan="4"><?php echo Filter::msgAlert(lang('FORM_NODATA'),false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($datarow as $row):?>
        <tr>
          <th align="center"><?php echo $row->id;?>.</th>
          <td><?php echo Filter::doDate($core->long_date, $row->created);?></td>
          <td align="center"><div id="viewdata-<?php echo $row->id;?>" style="display:none" class="viewdata" title="<?php echo lang('FORM_VIEWD');?>"> <?php echo $row->form_data;?> </div>
            <a href="javascript:void(0);" onclick="$('#viewdata-<?php echo $row->id;?>').dialog('open'); return false"><img src="../images/view.png" class="tooltip"  alt="" title="<?php echo lang('FORM_VIEWD');?>"/></a></td>
          <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->cdate;?>"><img src="../images/delete.png" class="tooltip"  alt="" title="<?php echo lang('DELETE');?>"/></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($row);?>
        <?php endif;?>
      </tbody>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('FORM_DELDATA'),"deleteFormData");?> 
<script type="text/javascript"> 
// <![CDATA[
$(document).ready(function () {
    $(".viewdata").dialog({
        bgiframe: true,
        autoOpen: false,
        width: 500,
        height: 'auto',
        zindex: 9998,
        modal: true
    });
});
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php $formrows = $forms->getForms();?>
<h1><img src="../images/forms-large.png" alt="" /><?php echo lang('FORM_TITLE3');?></h1>
<p class="info"><?php echo lang('FORM_INFO3');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=forms&amp;action=add" class="add"><?php echo lang('FORM_ADD');?></a></span><?php echo lang('FORM_SUB3');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('FORM_NAME');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th><?php echo lang('FORM_EDITFIELDS');?></th>
          <th><?php echo lang('FORM_EDITFORM');?></th>
          <th><?php echo lang('FORM_PREVIEWF');?></th>
          <th><?php echo lang('FORM_PREVIEWD');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$formrows):?>
      <tr>
        <td colspan="8"><?php echo Filter::msgInfo(lang('FORM_NOFORM'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($formrows as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo Filter::doDate($core->long_date, $row->created);?></td>
        <td align="center"><a href="index.php?do=forms&amp;action=fields&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('FORM_EDITFIELDS');?>"/></a></td>
        <td align="center"><a href="index.php?do=forms&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('FORM_EDITFORM');?>"/></a></td>
        <td align="center"><div id="viewform-<?php echo $row->id;?>" style="display:none" class="viewform" title="<?php echo lang('FORM_PREVIEWF').' - '.$row->title;?>"> <?php echo $forms->generate_html($row->form_data);?> </div>
          <a href="javascript:void(0);" onclick="$('#viewform-<?php echo $row->id;?>').dialog('open'); return false"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('FORM_PREVIEWF');?>"/></a></td>
        <td align="center"><a href="index.php?do=forms&amp;action=viewdata&amp;id=<?php echo $row->id;?>"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('FORM_PREVIEWD');?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<script type="text/javascript"> 
// <![CDATA[
$(".pickfile").filestyle({
    image: "../images/file-button.png",
    imageheight: 29,
    imagewidth: 75,
    width: 230
});

$(document).ready(function () {
    $(".viewform").dialog({
        bgiframe: true,
        autoOpen: false,
        width: 550,
        height: 600,
        zindex: 9998,
        modal: true
    });
});
// ]]>
</script> 
<?php echo Core::doDelete(lang('FORM_DELFORM'),"deleteVisualForm");?>
<?php break;?>
<?php endswitch;?>
