<?php
  /**
   * Gateways
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: gateways.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php if($user->userlevel !=9):?>
<?php Filter::msgAlert(lang('ADMINONLY'));?>
<?php else:?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("gateways", Filter::$id);?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('GATE_TITLE');?></h1>
<p class="info"><?php echo lang('GATE_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="javascript:void(0);" onclick="$('#dialog').dialog('open'); return false" class="add"><?php echo lang('HELP');?></a></span><?php echo lang('GATE_SUB') . $row->displayname;?></h2>
  </div>
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellpadding="0" cellspacing="0" class="forms">
        <tr>
          <th width="200"><?php echo lang('GATE_NAME');?>: <?php echo required();?></th>
          <td><input name="displayname" type="text"  class="inputbox" value="<?php echo $row->displayname;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo $row->extra_txt;?>: </th>
          <td><input name="extra" type="text" class="inputbox" value="<?php echo $row->extra;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo $row->extra_txt2;?>:</th>
          <td><input name="extra2" type="text" class="inputbox" value="<?php echo $row->extra2;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo $row->extra_txt3;?>:</th>
          <td><input name="extra3" type="text" class="inputbox" value="<?php echo $row->extra3;?>" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('GATE_LIVE');?>:</th>
          <td> <?php echo lang('YES');?>
            <input name="live" type="radio" value="1" <?php getChecked($row->live, 1); ?> />
            <?php echo lang('NO');?>
            <input name="live" type="radio" value="0" <?php getChecked($row->live, 0); ?> />
            <?php echo tooltip(lang('GATE_LIVE_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('GATE_ACTIVE');?>:</th>
          <td><?php echo lang('YES');?>
            <input name="active" type="radio" value="1" <?php getChecked($row->active, 1); ?> />
            <?php echo lang('NO');?>
            <input name="active" type="radio" value="0" <?php getChecked($row->active, 0); ?> />
            <?php echo tooltip(lang('GATE_ACTIVE_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('GATE_IPN');?>:</th>
          <td><?php echo SITEURL.'/gateways/'.$row->dir.'/ipn.php';?></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('GATE_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=gateways" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<div id="dialog" title="<?php echo $row->displayname;?>"><?php echo cleanOut($row->info);?></div>
<?php echo Core::doForm("processGateway");?>
<?php break;?>
<?php default: ?>
<?php $gaterow = $content->getGateways();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('GATE_TITLE1');?></h1>
<p class="info"><?php echo lang('GATE_INFO1');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><?php echo lang('GATE_SUB1');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('GATE_NAME');?></th>
          <th width="80"><?php echo lang('EDIT');?></th>
        </tr>
      </thead>
      <tbody>
        <?php if(!$gaterow):?>
        <tr>
          <td colspan="3"><?php echo $core->msgError(lang('GATE_NOGATE'),false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($gaterow as $row):?>
        <tr>
          <th><?php echo $row->id;?>.</th>
          <td><?php echo $row->displayname;?></td>
          <td align="center"><a href="index.php?do=gateways&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->displayname;?>"/></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($row);?>
        <?php endif;?>
      </tbody>
    </table>
  </div>
</div>
<?php break;?>
<?php endswitch;?>
<?php endif;?>