<?php
  /**
   * Invoices
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: invoices.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = $content->getProjectInvoiceById();?>
<?php $invdata = $content->getProjectInvoiceData();?>
<?php $paydata = $content->getProjectInvoicePayments();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_TITLE');?></h1>
<p class="info"><?php echo lang('INVC_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<?php if(!$row):?>
<?php echo Filter::msgError( lang('INVC_ERR'), false);?>
<?php else:?>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('INVC_SUB') . $row->ptitle;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('INVC_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CNAME');?>:</th>
          <td><input name="name" type="text" disabled="disabled"  class="inputbox" value="<?php echo $row->name;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CEMAIL');?>:</th>
          <td><input name="email" type="text" disabled="disabled"  class="inputbox" value="<?php echo $row->email;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_DUEDATE');?>:</th>
          <td><input name="duedate" type="text" class="inputbox" id="date" size="25" value="<?php echo $row->duedate;?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_TOTAL');?>:</th>
          <td><input name="amount_total" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->amount_total;?>" size="15" readonly="readonly"/></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_PAID');?>:</th>
          <td><input name="amount_paid" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->amount_paid;?>" size="15" readonly="readonly"/></td>
        </tr>
        <tr>
          <th><?php echo $core->tax_name;?>:</th>
          <td><input name="tax" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->tax;?>" size="15" readonly="readonly"/></td>
        </tr>
        <tr>
          <th><?php echo lang('PAYMETHOD');?>:</th>
          <td><select class="custombox" name="method" style="width:150px">
              <option value="Offline"<?php if($row->method == 'Online') echo ' selected="selected"';?>><?php echo lang('OFFLINE');?></option>
              <optgroup label="<?php echo lang('ONLINE');?>">
              <option value="PayPal"<?php if($row->method == 'PayPal') echo ' selected="selected"';?>>PayPal</option>
              <option value="MoneyBookers"<?php if($row->method == 'MoneyBookers') echo ' selected="selected"';?>>MoneyBookers</option>
              <option value="AlertPay"<?php if($row->method == 'AlertPay') echo ' selected="selected"';?>>AlertPay</option>
              <option value="AuthorizeNet"<?php if($row->method == 'AuthorizeNet') echo ' selected="selected"';?>>AuthorizeNet</option>
              </optgroup>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('STATUS');?>:</th>
          <td><select class="custombox" name="status" style="width:150px">
              <?php echo $content->invoiceStatusList($row->status);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('ACTIONS');?>:</th>
          <td><a href="javascript:void(0);" class="sendinvoice" id="list_<?php echo $row->id;?>"><img src="../images/email.png" alt="" title="<?php echo lang('INVC_EMAIL_T');?>" class="tooltip img-wrap"/></a> <a href="javascript:void(0);" onclick="javascript:void window.open('print_invoice.php?id=<?php echo Filter::$id;?>','printer','width=800,height=600,toolbar=0,menubar=0,location=0,status=0,scrollbars=1,resizable=1,left=0,top=0');return false;"><img src="../images/print-large.png" alt="" title="<?php echo lang('INVC_PRINT_T');?>" class="tooltip img-wrap"/></a> <a href="controller.php?dopdf=<?php echo $row->id;?>&amp;title=<?php echo $row->title;?>"><img src="../images/pdf-icon.png" alt="" title="<?php echo lang('INVC_PDF_T');?>" class="tooltip img-wrap"/></a></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('INVC_UPDATE');?>"  class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=invoices&amp;id=<?php echo $row->project_id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="javascript:void(0);" id="add-entry" class="add"><?php echo lang('INVC_ADDENTRY');?></a></span><?php echo lang('INVC_SUBENTRY');?></h2>
  </div>
  <div class="block-content">
    <div id="invoice-entries">
      <table cellpadding="0" cellspacing="0" class="display">
        <thead>
          <tr>
            <th width="20">#</th>
            <th width="20%" nowrap="nowrap" class="left"><?php echo lang('INVC_ENTRYTITLE');?></th>
            <th width="40%" class="left"><?php echo lang('DESC');?></th>
            <th class="left"><?php echo lang('AMOUNT');?></th>
            <th><?php echo lang('EDIT');?></th>
            <th><?php echo lang('DELETE');?></th>
          </tr>
        </thead>
        <?php if(!$invdata):?>
        <tr>
          <td colspan="6"><?php echo Filter::msgInfo(lang('INVC_NOENTRY'), false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($invdata as $irow):?>
        <tr>
          <th align="center"><?php echo $irow->id;?>.</th>
          <td><?php echo $irow->title;?></td>
          <td><?php echo $irow->description;?></td>
          <td><?php echo $irow->amount;?></td>
          <td align="center"><a href="index.php?do=invoices&amp;action=editentry&amp;id=<?php echo $irow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '. $irow->title;?>"/></a></td>
          <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $irow->id.':'.$irow->project_id.':'.$irow->invoice_id;?>" rel="<?php echo $irow->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '. $irow->title;?>" /></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($irow);?>
        <?php endif;?>
      </table>
    </div>
  </div>
</div>
<?php echo Core::doDelete(lang('INVC_DELENTRY'),"deleteInvoiceEntry");?>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="javascript:void(0);" id="add-record" class="add"><?php echo lang('INVC_ADDRECORD');?></a></span><?php echo lang('INVC_SUBRECORD');?></h2>
  </div>
  <div class="block-content">
    <div id="invoice-records">
      <table cellpadding="0" cellspacing="0" class="display">
        <thead>
          <tr>
            <th width="20">#</th>
            <th width="20%" nowrap="nowrap" class="left"><?php echo lang('INVC_RECPAID');?></th>
            <th width="40%" class="left"><?php echo lang('DESC');?></th>
            <th class="left"><?php echo lang('AMOUNT');?></th>
            <th><?php echo lang('EDIT');?></th>
            <th><?php echo lang('DELETE');?></th>
          </tr>
        </thead>
        <?php if(!$paydata):?>
        <tr>
          <td colspan="6"><?php echo Filter::msgInfo(lang('INVC_NORECORD'),false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($paydata as $prow):?>
        <tr>
          <th align="center"><?php echo $prow->id;?>.</th>
          <td><?php echo Filter::dodate($core->short_date, $prow->created);?></td>
          <td><?php echo $prow->description;?></td>
          <td><?php echo $prow->amount;?></td>
          <td align="center"><a href="index.php?do=invoices&amp;action=editrecord&amp;id=<?php echo $prow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT');?>"/></a></td>
          <td align="center"><a href="javascript:void(0);" class="rdelete" id="pitem_<?php echo $prow->id.':'.$prow->project_id.':'.$prow->invoice_id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE');?>" /></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($prow);?>
        <?php endif;?>
      </table>
    </div>
  </div>
</div>
<?php echo Core::doDelete(lang('INVC_DELRECORD'), "deleteInvoiceRecord", "pitem_", "a.rdelete", "dialog-confirm-record");?>
<div id="dialog-add-entry" style="display:none;" title="Adding Invoice Entry">
  <div class="block-border" style="margin-top:5px">
    <form action="" method="post" id="entry_form" name="entry_form">
      <div class="block-content">
        <table cellspacing="0" cellpadding="0" class="forms">
          <tbody>
            <tr>
              <th width="200"><?php echo lang('INVC_ENTRYTITLE');?>: <?php echo required();?></th>
              <td><input name="etitle" type="text" class="inputbox" size="55" /></td>
            </tr>
            <tr>
              <th><?php echo lang('DESC');?>:</th>
              <td><input name="edesc" type="text" class="inputbox" size="55" /></td>
            </tr>
            <tr>
              <th><?php echo lang('AMOUNT');?>: <?php echo required();?></th>
              <td><input name="eamount" type="text" class="inputbox"  size="15" /></td>
            </tr>
            <tr>
              <th><?php echo lang('TAXABLE');?>:</th>
              <td><?php echo lang('YES');?>
                <input name="etax" type="radio" value="1" />
                <?php echo lang('NO');?>
                <input name="etax" type="radio" value="0" checked="checked" /></td>
            </tr>
          </tbody>
        </table>
      </div>
      <input name="invoice_id" type="hidden" value="<?php echo Filter::$id;?>" />
      <input name="project_id" type="hidden" value="<?php echo $row->project_id;?>" />
      <input name="processInvoiceEntry" type="hidden" value="1" />
    </form>
  </div>
</div>
<div id="dialog-add-record" style="display:none;" title="<?php echo lang('INVC_SUBRECORD1');?>">
  <div class="block-border" style="margin-top:5px">
    <form action="" method="post" id="record_form" name="record_form">
      <div class="block-content">
        <table cellspacing="0" cellpadding="0" class="forms">
          <tbody>
            <tr>
              <th width="200"><?php echo lang('PAYMETHOD');?>:</th>
              <td><select class="select" name="method" style="width:170px">
                  <option value="Offline"><?php echo lang('OFFLINE');?></option>
                  <optgroup label="<?php echo lang('ONLINE');?>">
                  <option value="PayPal">PayPal</option>
                  <option value="MoneyBookers">MoneyBookers</option>
                  <option value="AlertPay">AlertPay</option>
                  <option value="AuthorizeNet">AuthorizeNet</option>
                  </optgroup>
                </select></td>
            </tr>
            <tr>
              <th><?php echo lang('INVC_DUEDATE');?></th>
              <td><input name="rcreated" type="text" class="inputbox" id="rcreated" size="25" value="<?php echo date('Y-m-d');?>"/></td>
            </tr>
            <tr>
              <th><?php echo lang('DESC');?>:</th>
              <td><input name="rdesc" type="text" class="inputbox" size="55" /></td>
            </tr>
            <tr>
              <th><?php echo lang('AMOUNT');?>: <?php echo required();?></th>
              <td><input name="ramount" type="text" class="inputbox"  size="15" />
              <?php echo tooltip('Enter only numeric values');?></td>
            </tr>
          </tbody>
        </table>
      </div>
      <input name="invoice_id" type="hidden" value="<?php echo Filter::$id;?>" />
      <input name="project_id" type="hidden" value="<?php echo $row->project_id;?>" />
      <input name="processInvoiceRecord" type="hidden" value="1" />
    </form>
  </div>
</div>
<div id="dialog-send" style="display:none;" title="<?php echo lang('INVC_EMAIL_T2');?>">
  <p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span><?php echo lang('INVC_SEND_T');?></p>
</div>
<?php echo $core->doForm("updateInvoice");?> 
<script type="text/javascript">
// <![CDATA[
$(function () {
    $("#date, #rcreated").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});

function loadEntryList() {
	$('#loader').fadeIn(200);
	$.ajax({
		type: 'post',
		url: "controller.php",
		data: 'loadInvoiceEntries=' + <?php echo Filter::$id;?>,
		cache: false,
		success: function (html) {
			$("#invoice-entries").html(html);
		}
	});
	$('#loader').fadeOut(200);
}
function loadRecordList() {
	$('#loader').fadeIn(200);
	$.ajax({
		type: 'post',
		url: "controller.php",
		data: 'loadInvoiceRecords=' + <?php echo Filter::$id;?>,
		cache: false,
		success: function (html) {
			$("#invoice-records").html(html);
		}
	});
	$('#loader').fadeOut(200);
}
$(document).ready(function () {
    // Add Entry
    $('a#add-entry').live('click', function () {
        $("#dialog-add-entry").dialog('open');
        return false;
    });

    // Add Entry
    $('a#add-record').live('click', function () {
        $("#dialog-add-record").dialog('open');
        return false;
    });
	
    $("#dialog-add-entry").dialog({
        resizable: true,
        autoOpen: false,
        width: 600,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            '<?php echo lang('INVC_ADDENTRY');?>': function () {
				var str = $("#entry_form").serialize();
                $.ajax({
                    type: 'post',
                    url: "controller.php",
                    data: str,
					success: function (res) {
						$("#msgholder").html(res);
						$("html, body").animate({
							scrollTop: 0
						}, 600);
						setTimeout(function () {
							$(loadEntryList()).fadeIn("slow");
						}, 2000);
					}
                });

                //$(this).dialog('close');
            },
            '<?php echo lang('CANCEL');?>': function () {
                $(this).dialog('close');
            }
        }
    });

    $("#dialog-add-record").dialog({
        resizable: true,
        autoOpen: false,
        width: 600,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            '<?php echo lang('INVC_ADDENTRY');?>': function () {
				var str = $("#record_form").serialize();
                $.ajax({
                    type: 'post',
                    url: "controller.php",
                    data: str,
					success: function (res) {
						$("#msgholder").html(res);
						$("html, body").animate({
							scrollTop: 0
						}, 600);
						setTimeout(function () {
							$(loadRecordList()).fadeIn("slow");
						}, 2000);
					}
                });

                //$(this).dialog('close');
            },
            '<?php echo lang('CANCEL');?>': function () {
                $(this).dialog('close');
            }
        }
    });
	
    $('a.sendinvoice').live('click', function () {
        var id = $(this).attr('id').replace('list_', '')
        $("#dialog-send").data({
            'invid': id
        }).dialog('open');
        return false;
    });

    $("#dialog-send").dialog({
        resizable: false,
        bgiframe: true,
        autoOpen: false,
        width: 400,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            '<?php echo lang('SEND');?>': function () {
                var id = $(this).data('invid');
                $.ajax({
                    type: 'post',
                    url: "controller.php",
                    data: 'sendInvoice=' + id,
                    beforeSend: function () {
						$("#loader").fadeIn(200);
                    },
                    success: function (msg) {
						$("#loader").fadeOut(200);
						$("#msgholder").html(msg);
                    }
                });

                $(this).dialog('close');
            },
            '<?php echo lang('CANCEL');?>': function () {
                $(this).dialog('close');
            }
        }
    });
});
// ]]>
</script>
<?php endif;?>
<?php break;?>
<?php case"editentry": ?>
<?php $row = Core::getRowById("invoice_data", Filter::$id);?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_ENTRYTITLE2');?></h1>
<p class="info"><?php echo lang('INVC_ENTRYINFO2') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('INVC_ENTRYSUB2') . $row->title;?></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th width="200"><?php echo lang('INVC_ENTRYTITLE');?>: <?php echo required();?></th>
            <td><input name="etitle" id="entry-title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
          </tr>
          <tr>
            <th><?php echo lang('DESC');?>:</th>
            <td><input name="edesc" id="entry-desc" type="text" class="inputbox" value="<?php echo $row->description;?>" size="55" /></td>
          </tr>
          <tr>
            <th><?php echo lang('AMOUNT');?>: <?php echo required();?></th>
            <td><input name="eamount" id="entry-amount" type="text" class="inputbox" value="<?php echo $row->amount;?>" size="15" />
            <?php echo tooltip('Enter only numeric values');?></td>
          </tr>
          <tr>
            <th><?php echo lang('TAXABLE');?>:</th>
            <td><?php echo lang('YES');?>
              <input name="etax" type="radio" value="1" <?php if($row->tax <> 0) echo 'checked="checked"'; ?>/>
              <?php echo lang('NO');?>
              <input name="etax" type="radio" value="0" <?php if($row->tax == 0) echo 'checked="checked"'; ?> /></td>
          </tr>
          <tr>
            <td><input name="submit" type="submit" value="<?php echo lang('INVC_ENTRYUPDATE');?>" class="button button-green"/></td>
            <td><a href="index.php?do=invoices&amp;action=edit&amp;pid=<?php echo $row->project_id;?>&amp;id=<?php echo $row->invoice_id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
          </tr>
        </tbody>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
      <input name="invoice_id" type="hidden" value="<?php echo $row->invoice_id;?>" />
      <input name="project_id" type="hidden" value="<?php echo $row->project_id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processInvoiceEntry");?>
<?php break;?>
<?php case"editrecord": ?>
<?php $row = Core::getRowById("invoice_payments", Filter::$id);?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_RECTITLE2');?></h1>
<p class="info"><?php echo lang('INVC_RECINFO2') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('INVC_RECSUB2') . getValue("title","invoices","id = '".$row->invoice_id."'");?></th>
          </tr>
        </thead>
        <tbody>
        <tr>
          <th width="200"><?php echo lang('PAYMETHOD');?>:</th>
          <td><select class="custombox" name="method" style="width:150px">
              <option value="Offline"<?php if($row->method == 'Online') echo ' selected="selected"';?>><?php echo lang('OFFLINE');?></option>
              <optgroup label="<?php echo lang('ONLINE');?>">
              <option value="PayPal"<?php if($row->method == 'PayPal') echo ' selected="selected"';?>>PayPal</option>
              <option value="MoneyBookers"<?php if($row->method == 'MoneyBookers') echo ' selected="selected"';?>>MoneyBookers</option>
              <option value="AlertPay"<?php if($row->method == 'AlertPay') echo ' selected="selected"';?>>AlertPay</option>
              <option value="AuthorizeNet"<?php if($row->method == 'AuthorizeNet') echo ' selected="selected"';?>>AuthorizeNet</option>
              </optgroup>
            </select></td>
        </tr>
          <tr>
            <th><?php echo lang('INVC_DUEDATE');?>:</th>
            <td><input name="rcreated" type="text" class="inputbox" id="rcreated" size="25" value="<?php echo $row->created;?>"/></td>
          </tr>
          <tr>
            <th><?php echo lang('DESC');?>:</th>
            <td><input name="rdesc" type="text" class="inputbox" value="<?php echo $row->description;?>" size="55" /></td>
          </tr>
          <tr>
            <th><?php echo lang('AMOUNT');?>: <?php echo required();?></th>
            <td><input name="ramount" type="text" class="inputbox" value="<?php echo $row->amount;?>" size="15" />
            <?php echo tooltip('Enter only numeric values');?></td>
          </tr>
          <tr>
            <td><input name="submit" type="submit" value="<?php echo lang('INVC_RECUPDATE');?>" class="button button-green"/></td>
            <td><a href="index.php?do=invoices&amp;action=edit&amp;pid=<?php echo $row->project_id;?>&amp;id=<?php echo $row->invoice_id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
          </tr>
        </tbody>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
      <input name="invoice_id" type="hidden" value="<?php echo $row->invoice_id;?>" />
      <input name="project_id" type="hidden" value="<?php echo $row->project_id;?>" />
    </form>
  </div>
</div>
<?php echo $core->doForm("processInvoiceRecord");?> 
<script type="text/javascript">
$(function () {
    $("#rcreated").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php case"add": ?>
<?php $prodrow = $content->getProjectList();?>
<?php $userlist = $user->getUserList(1);?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_TITLE2');?></h1>
<p class="info"><?php echo lang('INVC_INFO2') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('INVC_SUB2');?><?php echo (Filter::$id) ? lang('INVC_SUB2_1') . getValue("title","projects","id = '".Filter::$id."'") : '';?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('INVC_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_NAME');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_PROJCSELETC');?> ---</option>
              <?php if($prodrow):?>
              <?php foreach ($prodrow as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == Filter::$id) echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CLIENTSELECT');?>: <?php echo required();?></th>
          <td><select name="client_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_CLIENTSELECT');?> ---</option>
              <?php if($userlist):?>
              <?php foreach ($userlist as $srow):?>
              <option value="<?php echo $srow->id;?>"<?php if($srow->id == getValue("client_id","projects","id = '".Filter::$id."'")) echo 'selected="selected"';?>><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PAYMETHOD');?>:</th>
          <td><select class="custombox" name="method" style="width:150px">
              <option value="Offline"><?php echo lang('OFFLINE');?></option>
              <optgroup label="<?php echo lang('ONLINE');?>">
              <option value="PayPal">PayPal</option>
              <option value="MoneyBookers">MoneyBookers</option>
              <option value="AlertPay">AlertPay</option>
              <option value="AuthorizeNet">AuthorizeNet</option>
              </optgroup>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('CREATED');?>: <?php echo required();?></th>
          <td><input name="created" type="text" class="inputbox" id="datec" size="25" value="<?php echo date('Y-m-d');?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_DUEDATE');?>: <?php echo required();?></th>
          <td><input name="duedate" type="text" class="inputbox" id="dated" size="25" value="<?php echo date('Y-m-d', strtotime("+30 days"));?>"/></td>
        </tr>
        <tr>
          <td colspan="2" class="subtitle"><strong><?php echo lang('INVC_INITIALENTRY');?></strong></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_ENTRYTITLE');?>: <?php echo required();?></th>
          <td><input name="dtitle" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('AMOUNT');?>: <?php echo required();?></th>
          <td><input name="amount" type="text" class="inputbox"  size="10" />
          <?php echo tooltip(lang('INVC_AMOUNT_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('DESC');?>:</th>
          <td><input name="description" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('TAXABLE');?>:</th>
          <td><?php echo lang('YES');?>
            <input name="tax" type="radio" value="1" />
            <?php echo lang('NO');?>
            <input name="tax" type="radio" value="0" checked="checked" /></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('INVC_ADD');?>" class="button button-green"/></td>
          <td colspan="2"><?php echo (Filter::$id) ? '<a href="index.php?do=invoices&amp;id='.Filter::$id.'" class="button-alt button-gray">' .lang('CANCEL') . '</a>' : '';?></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo $core->doForm("addInvoice");?> 
<script type="text/javascript">
$(function () {
    $("#datec").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
$(function () {
    $("#dated").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php default:?>
<?php $invrow = $content->getProjectInvoices();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_TITLE3');?></h1>
<p class="info"><?php echo lang('INVC_INFO2') . lang('INVC_INFO3') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=invoices&amp;action=add&amp;id=<?php echo Filter::$id;?>" class="add"><?php echo lang('INVC_ADD');?></a></span><?php echo lang('INVC_SUB3') . getValue("title","projects","id = '".Filter::$id."'");?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('INVC_NAME');?></th>
          <th class="left"><?php echo lang('INVC_CNAME');?></th>
          <th class="left"><?php echo lang('INVC_DUEDATE');?></th>
          <th class="left"><?php echo lang('TOTAL');?></th>
          <th class="left"><?php echo lang('PAID');?></th>
          <th class="left"><?php echo lang('STATUS');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$invrow):?>
      <tr>
        <td colspan="9"><?php echo Filter::msgInfo(lang('INVC_NOINVOICE'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($invrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo $row->name;?></td>
        <td><?php echo Filter::dodate($core->short_date, $row->duedate);?></td>
        <td><?php echo $row->amount_total;?></td>
        <td><?php echo $row->amount_paid;?></td>
        <td><?php echo $row->status;?></td>
        <td align="center"><a href="index.php?do=invoices&amp;action=edit&amp;pid=<?php echo $row->project_id;?>&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id.':'.$row->project_id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('INVC_DELETEINV'),"deleteInvoice");?>
<?php break;?>
<?php endswitch;?>