<?php
  /**
   * Main
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: news.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  $row = $core->getYearlySummary();
?>
<h1><img src="../images/news.png" alt="" /><?php echo lang('DASH_TITLE');?></h1>
<p class="info"><?php echo lang('DASH_INFO');?></p>
<div class="block-border">
  <div class="block-content">
    <form method="get" action="" name="date">
      <table cellpadding="0" cellspacing="0" class="display">
        <tr>
          <td class="right subtitle"><select name="year" class="custombox" style="width:80px">
              <?php echo $core->yearList(2010, strftime('%Y')); ?>
            </select>
            <input name="submit" value="<?php echo lang('SUBMIT');?>" type="submit" class="button-alt button-blue"/>
            <select name="month" class="custombox" style="width:80px">
              <?php echo $core->monthList()?>
            </select>
            <input name="submit" value="<?php echo lang('SUBMIT');?>" type="submit" class="button-alt button-green"/></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php $reports = $core->yearlyStats();?>
<?php $reports2 = $core->projectStats();?>
<?php if($reports2):?>
<script type="text/javascript">
  $(document).ready(function(){
    var s1 = [
	<?php
		$res = '';
		foreach($reports2 as $report2) {
			if(strlen($res) > 0) {
				$res .= ",";
			}
			$res .= $report2->p_status;
		}
		print $res;
		?>
	];
    var s2 = [
	<?php
		$res2 = '';
		foreach($reports2 as $report2) {
			if(strlen($res2) > 0) {
				$res2 .= ",";
			}
			$res2 .= $core->progressBarBilling($report2->b_status, $report2->cost);
		}
		print $res2;
		?>
	];
    var ticks = [
	<?php
		$res3 = '';
		foreach($reports2 as $rep2) {
			if(strlen($res3) > 0) {
				$res3 .= "','";
			}
			$res3 .= sanitize($rep2->title,20);
		}
		?>
		'<?php print $res3;?>'
	];
    <?php unset($res, $res2, $res3);?>
    plot1 = $.jqplot('chart2', [s1, s2], {
      seriesDefaults:{
        renderer:$.jqplot.BarRenderer,
        rendererOptions: {fillToZero: false},
		pointLabels: {show: true}
      },
	  title: '<?php echo lang('DASH_PROSTATS') . Filter::doDate('%b',date("M", mktime(0, 0, 0, $core->month, 10))).' / '.$core->year;?>',
      series:[
        {label:'<?php echo lang('DASH_PRSTATUS');?>'},
        {label:'<?php echo lang('DASH_PYSTATUS');?>'}
      ],
      legend: {
        show: true,
		placement:'outsideGrid',
		location: 'ne'
      },
      axes: {
        xaxis: {
          renderer: $.jqplot.CategoryAxisRenderer,
          ticks: ticks
        },
        yaxis: {
			tickOptions:{
            formatString:'%.0f%'
            },
          autoscale: false
        }
      }
    });
  });
</script>
<?php endif;?>
<?php if($reports2 == 0):?>
<?php echo Filter::msgInfo(lang('DASH_ERR1'),false);?>
<?php else:?>
<div class="inputout">
  <div id="chart2"></div>
</div>
<?php endif;?>
<?php if($reports):?>
<script type="text/javascript">
  $(document).ready(function(){
    var s1 = [
	<?php
		$res = '';
		foreach($reports as $report) {
			if(strlen($res) > 0) {
				$res .= ",";
			}
			$res .= $report->total;
		}
		echo $res;
		?>
	];
    var s2 = [
	<?php
		$res2 = '';
		foreach($reports as $report) {
			if(strlen($res2) > 0) {
				$res2 .= ",";
			}
			$res2 .= $report->totalprice;
		}
		echo $res2;
		?>
	];
    var ticks = [
	<?php
		$res3 = '';
		foreach($reports as $rep) {
			if(strlen($res3) > 0) {
				$res3 .= "','";
			}
			$res3 .= date("M", mktime(0, 0, 0, $rep->month, 10));
		}
		?>
		'<?php print $res3;?>'
	];
    <?php unset($res, $res2, $res3);?>
    plot1 = $.jqplot('chart', [s1, s2], {
      seriesDefaults:{
        renderer:$.jqplot.BarRenderer,
        rendererOptions: {fillToZero: false},
		pointLabels: {show: true}
      },
	  title: '<?php echo lang('DASH_REVSTSTS') . $core->year;?>',
      series:[
        {label:'<?php echo lang('DASH_TOTALTRANS');?>'},
        {label:'<?php echo lang('DASH_TOTALREV');?>'}
      ],
      legend: {
        show: true,
		placement:'outsideGrid',
		location: 'ne'
      },
      axes: {
        xaxis: {
          renderer: $.jqplot.CategoryAxisRenderer,
          ticks: ticks
        },
        yaxis: {
			tickOptions:{
            //formatString:'$%.2f'
            },
          autoscale: false
        }
      }
    });
  });
</script>
<?php endif;?>
<?php if($reports == 0):?>
<?php echo Filter::msgInfo(lang('DASH_ERR2'),false);?>
<?php else:?>
<div class="inputout">
  <div id="chart"></div>
</div>
<div class="block-border" style="margin-top:5px">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="150" nowrap="nowrap"><?php echo lang('DASH_MONTHYEAR');?></th>
          <th>#<?php echo lang('TRANS');?></th>
          <th width="200" nowrap="nowrap"><?php echo lang('DASH_TOTALREV');?></th>
        </tr>
      </thead>
      <?php foreach($reports as $report):?>
      <tr>
        <td align="center"><?php echo Filter::doDate('%b',date("M", mktime(0, 0, 0, $report->month, 10))).' / '.$core->year;?></td>
        <td align="center"><?php echo $report->total;?></td>
        <td align="center"><?php echo $core->formatMoney($report->totalprice);?></td>
      </tr>
      <?php endforeach ?>
      <?php unset($report);?>
      <tr>
        <td align="center"><strong><?php echo lang('DASH_TOTALTEAR');?></strong></td>
        <td align="center"><strong><?php echo $row->total;?></strong></td>
        <td align="center"><strong><?php echo $core->formatMoney($row->totalprice);?></strong></td>
      </tr>
    </table>
  </div>
</div>
<?php endif;?>
<script language="javascript" type="text/javascript" src="../assets/jquery.jqplot.min.js"></script> 
<script language="javascript" type="text/javascript" src="../assets/jqplot.barRenderer.min.js"></script> 
<script language="javascript" type="text/javascript" src="../assets/jqplot.categoryAxisRenderer.min.js"></script> 
<script type="text/javascript" src="../assets/jqplot.pointLabels.min.js"></script> 
<!--[if lt IE 9]><script language="javascript" type="text/javascript" src="../assets/excanvas.min.js"></script><![endif]-->