<?php
  /**
   * System Announcement
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: news.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  Filter::mark('start');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("news", Filter::$id);?>
<h1><img src="../images/news.png" alt="" /><?php echo lang('NEWS_TITLE');?></h1>
<p class="info"><?php echo lang('NEWS_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('NEWS_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th width="200"><?php echo lang('NEWS_NAME');?>: <?php echo required();?></th>
            <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
          </tr>
          <tr>
            <td colspan="2"><textarea name="body" cols="20" rows="1" id="bodycontent"><?php echo $row->body;?></textarea></td>
          </tr>
          <tr>
            <th><?php echo lang('NEWS_START');?>:</th>
            <td><input name="created" type="text" class="inputbox" id="fromdate" value="<?php echo $row->created;?>" size="15" />
              <?php echo tooltip(lang('NEWS_START_T'));?></td>
          </tr>
          <tr>
            <th><?php echo lang('NEWS_ACTIVE');?>:</th>
            <td><?php echo lang('YES');?>
              <input name="active" type="radio" id="active-1"  value="1" <?php getChecked($row->active, 1); ?> />
              <?php echo lang('NO');?>
              <input name="active" type="radio" id="active-2" value="0" <?php getChecked($row->active, 0); ?> /></td>
          </tr>
          <tr>
            <td><input name="submit" type="submit" value="<?php echo lang('NEWS_UPDATE');?>" class="button button-green"/></td>
            <td><a href="index.php?do=news" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
          </tr>
        </tbody>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processNews");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor();
  });

$(function() {
	var dates = $('#fromdate, #enddate').datepicker({
		defaultDate: "+1w",
		changeMonth: false,
		numberOfMonths: 2,
		dateFormat: 'yy-mm-dd',
		onSelect: function(selectedDate) {
			var option = this.id == "fromdate" ? "minDate" : "maxDate";
			var instance = $(this).data("datepicker");
			var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
			dates.not(this).datepicker("option", option, date);
		}
	});
});
// ]]>
</script>
<?php break;?>
<?php case"add": ?>
<h1><img src="../images/news.png" alt="" /><?php echo lang('NEWS_TITLE1');?></h1>
<p class="info"><?php echo lang('NEWS_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('NEWS_SUB1');?></th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <th width="200"><?php echo lang('NEWS_NAME');?>: <?php echo required();?></th>
            <td><input name="title" type="text" class="inputbox" size="55" /></td>
          </tr>
          <tr>
            <td colspan="2"><textarea name="body" cols="20" rows="1" id="bodycontent"></textarea></td>
          </tr>
          <tr>
            <th><?php echo lang('NEWS_START');?>:</th>
            <td><input name="created" type="text" class="inputbox" id="fromdate" size="15" />
              <?php echo tooltip(lang('NEWS_START_T'));?></td>
          </tr>
          <tr>
            <th><?php echo lang('NEWS_ACTIVE');?>:</th>
            <td><?php echo lang('YES');?>
              <input name="active" type="radio" id="active-1"  value="1" checked="checked" />
              <?php echo lang('NO');?>
              <input name="active" type="radio" id="active-2" value="0"  /></td>
          </tr>
          <tr>
            <td><input name="submit" type="submit" value="<?php echo lang('NEWS_ADD');?>" class="button button-green"/></td>
            <td><a href="index.php?do=news" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
          </tr>
        </tbody>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processNews");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor();
  });

$(function() {
	var dates = $('#fromdate, #enddate').datepicker({
		defaultDate: "+1w",
		changeMonth: false,
		numberOfMonths: 2,
		dateFormat: 'yy-mm-dd',
		onSelect: function(selectedDate) {
			var option = this.id == "fromdate" ? "minDate" : "maxDate";
			var instance = $(this).data("datepicker");
			var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
			dates.not(this).datepicker("option", option, date);
		}
	});
});
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php $newsrow = Content::getNews();?>
<h1><img src="../images/news.png" alt="" /><?php echo lang('NEWS_TITLE2');?></h1>
<p class="info"><?php echo lang('NEWS_INFO2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=news&amp;action=add" class="add"><?php echo lang('NEWS_ADD');?></a></span><?php echo lang('NEWS_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('NEWS_NAME');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$newsrow):?>
      <tr>
        <td colspan="5"><?php echo Filter::msgInfo(lang('NEWS_NONEWS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($newsrow as $row):?>
      <tr>
        <th><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo Filter::dodate($core->short_date, $row->created);?></td>
        <td align="center"><a href="index.php?do=news&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>"/></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('NEWS_DELETE'),"deleteNews");?>
<?php break;?>
<?php endswitch;?>