<?php
  /**
   * Client Overview
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: overview.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php $urow = Core::getRowById("users", Filter::$id);?>
<?php $projectrow = $content->getProjectsForClient($urow->id);?>
<?php $invoicerow = $content->getInvoiceForClient($urow->id);?>
<h1><img src="../images/overview-client.png" alt="" /><?php echo lang('OVER_TITLE');?></h1>
<p class="info"><?php echo lang('OVER_INFO');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=projects" class="add"><?php echo lang('PROJ_BACK');?></a></span><?php echo lang('OVER_SUB') . $urow->fname.' '.$urow->lname;?></h2>
  </div>
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="forms">
      <tr>
        <td width="200"><?php echo lang('INVC_CNAME');?>:</td>
        <td><a href="index.php?do=client&amp;action=edit&amp;id=<?php echo $urow->id;?>"><?php echo $urow->fname.' '.$urow->lname;?></a></td>
      </tr>
      <tr>
        <td><?php echo lang('INVC_CEMAIL');?>:</td>
        <td><a href="index.php?do=email&amp;emailid=<?php echo urlencode($urow->email);?>"><?php echo $urow->email;?></a></td>
      </tr>
      <tr>
        <td><?php echo lang('OVER_NOTE');?>:</td>
        <td><?php echo cleanOut(wordwrap($urow->notes,100,'<br />'));?></td>
      </tr>
    </table>
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th width="20%" class="left"><?php echo lang('PROJ_NAME');?></th>
          <th width="15%" class="left"><?php echo lang('PROJ_MANAGER');?></th>
          <th width="15%" class="left"><?php echo lang('CREATED');?></th>
          <th class="left"><?php echo lang('STATUS');?></th>
          <th class="right"><?php echo lang('ACTIONS');?></th>
        </tr>
      </thead>
      <?php if($projectrow == 0):?>
      <tr>
        <td colspan="6"><?php echo Filter::msgAlert(lang('PROJ_NOPROJECT'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($projectrow as $row):?>
      <tr>
        <td align="center"><?php echo $row->pid;?>.</td>
        <td><?php echo $row->title;?></td>
        <td><?php echo $row->staffname;?></td>
        <td><?php echo Filter::doDate($core->short_date, $row->start);?></td>
        <td><?php echo $content->progressBarStatus($row->p_status);?></td>
        <td class="right"><a href="index.php?do=projects&amp;action=edit&amp;id=<?php echo $row->pid;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>" /></a> <a href="javascript:void(0);" class="delete" id="item_<?php echo $row->pid;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '. $row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th width="20%" class="left"><?php echo lang('INVC_NAME');?></th>
          <th width="15%" class="left"><?php echo lang('TOTAL');?></th>
          <th width="15%" class="left"><?php echo lang('PAID');?></th>
          <th class="left"><?php echo lang('OVER_BSTATUS');?></th>
          <th class="right"><?php echo lang('ACTIONS');?></th>
        </tr>
      </thead>
      <?php if(!$invoicerow):?>
      <tr>
        <td colspan="6"><?php echo Filter::msgInfo(lang('INVC_NOINVOICE2'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($invoicerow as $row):?>
      <tr>
        <td align="center"><?php echo $row->id;?>.</td>
        <td><?php echo $row->title;?></td>
        <td><?php echo $core->formatMoney($row->amount_total);?></td>
        <td><?php echo $core->formatMoney($row->amount_paid);?></td>
        <td><?php echo $content->progressBarBilling($row->amount_paid,$row->amount_total);?></td>
        <td class="right"><a href="index.php?do=invoices&amp;id=<?php echo $row->project_id;?>"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('PROJ_DELETE'),"deleteProject");?>