<?php
  /**
   * Project Submissions
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: submissions.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = $content->getProjectSubmissions(false);?>
<?php if(!$user->checkProjectAccess($row->project_id)): print Filter::msgInfo(lang('NOACCESS'), false); return; endif;?>
<?php $plist = $content->getProjectList();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('SUBS_TITLE');?></h1>
<p class="info"><?php echo lang('SUBS_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('SUBS_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('SUBS_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_NAME');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('TASK_SELPROJ');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == $row->project_id) echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_TYPE');?>:</th>
          <td><select name="s_type" class="custombox" style="width:250px">
              <?php echo $content->projectSubmissionList($row->s_type);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_DATE');?>:</th>
          <td><input name="sdate" type="text" disabled="disabled" class="inputbox" value="<?php echo Filter::dodate($core->short_date, $row->created);?>" size="42" readonly="readonly" /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" rows="1" id="bodycontent"><?php echo $row->description;?></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_STATUS');?>:</th>
          <td><?php echo $content->projectSubmissionStatus($row->status);?></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_CREVIEW');?>:</th>
          <td><?php echo cleanOut($row->review);?></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_DATEREVIEW');?>:</th>
          <td><?php echo Filter::dodate($core->long_date, $row->review_date);?></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_SENDREVIEW');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="revsend" id="revsend-1" value="1" />
            <?php echo lang('NO');?>
            <input name="revsend" type="radio" id="revsend-2" value="0" checked="checked" />
            <?php echo tooltip(lang('SUBS_SENDREVIEW_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"<?php if($srow->id == $row->staff_id)echo 'selected="selected"';?>><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_FILES');?>:</th>
          <td><?php $filerow = $content->getFilesByProject($row->project_id);?>
            <table cellpadding="0" cellspacing="0" class="display">
              <thead>
                <tr>
                  <th width="20">#</th>
                  <th class="left"><?php echo lang('FILE_NAME');?></th>
                  <th class="left"><?php echo lang('FILESIZE');?></th>
                  <th class="left"><?php echo lang('DOWNLOAD');?></th>
                  <th><?php echo lang('EDIT');?></th>
                </tr>
              </thead>
              <?php if(!$filerow):?>
              <tr>
                <td colspan="5"><?php echo Filter::msgInfo(lang('FILE_NOFILES'),false);?></td>
              </tr>
              <?php else:?>
              <?php foreach ($filerow as $frow):?>
              <tr>
                <td align="center"><?php echo $frow->id;?>.</td>
                <td><?php echo $frow->title;?></td>
                <td><?php echo getSize($frow->filesize);?></td>
                <td><a href="<?php echo UPLOADURL . 'data/' . $frow->filename;?>"><img src="../images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD');?>"/></a></td>
                <td><a href="index.php?do=files&amp;action=edit&amp;id=<?php echo $frow->id;?>"><img src="../images/edit.png" alt="" class="tooltip" title="<?php echo lang('EDIT').': '.$frow->title;?>"/></a></td>
              </tr>
              <?php endforeach;?>
              <?php unset($frow);?>
              <?php endif;?>
            </table></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('SUBS_UPDATE');?>" class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=submissions&amp;id=<?php echo $row->project_id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processSubmission");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:300});
  });
// ]]>
</script>
<?php break;?>
<?php case"add": ?>
<?php $plist = $content->getProjectList();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('SUBS_TITLE1');?></h1>
<p class="info"><?php echo lang('SUBS_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('SUBS_SUB1') . getValue("title","projects","id = '".Filter::$id."'");?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('SUBS_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_NAME');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('TASK_SELPROJ');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == Filter::$id) echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_TYPE');?>:</th>
          <td><select name="s_type" class="custombox" style="width:250px">
              <?php echo $content->projectSubmissionList();?>
            </select></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" rows="1" id="bodycontent"></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('SUBS_SENDREVIEW');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="revsend" value="1" checked="checked"/>
            <?php echo lang('NO');?>
            <input type="radio" name="revsend" value="0" />
            <?php echo tooltip(lang('SUBS_SENDREVIEW_T'));?></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_FILES');?>:</th>
          <td><?php $filerow = $content->getFilesByProject(Filter::$id);?>
            <table cellpadding="0" cellspacing="0" class="display">
              <thead>
                <tr>
                  <th width="20">#</th>
                  <th class="left"><?php echo lang('FILE_NAME');?></th>
                  <th class="left"><?php echo lang('FILESIZE');?></th>
                  <th class="left"><?php echo lang('DOWNLOAD');?></th>
                  <th><?php echo lang('EDIT');?></th>
                </tr>
              </thead>
              <?php if(!$filerow):?>
              <tr>
                <td colspan="5"><?php echo Filter::msgInfo(lang('FILE_NOFILES'),false);?></td>
              </tr>
              <?php else:?>
              <?php foreach ($filerow as $frow):?>
              <tr>
                <td align="center"><?php echo $frow->id;?>.</td>
                <td><?php echo $frow->title;?></td>
                <td><?php echo getSize($frow->filesize);?></td>
                <td><a href="<?php echo UPLOADURL . 'data/' . $frow->filename;?>"><img src="../images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD');?>"/></a></td>
                <td><a href="index.php?do=files&amp;action=edit&amp;id=<?php echo $frow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$frow->title;?>"/></a></td>
              </tr>
              <?php endforeach;?>
              <?php unset($frow);?>
              <?php endif;?>
            </table></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_ATTACH');?>:</th>
          <td><input name="filename" type="file" size="40" class="fileinput mask" /></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_NAME');?>:</th>
          <td><input name="filetitle" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <td><input name="add" type="submit" value="<?php echo lang('SUBS_ADD');?>"  class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=submissions&amp;id=<?php echo Filter::$id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processSubmission");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:300});
  });
 $(".mask").filestyle({ 
     image: "../images/file-button.png",
     imageheight : 29,
     imagewidth : 75,
     width : 230
 });
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php $subrow = $content->getProjectSubmissions();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('SUBS_TITLE2');?></h1>
<p class="info"><?php echo lang('SUBS_INFO2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=submissions&amp;action=add&amp;id=<?php echo Filter::$id;?>" class="add"><?php echo lang('SUBS_ADD');?></a></span><?php echo lang('SUBS_SUB2') . getValue("title","projects","id = '".Filter::$id."'");?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('SUBS_NAME');?></th>
          <th class="left"><?php echo lang('SUBS_TYPE');?></th>
          <th class="left"><?php echo lang('SUBS_STATUS');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <tfoot>
        <tr>
          <td colspan="6"><a href="index.php?do=projects" class="button-alt button-orange">Back to projects</a></td>
        </tr>
      </tfoot>
      <?php if(!$subrow):?>
      <tr>
        <td colspan="6"><?php echo Filter::msgAlert(lang('SUBS_NOSUBS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($subrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo $row->s_type;?></td>
        <td><?php echo $content->projectSubmissionStatus($row->status);?></td>
        <td align="center"><a href="index.php?do=submissions&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('SUBS_DELETE'),"deleteSubmission");?>
<?php break;?>
<?php endswitch;?>