<?php
  /**
   * Support Tickets
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: support.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = $content->getSupportTicketById();?>
<?php $resrow = $content->getResponseByTicketId();?>
<h1><img src="../images/support.png" alt="" /><?php echo lang('SUP_TITLE');?></h1>
<p class="info"><?php echo lang('SUP_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<?php if(!$row):?>
<?php echo Filter::msgInfo(lang('SUP_NOTICKET'),false);?>
<?php else:?>
<div class="block-border">
  <div class="block-header">
    <h2><?php echo lang('SUP_SUB') . $row->subject;?></h2>
  </div>
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellpadding="0" cellspacing="0" class="forms">
        <tr>
          <th width="200"><?php echo lang('INVC_CNAME');?>:</th>
          <td><input name="client_id" type="text" disabled="disabled"  class="inputbox" value="<?php echo $row->clientname;?>" size="55" readonly="readonly"/></td>
        </tr>
        <tr>
          <th><?php echo lang('SUP_PRIORITY');?>: </th>
          <td><select name="priority" class="custombox" style="width:150px">
              <?php echo $content->ticketPriorityList($row->priority);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUP_STATUS');?>:</th>
          <td><select name="status" class="custombox" style="width:150px">
              <?php echo $content->ticketStatusList($row->status);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUP_ASSIGNED');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"<?php if($srow->id == $row->staff_id) echo 'selected="selected"';?>><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('SUP_SUBJECT');?>:</th>
          <td><input name="subject" type="text" disabled="disabled" class="inputbox" value="<?php echo $row->subject;?>" size="70" readonly="readonly"/></td>
        </tr>
        <tr>
          <th><?php echo lang('SUP_DETAIL');?>:</th>
          <td colspan="2"><textarea name="body" cols="65" rows="5" disabled="disabled" readonly="readonly"><?php echo $row->body;?></textarea></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('SUP_UPDATE_S');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=support" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processSupportTicket");?>
<?php endif;?>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="reply_form" name="reply_form">
      <table cellpadding="0" cellspacing="0" class="forms">
        <thead>
          <tr>
            <th class="left"><?php echo lang('SUP_REPLYTO') . $row->subject;?></th>
          </tr>
        </thead>
        <tr>
          <td><textarea name="body" cols="20" rows="1" id="bodycontent"></textarea></td>
        </tr>
        <tr>
          <td><input name="doreply" id="send-reply" type="submit" value="<?php echo lang('REPLY');?>"  class="button button-blue"/></td>
        </tr>
      </table>
      <input name="replySupportTicket" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  <?php if($resrow):?>
    <div id="replydata">
      <ul id="reply-list">
        <?php foreach($resrow as $trow):?>
        <li class="<?php echo ($trow->user_type == "client") ? 'row-client' : 'row-staff';?>"><strong><?php echo lang('CREATED');?></strong>: <?php echo Filter::dodate($core->long_date, $trow->created);?> - <strong><?php echo lang('AUTHOR');?></strong>: <?php echo $trow->name;?> (<?php echo $trow->user_type;?>)<span class="delete"><a href="javascript:void(0);" class="delete" id="item_<?php echo $trow->id;?>" rel="<?php echo $trow->cdate;?>"><img src="../images/trash.png" alt="" class="tooltip" title="<?php echo lang('DELETE');?>" /></a></span>
          <div><?php echo cleanOut($trow->body);?></div>
        </li>
        <?php endforeach;?>
      </ul>
    </div>
  <?php endif;?>
  </div>
</div>
<script type="text/javascript">
// <![CDATA[
function loadEntryList() {
	$.ajax({
		type: 'post',
		url: "controller.php",
		data: 'loadReplyEntries=' + <?php echo Filter::$id;?>,
		cache: false,
		success: function (html) {
			$("#replydata").html(html);
		}
	});
	$('#loader').fadeOut(200);
}
  $(document).ready(function() {
	  $('#send-reply').click(function () {
		  var str = $("#reply_form").serialize();
		  $('#loader').fadeIn(200);
		  $.ajax({
			  type: 'post',
			  url: "controller.php",
			  data: str,
			  success: function (res) {
				  $("#msgholder").html(res);
				  $("html, body").animate({
					  scrollTop: 0
				  }, 600);
				  setTimeout(function () {
					  $(loadEntryList()).fadeIn("slow");
				  }, 2000);
			  }
		  });
		  return false;
	  });
	  
	$("#bodycontent").cleditor({height:200});
  });
// ]]>
</script> 
<?php echo Core::doDelete(lang('SUP_DELETE'),"deleteSupportReply");?>
<?php break;?>
<?php default: ?>
<?php $ticketrow = $content->getSupportTickets();?>
<h1><img src="../images/support.png" alt="" /><?php echo lang('SUP_TITLE1');?></h1>
<p class="info"><?php echo lang('SUP_INFO1');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <tr>
        <td class="subtitle"><select name="sort" class="custombox" id="ticketfilter" style="width:200px">
            <option value="NA">--- <?php echo lang('SUP_RESET');?> ---</option>
            <?php echo $content->getTicketFilter();?>
          </select></td>
        <td align="center" class="subtitle"><span class="open"></span> <?php echo lang('SUP_OPEN');?> <span class="closed"></span> <?php echo lang('SUP_CLOSED');?></td>
        <td align="right" class="subtitle"><?php echo $pager->items_per_page();?> &nbsp;&nbsp; <?php echo $pager->jump_menu();?></td>
      </tr>
    </table>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><?php echo lang('SUP_SUB1');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('SUP_SUBJECT');?></th>
          <th class="left"><?php echo lang('INVC_CNAME');?></th>
          <th class="left"><?php echo lang('SUP_ASSIGNED');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th class="left"><?php echo lang('SUP_PRIORITY1');?></th>
          <th><?php echo lang('VIEW');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="8"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <tbody>
        <?php if(!$ticketrow):?>
        <tr>
          <td colspan="8"><?php echo Filter::msgInfo(lang('SUP_NOTICKET'),false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($ticketrow as $row):?>
        <tr>
          <th class="<?php echo ($row->status == "Open") ? 'open' : 'closed';?>"><?php echo $row->id;?>.</th>
          <td><?php echo $row->subject;?></td>
          <td><a href="index.php?do=clients&amp;action=edit&amp;id=<?php echo $row->client_id;?>"><?php echo $row->clientname;?></a></td>
          <td><?php echo (!$row->staffname) ? lang('SUP_NOASSIGNED') : $row->staffname;?></td>
          <td><?php echo Filter::dodate($core->long_date, $row->created);?></td>
          <td><span class="<?php echo strtolower($row->priority);?>"><?php echo $row->priority;?></span></td>
          <td align="center"><a href="index.php?do=support&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->subject;?>"/></a></td>
          <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->subject;?>"><img src="../images/delete.png" alt=""  class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->subject;?>" /></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($row);?>
        <?php endif;?>
      </tbody>
    </table>
  </div>
</div>
<script type="text/javascript"> 
// <![CDATA[  
$(document).ready(function () {
    $('#ticketfilter').change(function () {
		var res = $("#ticketfilter option:selected").val();
		(res == "NA" ) ? window.location.href = 'index.php?do=support' : window.location.href = 'index.php?do=support&sort=' + res;
    })
});
// ]]>
</script> 
<?php echo Core::doDelete(lang('SUP_DELTICKET'),"deleteSupportTicket");?>
<?php break;?>
<?php endswitch;?>