<?php
  /**
   * Time Billing
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: timebilling.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');  
?>
<?php switch(Filter::$action): case "view": ?>
<?php $prow = Core::getRowById("projects", Filter::$id);?>
<?php if(!$user->checkProjectAccess($prow->id)): print Filter::msgAlert(lang('ADMINONLY'), false); return; endif;?>
<?php $billingrow = $content->getTimeBillingByProjectId();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('BILL_TITLE');?></h1>
<p class="info"><?php echo lang('BILL_INFO');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=invoices&amp;action=add&amp;id=<?php echo $prow->id;?>" class="add"><?php echo lang('BILL_ADD_I');?></a></span><span><a href="index.php?do=timebilling&amp;action=add&amp;id=<?php echo $prow->id;?>" class="add"><?php echo lang('BILL_ADD_B');?></a></span><?php echo lang('BILL_SUB') . $prow->title;?></h2>
  </div>
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('BILL_TNAME');?></th>
          <th class="left"><?php echo lang('TASK');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th><?php echo lang('HOURS');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$billingrow):?>
      <tr>
        <td colspan="7"><?php echo Filter::msgInfo(lang('BILL_NOBILL'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($billingrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><a href="index.php?do=tasks&amp;action=edit&amp;id=<?php echo $row->tid;?>"><?php echo $row->taskname;?></a></td>
        <td><?php echo Filter::dodate($core->short_date, $row->created);?></td>
        <td align="center"><?php echo $row->hours;?></td>
        <td align="center"><a href="index.php?do=timebilling&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>" /></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('BILL_DELETE'),"deleteTimeBillingRecord");?>
<?php break;?>
<?php case"edit": ?>
<?php $row = $content->getTimeBillingById();?>
<?php $plist = $content->getProjectList();?>	
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('BILL_TITLE1');?></h1>
<p class="info"><?php echo lang('BILL_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('BILL_SUB1') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('BILL_ENTRY');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox"  value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CNAME');?>:</th>
          <td><input name="cfullname" type="text" disabled="disabled" class="inputbox"  value="<?php echo $row->cfullname;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_PROJCSELETC');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_PROJCSELETC');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == $row->project_id)echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_NAME');?>:</th>
          <td><input name="taskname" type="text" disabled="disabled" class="inputbox"  value="<?php echo $row->taskname;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><input name="sfullname" type="text" disabled="disabled" class="inputbox"  value="<?php echo $row->sfullname;?>" size="55" readonly="readonly" /></td>
        </tr>
        <tr>
          <th><?php echo lang('BILL_DOWORK');?>:</th>
          <td><input name="created" type="text" class="inputbox" id="start_date" size="25" value="<?php echo $row->created;?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('BILL_LOWORK');?>:</th>
          <td><input name="hours" type="text" class="inputbox" size="10" value="<?php echo $row->hours;?>"/>
            <?php echo lang('HOURS');?></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" id="bodycontent" rows="1"><?php echo $row->description;?></textarea></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('BILL_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=timebilling&amp;action=view&amp;id=<?php echo $row->pid;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="staff_id" type="hidden" value="<?php echo $row->staff_id;?>" />
      <input name="client_id" type="hidden" value="<?php echo $row->client_id;?>" />
      <input name="task_id" type="hidden" value="<?php echo $row->task_id;?>" />
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processTimeRecord");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:150});
});
$(function () {
    $("#start_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php case"add": ?>
<?php $plist = $content->getProjectList();?>
<?php $userlist = $user->getUserList(1);?>
<?php $tlist = $content->getTasksByProject();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('BILL_TITLE2');?></h1>
<p class="info"><?php echo lang('BILL_INFO2') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('BILL_SUB2');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('BILL_ENTRY');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CNAME');?>:</th>
          <td><select name="client_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_CLIENTSELECT');?> ---</option>
              <?php if($userlist):?>
              <?php foreach ($userlist as $crow):?>
              <option value="<?php echo $crow->id;?>"><?php echo $crow->name;?></option>
              <?php endforeach;?>
              <?php unset($crow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_PROJCSELETC');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_PROJCSELETC');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == Filter::$id) echo ' selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_NAME');?>:</th>
          <td><select name="task_id" class="custombox" style="width:250px">
              <?php if(!$tlist):?>
              <option value="0">--- <?php echo lang('BILL_NOTASK');?> ---</option>
              <?php else:?>
              <?php foreach ($tlist as $trow):?>
              <option value="<?php echo $trow->id;?>"><?php echo $trow->title;?></option>
              <?php endforeach;?>
              <?php unset($trow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('BILL_DOWORK');?>:</th>
          <td><input name="created" type="text" class="inputbox" id="start_date" value="<?php echo date('Y-m-d');?>" size="25" /></td>
        </tr>
        <tr>
          <th><?php echo lang('BILL_LOWORK');?>:</th>
          <td><input name="hours" type="text" class="inputbox" size="10" />
          <?php echo lang('HOURS');?></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" id="bodycontent" rows="1"></textarea></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('BILL_ADD');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=timebilling&amp;action=view&amp;id=<?php echo Filter::$id;?>" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processTimeRecord");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:150});
});
$(function () {
    $("#start_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php default: ?>
<?php $timerow = $content->getTimeBilling();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('BILL_TITLE3');?></h1>
<p class="info"><?php echo lang('BILL_INFO3');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><?php if($timerow):?><span><a href="controller.php?action=createTimeReport" class="add"><?php echo lang('BILL_REPORT');?></a></span><?php endif;?><?php echo lang('BILL_SUB3');?></h2>
  </div>
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('PROJ_NAME');?></th>
          <th class="left"><?php echo lang('INVC_CNAME');?></th>
          <th><?php echo lang('BILL_RECORDS');?></th>
          <th><?php echo lang('HOURS');?></th>
          <th><?php echo lang('VIEW');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="7"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <?php if(!$timerow):?>
      <tr>
        <td colspan="7"><?php echo Filter::msgInfo(lang('BILL_NORECORDS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($timerow as $row):?>
      <tr>
        <th align="center"><?php echo $row->pid;?>.</th>
        <td><?php echo $row->ptitle;?></td>
        <td><?php echo $row->fullname;?></td>
        <td align="center"><?php echo $row->totalprojects;?></td>
        <td align="center"><?php echo $row->totalhours;?></td>
        <td align="center"><a href="index.php?do=timebilling&amp;action=view&amp;id=<?php echo $row->pid;?>"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->ptitle;?>" /></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->pid;?>" rel="<?php echo $row->ptitle;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->ptitle;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('BILL_DELETE1'),"deleteTimeBilling");?>
<?php break;?>
<?php endswitch;?>