<?php
  /**
   * Project Types
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: types.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("project_types", Filter::$id);?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TYPE_TITLE');?></h1>
<p class="info"><?php echo lang('TYPE_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('TYPE_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('TYPE_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" id="bodycontent" rows="1"><?php echo $row->description;?></textarea></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('TYPE_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=types" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectType");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
// ]]>
</script>
<?php break;?>
<?php case"add": ?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TYPE_TITLE1');?></h1>
<p class="info"><?php echo lang('TYPE_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('TYPE_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('TYPE_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox"  size="55" /></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="description" cols="20" id="bodycontent" rows="1"></textarea></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('TYPE_ADD');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=types" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectType");?> 
<script type="text/javascript">
// <![CDATA[
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php $typerow = $content->getProjectTypes();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TYPE_TITLE2');?></h1>
<p class="info"><?php echo lang('TYPE_INFO2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=types&amp;action=add" class="add"><?php echo lang('TYPE_ADD');?></a></span><?php echo lang('TYPE_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('TYPE_NAME');?></th>
          <th class="left"><?php echo lang('TYPE_DESC');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if(!$typerow):?>
      <tr>
        <td colspan="5"><?php echo Filter::msgInfo(lang('TYPE_NOTYPES'), false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($typerow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo $row->description;?></td>
        <td align="center"><a href="index.php?do=types&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>" /></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('TYPE_DELTYPE'), "deleteProjectType");?>
<?php break;?>
<?php endswitch;?>