<?php
  /**
   * Controller
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: controller.php, v1.00 2011-11-10 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  require_once("../init.php");

  if (!$user->logged_in)
      redirect_to("../index.php");
?>
<?php
  /* == Proccess User == */
  if (isset($_POST['processUser'])):
      if (intval($_POST['processUser']) == 0 || empty($_POST['processUser'])):
          redirect_to("../account.php");
      endif;
      $user->updateProfile();
  endif;
?>
<?php
  /* == Proccess Submission == */
  if (isset($_POST['processSubmissionRecord'])):
      if (intval($_POST['processSubmissionRecord']) == 0 || empty($_POST['processSubmissionRecord'])):
          redirect_to("../account.php");
      endif;

      $id = intval($_POST['processSubmissionRecord']);
      $data = array(
			'status' => intval($_POST['status']), 
			'review' => sanitize($_POST['review']), 
			'reviewed' => 1,
			'review_date' => "NOW()"
	  );

      $db->update("submissions", $data, "id='" . (int)$id . "'");
      print ($db->affected()) ? Filter::msgOk(lang('FPRO_SUBSENTOK')) : Filter::msgAlert(lang('NOPROCCESS'));;
	  
	  require_once (BASEPATH . "lib/class_mailer.php");
	  $row = $user->getSingleSubmissionsById($id );
	  $mailer = $mail->sendMail();
	  $subject = lang('FPRO_SUBESUBJECT') . $row->title;

	  ob_start();
	  require_once (BASEPATH . 'mailer/Submission_From_Client.tpl.php');
	  $html_message = ob_get_contents();
	  ob_end_clean();
	  
	  $msg = Swift_Message::newInstance()
			  ->setSubject($subject)
			  ->setTo(array($row->email => $row->staffname))
			  ->setFrom(array(Registry::get("Core")->site_email => Registry::get("Core")->company))
			  ->setBody($html_message, 'text/html');

	  $mailer->send($msg);
  endif;
?>
<?php
  /* == Proccess Project File == */
  if (isset($_POST['processProjectFile'])):
      if (intval($_POST['processProjectFile']) == 0 || empty($_POST['processProjectFile'])):
          die();
      endif;
      $user->processProjectFile();
  endif;
?>
<?php
  /* == Proccess Contact Request == */
  if (isset($_POST['processContact'])):
      if (intval($_POST['processContact']) == 0 || empty($_POST['processContact'])):
          die();
      endif;

      if (empty($_POST['subject']))
          Filter::$msgs['subject'] = lang('FMSG_MSGERR1');
		   
      if (empty($_POST['message']))
          Filter::$msgs['message'] = lang('FMSG_MSGERR2');
		  
      if (empty(Filter::$msgs)) {
		  $data = array(
				'recipient' => intval($_POST['staff_id']),
				'sender' => $user->uid, 
				'created' => 'NOW()', 
				'msgsubject' => sanitize($_POST['subject']), 
				'body' => $_POST['message']
		  );
		  if (Filter::$id) {
			  $data['status_s'] = 1;
			  $data['status_r'] = 1;
		  } else {
			  $data['status_s'] = 1;
			  $data['status_r'] = 0;
		  }
		 (Filter::$id) ? $db->update("messages", $data, "id='" . Filter::$id . "'") : $db->insert("messages", $data);

		  print 'OK';

      } else 
          print Filter::msgStatus();
  endif;
  
  /* == Delete Message == */
  if (isset($_POST['deleteMessage']))
      : if (intval($_POST['deleteMessage']) == 0 || empty($_POST['deleteMessage']))
      : die();
  endif;
  
  $id = intval($_POST['deleteMessage']);
  $db->delete("messages", "id='" . $id . "' AND sender='" . $user->uid . "' OR recipient='" . $user->uid . "'");
  $title = sanitize($_POST['title']);
  
  print ($db->affected()) ? Filter::msgOk(str_replace("[MESSAGE]", $title, lang('MSG_DELETE_OK'))) : Filter::msgAlert(lang('NOPROCCESS'));
  endif;
?>
<?php
  /* == Load Gateways == */
  if (isset($_POST['loadgateway'])):
      if (intval($_POST['loadgateway']) == 0 || empty($_POST['loadgateway'])):
          die();
      endif;
      $gate_id = intval($_POST['loadgateway']);
      $inv_id = intval($_POST['invoice_id']);
      $amount = floatval($_POST['amount']);
      $pamount = floatval($_POST['pamount']);
      if ($amount == 0 or (empty($amount)) or $amount > $pamount) {
          print Filter::msgError(lang('FBILL_ERR1'));
      } else {
          if ($gate_id == 100) {
              print '<p class="info">' . cleanOut($core->offline_info) . '<p>';
          } else {
              $row = $core->getRowById("gateways", $gate_id, false, false);
              $row2 = $user->getInvoiceById($inv_id);

              $form_url = BASEPATH . "gateways/" . $row->dir . "/form.tpl.php";
              (file_exists($form_url)) ? include ($form_url) : Filter::msgError(lang('FBILL_ERR2'));
          }
      }
  endif;
?>
<?php
  /* == Reply Support Ticket == */
  if (isset($_POST['replySupportTicket'])):
      if (intval($_POST['replySupportTicket']) == 0 || empty($_POST['replySupportTicket'])):
          die();
      endif;
      Filter::$id = intval($_POST['replySupportTicket']); 
      $user->replySupportTicket();
  endif;

  /* == Load Support Ticket == */
  if (isset($_POST['loadReplyEntries'])):
      if (intval($_POST['loadReplyEntries']) == 0 || empty($_POST['loadReplyEntries'])):
          die();
      endif;
	  
      Filter::$id = intval($_POST['loadReplyEntries']);
      $resrow = $user->getResponseByTicketId();

      if ($resrow):
          print '<ul id="reply-list">';
          foreach ($resrow as $trow):
              $class = ($trow->user_type == "client") ? 'row-client' : 'row-staff';
			  $type = ($trow->user_type == "client") ? lang('YOU') : lang('STAFF');
              print '<li class="' . $class . '">'
			  . '<strong>' . lang('CREATED') . '</strong>: ' . $trow->cdate . ' - <strong>' . lang('AUTHOR') . '</strong>: ' . $trow->name . ' [' . $type . ']';
              print '<div>' . cleanOut($trow->body) . '</div></li>';
          endforeach;
          print '</ul>';
      endif;
  endif;

  /* == Close Ticket Status == */
  if (isset($_POST['closeTicket'])):
      if (intval($_POST['closeTicket']) == 0 || empty($_POST['closeTicket'])):
          die();
      endif;
	  print 'ok';
      $id = intval($_POST['closeTicket']); 
	  $data['status'] = 'Closed';
      $db->update("support_tickets", $data, "id = '" . $id . "'");
  endif;
  
  /* == Proccess Ticket == */
  if (isset($_POST['processSupportTicket'])):
      if (intval($_POST['processSupportTicket']) == 0 || empty($_POST['processSupportTicket'])):
          die();
      endif;
      $user->processSupportTicket();
  endif;
?>
<?php
  /* == Make Pdf == */
  if (isset($_GET['dopdf'])):
      if (intval($_GET['dopdf']) == 0 || empty($_GET['dopdf'])):
          redirect_to("../account.php");
      endif;
	  
	  Filter::$id = intval($_GET['dopdf']);
	  $title = sanitize($_GET['title']);
	  ob_start();
	  require_once(BASEPATH . 'print_pdf.php');
	  $pdf_html = ob_get_contents();
	  ob_end_clean();

	  require_once(BASEPATH . 'lib/dompdf/dompdf_config.inc.php');
	  $dompdf = new DOMPDF();
	  $dompdf->load_html($pdf_html);
	  $dompdf->render();
	  $dompdf->stream($title . ".pdf");
  endif;
?>