<?php
  /**
   * Billing
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: billing.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  if(isset($_GET['msg']) and $_GET['msg'] == 6) Filter::msgOk(lang('FBILL_PAYOK'),false);
?>
<?php switch(Filter::$action): case "invoice": ?>
<?php $row = $user->getInvoiceById();?>
<?php if(!$row):?>
<?php echo Filter::msgError(lang('FBILL_ERR'),false);?>
<?php else:?>
<?php $gaterow = $content->getGateways(true);?>
<?php $amount = $row->amount_total - $row->amount_paid;?>
<h1><img src="images/billing-front.png" alt="" /><?php echo lang('FBILL_TITLE');?></h1>
<table cellspacing="0" cellpadding="0" class="forms">
  <thead>
    <tr>
      <th colspan="2" class="left"><?php echo lang('FBILL_SUB') . $row->ptitle;?></th>
    </tr>
  </thead>
  <tr>
    <th width="200"><?php echo lang('INVC_NAME');?>:</th>
    <td><?php echo $row->title;?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_DUEDATE');?>:</th>
    <td><?php echo Filter::doDate($core->short_date, $row->duedate);?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_TOTAL');?>:</th>
    <td><?php echo $row->amount_total;?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_PAID');?>:</th>
    <td><?php echo $row->amount_paid;?></td>
  </tr>
  <tr>
    <th><?php echo $core->tax_name;?>:</th>
    <td><?php echo $row->tax;?></td>
  </tr>
  <tr>
    <th><?php echo lang('FBILL_PENDING');?>:</th>
    <td><?php echo $core->formatMoney($row->amount_total - $row->amount_paid);?></td>
  </tr>
  <tr>
    <th><?php echo lang('FBILL_PAYNOW');?>:</th>
    <td class="red"><?php echo $core->cur_symbol;?> 
    <input name="amount" type="text" class="inputbox2" id="total_amount" value="<?php echo $amount;?>" size="12" />
	<?php echo $core->currency;?>
    <?php echo tooltip(lang('FBILL_PAYNOW_T'));?></td>
  </tr>
  <tr>
    <td><a href="account.php?do=billing" class="button-alt"><?php echo lang('CANCEL');?></a></td>
    <td><?php if ($gaterow):?>
      <?php foreach ($gaterow as $grow):?>
      <span class="input-out"><a href="javascript:void(0);" class="load-gateway" id="item_<?php echo $grow->id;?>"> <img src="gateways/<?php echo $grow->dir.'/'.$grow->displayname.'.png';?>" alt="" class="tooltip" title="<?php echo $grow->displayname;?>"/></a></span>
      <?php endforeach;?>
      <?php endif;?>
      <?php if ($core->enable_offline):?>
      <span class="input-out"><a href="javascript:void(0);" class="load-gateway" id="item_100"> <img src="images/check.png" alt="" class="tooltip" title="<?php echo lang('OFFLINE');?>"/></a></span>
      <?php endif;?></td>
  </tr>
</table>
<div id="show-result"></div>
<script type="text/javascript">
// <![CDATA[
$(document).ready(function () {
    $("a.load-gateway").live("click", function () {
        var parent = $(this);
        gdata = 'loadgateway=' + $(this).attr('id').replace('item_', '');
        gdata += '&invoice_id=<?php echo $row->id;?>';
		gdata += '&amount=' + $("#total_amount").val();
		gdata += '&pamount=<?php echo $amount;?>';
        $.ajax({
            type: "POST",
            url: "ajax/controller.php",
            data: gdata,
            success: function (msg) {
                $("#show-result").html(msg);
            }
        });
        return false;
    });
});
// ]]>
</script>
<?php endif;?>
<?php break;?>
<?php case "viewinvoice": ?>
<?php
  $row = $user->getProjectInvoiceById();
  $invdata = $user->getProjectInvoiceData();
  $paydata = $user->getProjectInvoicePayments();
  ?>
<?php if(!$row):?>
<?php echo Filter::msgError(lang('FBILL_ERR'),false);?>
<?php else:?>
<h1><img src="images/billing-front.png" alt="" /><?php echo lang('FBILL_TITLE2');?></h1>
<div class="box">
<table cellspacing="0" cellpadding="0" class="forms">
  <thead>
    <tr>
      <th colspan="2" class="left"><?php echo lang('FBILL_SUB2') . $row->ptitle;?></th>
    </tr>
  </thead>
  <tr>
    <th width="200"><?php echo lang('INVC_NAME');?>:</th>
    <td><?php echo $row->title;?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_DUEDATE');?>:</th>
    <td><?php echo Filter::doDate($core->short_date, $row->duedate);?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_TOTAL');?>:</th>
    <td><?php echo $row->amount_total;?></td>
  </tr>
  <tr>
    <th><?php echo lang('INVC_PAID');?>:</th>
    <td><?php echo $row->amount_paid;?></td>
  </tr>
  <tr>
    <th><?php echo $core->tax_name;?>:</th>
    <td><?php echo $row->tax;?></td>
  </tr>
  <tr>
    <th><?php echo lang('FBILL_PENDING');?>:</th>
    <td><?php echo $core->formatMoney($row->amount_total - $row->amount_paid);?></td>
  </tr>
  <tr>
    <td colspan="2"><a href="javascript:void(0);" onclick="javascript:void window.open('print_invoice.php?id=<?php echo $row->id;?>','printer','width=800,height=600,toolbar=0,menubar=0,location=0,status=0,scrollbars=1,resizable=1,left=0,top=0');return false;"><img src="images/print-large.png" alt="" title="<?php echo lang('INVC_PRINT_T');?>" class="tooltip img-wrap"/></a> <a href="ajax/controller.php?dopdf=<?php echo $row->id;?>&amp;title=<?php echo $row->title;?>"><img src="images/pdf-icon.png" alt="" title="<?php echo lang('INVC_PDF_T');?>" class="tooltip img-wrap"/></a></td>
    </tr>
</table>
</div>
<br />
<div class="box">
<h2><?php echo lang('FBILL_SUB3');?></h2>
<table cellpadding="0" cellspacing="0" class="display">
  <thead>
    <tr>
      <th width="20">#</th>
      <th width="20%" nowrap="nowrap" class="left"><?php echo lang('BILL_ENTRY');?></th>
      <th width="40%" class="left"><?php echo lang('DESC');?></th>
      <th class="left"><?php echo lang('AMOUNT');?></th>
      <th width="100" class="left"><?php echo lang('TAX');?></th>
    </tr>
  </thead>
  <?php if(!$invdata):?>
  <tr>
    <td colspan="5"><?php echo Filter::msgInfo(lang('INVC_NOENTRY'),false);?></td>
  </tr>
  <?php else:?>
  <?php foreach ($invdata as $irow):?>
  <tr>
    <td align="center"><small><?php echo $irow->id;?>.</small></td>
    <td><?php echo $irow->title;?></td>
    <td><?php echo $irow->description;?></td>
    <td><?php echo $irow->amount;?></td>
    <td><?php echo $irow->tax;?></td>
  </tr>
  <?php endforeach;?>
  <?php unset($irow);?>
  <?php endif;?>
</table>
<br />
<h2><?php echo lang('FBILL_SUB4');?></h2>
<table cellpadding="0" cellspacing="0" class="display">
  <thead>
    <tr>
      <th width="20">#</th>
      <th width="20%" nowrap="nowrap" class="left"><?php echo lang('INVC_RECPAID');?></th>
      <th width="40%" class="left"><?php echo lang('DESC');?></th>
      <th class="left"><?php echo lang('AMOUNT');?></th>
      <th width="100" class="left"><?php echo lang('FDASH_METHOD');?></th>
    </tr>
  </thead>
  <?php if(!$paydata):?>
  <tr>
    <td colspan="5"><?php echo Filter::msgInfo(lang('INVC_NORECORD'),false);?></td>
  </tr>
  <?php else:?>
  <?php foreach ($paydata as $prow):?>
  <tr>
    <td align="center"><small><?php echo $prow->id;?>.</small></td>
    <td><?php echo $prow->cdate;?></td>
    <td><?php echo $prow->description;?></td>
    <td><?php echo $prow->amount;?></td>
    <td><?php echo $prow->method;?></td>
  </tr>
  <?php endforeach;?>
  <?php unset($prow);?>
  <?php endif;?>
</table>
</div>
<?php endif;?>
<?php break;?>
<?php default: ?>
<?php  $invactive = $user->getClientInvoices("<> 'Paid'");?>
<?php  $invarchive = $user->getClientInvoices("='Paid'");?>
<h1><img src="images/billing-front.png" alt="" /><?php echo lang('FBILL_TITLE3');?></h1>
<p class="info"><?php echo lang('FBILL_INFO');?></p>
<h2><img src="images/invoice-active.png" alt="" /><?php echo lang('FDASH_SUB1');?></h2>
<?php if(!$invactive):?>
<?php echo Filter::msgInfo(lang('FBILL_NOPENDING'),false);?>
<?php else:?>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th width="30%" class="left"><?php echo lang('INVC_NAME');?></th>
        <th class="left"><?php echo lang('INVC_DUEDATE');?></th>
        <th class="left"><?php echo lang('TOTAL');?></th>
        <th class="left"><?php echo lang('PAID');?></th>
        <th class="left"><?php echo lang('FDASH_METHOD');?></th>
        <th width="100"><?php echo lang('ACTION');?></th>
      </tr>
    </thead>
    <?php foreach ($invactive as $row):?>
    <tr>
      <td align="center" class="red"><small><?php echo $row->id;?></small></td>
      <td><a href="account.php?do=billing&amp;action=viewinvoice&amp;id=<?php echo $row->id;?>"><?php echo $row->title;?></a></td>
      <td><?php echo Filter::doDate($core->short_date, $row->duedate);?></td>
      <td><?php echo $row->amount_total;?></td>
      <td><?php echo $row->amount_paid;?></td>
      <td><?php echo $row->method;?></td>
      <td align="center" class="red"><a href="account.php?do=billing&amp;action=invoice&amp;id=<?php echo $row->id;?>"><?php echo lang('FDASH_PAY');?></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<?php endif;?>
<br />
<h2><img src="images/invoice-archive.png" alt="" /><?php echo lang('FBILL_SUB5');?></h2>
<?php if(!$invarchive):?>
<?php echo Filter::msgInfo('<span>Info!</span>You don\'t have any paid invoices yet...',false);?>
<?php else:?>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th width="30%" class="left"><?php echo lang('INVC_NAME');?></th>
        <th class="left"><?php echo lang('INVC_RECPAID');?></th>
        <th class="left"><?php echo lang('TOTAL');?></th>
        <th class="left"><?php echo lang('PAID');?></th>
        <th class="left"><?php echo lang('FDASH_METHOD');?></th>
        <th width="100"><?php echo lang('ACTION');?></th>
      </tr>
    </thead>
    <?php foreach ($invarchive as $row):?>
    <tr>
      <td align="center" class="green"><small><?php echo $row->id;?></small></td>
      <td><a href="account.php?do=billing&amp;action=viewinvoice&amp;id=<?php echo $row->id;?>"><?php echo $row->title;?></a></td>
      <td><?php echo Filter::doDate($core->short_date, $row->duedate);?></td>
      <td><?php echo $row->amount_total;?></td>
      <td><?php echo $row->amount_paid;?></td>
      <td><?php echo $row->method;?></td>
      <td align="center" class="green"><a href="javascript:void(0);" onclick="javascript:void window.open('print_invoice.php?id=<?php echo $row->id;?>','printer','width=800,height=600,toolbar=0,menubar=0,location=0,status=0,scrollbars=1,resizable=1,left=0,top=0');return false;"><?php echo lang('INVC_PRINT_T');?></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<?php endif;?>
<?php break;?>
<?php endswitch;?>