<?php
  /**
   * Contact
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: contact.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "view": ?>
<?php $row = $user->getMessageById();?>
<h1><img src="images/contact-front.png" alt="" /><?php echo lang('FMSG_TITLE1');?></h1>
<p class="info"><?php echo lang('FMSG_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="box">
  <table cellspacing="0" cellpadding="0" class="forms">
    <thead>
      <tr>
        <th colspan="2" class="left"><?php echo lang('FMSG_SUB3') . $row->msgsubject;?></th>
      </tr>
    </thead>
    <tr>
      <th width="200"><?php echo lang('MSG_SENDER');?>:</th>
      <td><?php echo $row->name;?></td>
    </tr>
    <tr>
      <th><?php echo lang('MSG_SENT');?>:</th>
      <td><?php echo Filter::doDate($core->long_date, $row->created);?></td>
    </tr>
  </table>
  <div id="fullform">
  <form action="" method="post" id="admin_form" name="admin_form">
    <table cellspacing="0" cellpadding="0" class="forms">
      <tr>
        <th width="200"><?php echo lang('MSG_SUBJECT');?>: <?php echo required();?></th>
        <td><input name="subject" type="text" class="inputbox" value="<?php echo $row->msgsubject;?>" size="55"/></td>
      </tr>
      <tr>
        <td colspan="2"><textarea name="message" cols="20" rows="1" id="bodycontent"><?php echo $row->body;?></textarea></td>
      </tr>
      <tr>
        <td><input name="update" type="submit" value="<?php echo lang('REPLY');?>" class="button"/></td>
        <td><a href="account.php?do=contact" class="button-alt-sml"><?php echo lang('CANCEL');?></a></td>
      </tr>
    </table>
    <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    <input name="staff_id" type="hidden" value="<?php echo $row->recipient;?>" />
  </form>
  </div>
</div>
<script type="text/javascript">
// <![CDATA[
  function showLoader() {
      $("#loader").fadeIn(200);
  }

  function hideLoader() {
      $("#loader").fadeOut(200);
  };

  function showResponse(msg) {
      hideLoader();
      if (msg == 'OK') {
          result = '<div class="msgOk"><?php echo lang('FMSG_MSGOK');?><\/div>';
          $("#fullform").hide();
      } else {
          result = msg;
      }
      $(this).html(result);
      $("html, body").animate({
          scrollTop: 0
      }, 600);
  }
  $(document).ready(function () {
      $("#bodycontent").cleditor({height:220});
      var options = {
          target: "#msgholder",
          beforeSubmit: showLoader,
          success: showResponse,
          url: "ajax/controller.php",
          resetForm: 0,
          clearForm: 0,
          data: {
              processContact: 1
          }
      };
      $("#admin_form").ajaxForm(options);
  });
// ]]>
</script>
<?php break;?>
<?php default: ?>
<?php $newsrow = $user->getLatestNews();?>
<?php $msgrow = $user->getMessages();?>
<h1><img src="images/contact-front.png" alt="" /><?php echo lang('FMSG_TITLE');?></h1>
<p class="info"><?php echo lang('FMSG_INFO');?></p>
<?php if($newsrow):?>
<h2><?php echo lang('FMSG_SUB');?></h2>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="100" nowrap="nowrap" class="left"><?php echo lang('FMSG_POSTED');?></th>
        <th nowrap="nowrap" class="left"><?php echo lang('AUTHOR');?></th>
        <th class="left"><?php echo lang('FMSG_CONTENT');?></th>
      </tr>
    </thead>
    <?php foreach ($newsrow as $row):?>
    <tr>
      <td><?php echo Filter::doDate($core->short_date, $row->start);?></td>
      <td><?php echo $row->author;?></td>
      <td><?php echo cleanOut($row->body);?></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<br />
<?php endif;?>
<h2><?php echo lang('FMSG_SUB4');?></h2>
<?php if(!$msgrow):?>
<?php echo Filter::msgInfo(lang('MSG_NOMSG'),false);?>
<?php else:?>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20"></th>
        <th class="left"><?php echo lang('MSG_SENDER');?></th>
        <th class="left"><?php echo lang('MSG_SUBJECT');?></th>
        <th class="left"><?php echo lang('MSG_SENT');?></th>
        <th><?php echo lang('VIEW');?></th>
        <th><?php echo lang('DELETE');?></th>
      </tr>
    </thead>
    <?php foreach ($msgrow as $row):?>
    <tr>
      <th class="<?php echo ($row->status_r) ? 'closed' : '';?>">...</th>
      <td><?php echo $row->staffname;?></td>
      <td><?php echo $row->msgsubject;?></td>
      <td><?php echo Filter::doDate($core->long_date, $row->created);?></td>
      <td align="center"><a href="account.php?do=contact&amp;action=view&amp;id=<?php echo $row->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW');?>"/></a></td>
      <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->staffname;?>"><img src="images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE');?>" /></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<br />
<?php endif;?>
<div id ="fullform">
  <h2><?php echo lang('FMSG_SUB2');?></h2>
  <div class="box">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table border="0" cellpadding="3" cellspacing="0" class="display">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FMSG_SUB2');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('MAIL_REC_SUJECT');?>: <?php echo required();?></th>
          <td><input name="subject" type="text" class="inputbox" size="45" style=" width:400px"/></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:410px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="message" id="bodycontent" cols="45" rows="5"></textarea></td>
        </tr>
        <tr>
          <td colspan="2"><input name="submit" type="submit" value="<?php echo lang('FMSG_SEND');?>"  class="button"/></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doDelete(lang('MSG_DELETE'),"deleteMessage","item_","a.delete","dialog-confirm","ajax/controller.php");?> 
<script type="text/javascript">
// <![CDATA[
  function showLoader() {
      $("#loader").fadeIn(200);
  }

  function hideLoader() {
      $("#loader").fadeOut(200);
  };

  function showResponse(msg) {
      hideLoader();
      if (msg == 'OK') {
          result = '<div class="msgOk"><?php echo lang('FMSG_MSGOK');?><\/div>';
          $("#fullform").hide();
      } else {
          result = msg;
      }
      $(this).html(result);
      $("html, body").animate({
          scrollTop: 0
      }, 600);
  }
  $(document).ready(function () {
	  $("#bodycontent").cleditor({height:220});
      var options = {
          target: "#msgholder",
          beforeSubmit: showLoader,
          success: showResponse,
          url: "ajax/controller.php",
          resetForm: 0,
          clearForm: 0,
          data: {
              processContact: 1
          }
      };
      $("#admin_form").ajaxForm(options);
  });
// ]]>
</script>
<?php break;?>
<?php endswitch;?>