<?php
  /**
   * Forms
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: forms.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  require_once("init.php");
  
  require_once(BASEPATH . "lib/class_forms.php");
  Registry::set('Forms',new Forms());
  $forms = Registry::get("Forms");
  
  $row = $forms->getSingleForms();
?>
<?php include("header.php");?>
<h1><?php echo $row->title;?></h1>
<p class="info"><?php echo lang('FFORM_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<?php if(!$row):?>
<?php echo Filter::msgError(lang('FFORM_ERR'),false);?>
<?php else:?>
<div id="response"></div>
<div id="fullform" style="padding-top:10px">
  <div class="box">
    <form id="visual-form" name="admin_form" method="post" action="">
      <?php echo $forms->generate_html($row->form_data);?>
      <div class="visual-form">
        <ul>
          <?php if($row->captcha):?>
          <li class="input_text required" id="fld-captcha">
            <label for="fld-captcha"><?php echo lang('FORM_ERROR6');?>:</label>
            <input name="captcha" type="text" id="captcha-code" size="10" maxlength="5" />
            <img src="lib/captcha.php" alt="" class="captcha" />
            <input name="has_captcha" type="hidden" value="1" />
          </li>
          <?php endif;?>
          <li style="position:relative">
            <input type="submit" name="dosubmit" value="<?php echo $row->submit_btn;?>" class="button"/>
            <span id="smloading" style="position:absolute;margin-left:10px;margin-top:5px;display:none"> <img src="images/ajax-loader.gif" alt=""/></span> </li>
        </ul>
      </div>
      <input name="form_id" type="hidden" value="<?php echo $row->id;?>" />
    </form>
  </div>
</div>
<script type="text/javascript">
// <![CDATA[
  function showsmLoader() {
	  $('#smloading').fadeIn(200);
  }
  function hidesmLoader() {
	  $('#smloading').fadeOut(200);
  };
  $(function () {
	  $(".pickdate").datepicker({
		  changeMonth: true,
		  changeYear: true,
		  yearRange: '1930',
		  dateFormat: '<?php echo $forms->dateformat;?>'
	  });
  });
  $(".pickfile").filestyle({
	  image: "images/file-button.png",
	  imageheight: 29,
	  imagewidth: 75,
	  width: 230
  });
  
  function showLoader() {
	  $("#loader").fadeIn(200);
  }
  
  function hideLoader() {
	  $("#loader").fadeOut(200);
  };
  
  function showResponse(msg) {
	  hidesmLoader();
	  if (msg == 'OK') {
		  result = '<div class="msgOk"><span>Success!</span><?php echo $row->sendmessage;?><\/div>';
		  $("#fullform").hide();
	  } else {
		  result = msg;
	  }
	  $(this).html(result);
	  $("html, body").animate({
		  scrollTop: 0
	  }, 600);
  }
  $(document).ready(function () {
	  var options = {
		  target: "#response",
		  beforeSubmit: showsmLoader,
		  success: showResponse,
		  url: "ajax/sendform.php",
		  data: {
			  processForm: 1
		  }
	  };
	  $("#visual-form").ajaxForm(options);
  });
// ]]>
</script>
<?php endif;?>
<?php include("footer.php");?>