<?php
  /**
   * Authorize.Net Form
   *
   * @package Digital Downloads Pro
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: form.tpl.php, v2.00 2011-04-20 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
  
  $userdata = $user->getUserInfo($user->username);
  
  $months = array();
  
  for ($i = 1; $i <= 12; $i++) {
      $months[] = array(
		  'text' => strftime('%B', mktime(0, 0, 0, $i, 1, 2000)), 
		  'value' => sprintf('%02d', $i)
	  );
  }
  
  $today = getdate();
  $year_expire = array();
  
  for ($i = $today['year']; $i < $today['year'] + 11; $i++) {
      $year_expire[] = array(
		  'text' => strftime('%Y', mktime(0, 0, 0, 1, 1, $i)), 
		  'value' => strftime('%Y', mktime(0, 0, 0, 1, 1, $i))
	  );
  }
?>
<br />
<div class="box">
  <form action="" method="post" id="an_form" name="an_form">
    <table cellpadding="0" cellspacing="0" class="display">
      <tbody>
        <tr>
          <td colspan="2" align="center"><strong>Billing Information</strong></td>
        </tr>
        <tr>
          <th width="200">First Name: <?php echo required();?></th>
          <td><input name="fname" type="text" class="inputbox"value="<?php echo $userdata->fname;?>" size="45" /></td>
        </tr>
        <tr>
          <th>Last Name: <?php echo required();?></th>
          <td><input name="lname" type="text" class="inputbox" value="<?php echo $userdata->lname;?>" size="45" /></td>
        </tr>
        <tr>
          <th>Address: <?php echo required();?></th>
          <td><input name="address" type="text" class="inputbox" value="<?php echo $userdata->address;?>" size="45" /></td>
        </tr>
        <tr>
          <th>City: <?php echo required();?></th>
          <td><input name="city" type="text" class="inputbox" value="<?php echo $userdata->city;?>" size="45" /></td>
        </tr>
        <tr>
          <th>Country: <?php echo required();?></th>
          <td><select name="country" id="country" class="select">
              <option value="">--- Please Select ---</option>
              <option value="US" selected>United States</option>
              <option value="CA">Canada</option>
              <option value="UK">United Kingdom</option>
              <option value="AU">Australia</option>
              <option value="AF">Afghanistan</option>
              <option value="AL">Albania</option>
              <option value="DZ">Algeria</option>
              <option value="AS">American Samoa</option>
              <option value="AD">Andorra</option>
              <option value="AO">Angola</option>
              <option value="AI">Anguilla</option>
              <option value="AQ">Antarctica</option>
              <option value="AG">Antigua and Barbuda</option>
              <option value="AR">Argentina</option>
              <option value="AM">Armenia</option>
              <option value="AW">Aruba</option>
              <option value="AT">Austria</option>
              <option value="AZ">Azerbaijan</option>
              <option value="BS">Bahamas</option>
              <option value="BH">Bahrain</option>
              <option value="BD">Bangladesh</option>
              <option value="BB">Barbados</option>
              <option value="BY">Belarus</option>
              <option value="BE">Belgium</option>
              <option value="BZ">Belize</option>
              <option value="BJ">Benin</option>
              <option value="BM">Bermuda</option>
              <option value="BT">Bhutan</option>
              <option value="BO">Bolivia</option>
              <option value="BA">Bosnia and Herzegovina</option>
              <option value="BW">Botswana</option>
              <option value="BR">Brazil</option>
              <option value="BN">Brunei Darussalam</option>
              <option value="BG">Bulgaria</option>
              <option value="BF">Burkina Faso</option>
              <option value="BI">Burundi</option>
              <option value="KH">Cambodia</option>
              <option value="CM">Cameroon</option>
              <option value="CV">Cape Verde</option>
              <option value="KY">Cayman Islands</option>
              <option value="CF">Central African Republic</option>
              <option value="TD">Chad</option>
              <option value="CL">Chile</option>
              <option value="CN">China</option>
              <option value="CX">Christmas Island</option>
              <option value="CC">Cocos (Keeling) Islands</option>
              <option value="CO">Colombia</option>
              <option value="KM">Comoros</option>
              <option value="CG">Congo</option>
              <option value="CD">Congo, The Democratic Republic of the</option>
              <option value="CK">Cook Islands</option>
              <option value="CR">Costa Rica</option>
              <option value="CI">Cote D`Ivoire</option>
              <option value="HR">Croatia</option>
              <option value="CY">Cyprus</option>
              <option value="CZ">Czech Republic</option>
              <option value="DK">Denmark</option>
              <option value="DJ">Djibouti</option>
              <option value="DM">Dominica</option>
              <option value="DO">Dominican Republic</option>
              <option value="EC">Ecuador</option>
              <option value="EG">Egypt</option>
              <option value="SV">El Salvador</option>
              <option value="GQ">Equatorial Guinea</option>
              <option value="ER">Eritrea</option>
              <option value="EE">Estonia</option>
              <option value="ET">Ethiopia</option>
              <option value="FK">Falkland Islands (Malvinas)</option>
              <option value="FO">Faroe Islands</option>
              <option value="FJ">Fiji</option>
              <option value="FI">Finland</option>
              <option value="FR">France</option>
              <option value="GF">French Guiana</option>
              <option value="PF">French Polynesia</option>
              <option value="GA">Gabon</option>
              <option value="GM">Gambia</option>
              <option value="GE">Georgia</option>
              <option value="DE">Germany</option>
              <option value="GH">Ghana</option>
              <option value="GI">Gibraltar</option>
              <option value="GR">Greece</option>
              <option value="GL">Greenland</option>
              <option value="GD">Grenada</option>
              <option value="GP">Guadeloupe</option>
              <option value="GU">Guam</option>
              <option value="GT">Guatemala</option>
              <option value="GN">Guinea</option>
              <option value="GW">Guinea-Bissau</option>
              <option value="GY">Guyana</option>
              <option value="HT">Haiti</option>
              <option value="HN">Honduras</option>
              <option value="HK">Hong Kong</option>
              <option value="HU">Hungary</option>
              <option value="IS">Iceland</option>
              <option value="IN">India</option>
              <option value="ID">Indonesia</option>
              <option value="IR">Iran (Islamic Republic Of)</option>
              <option value="IQ">Iraq</option>
              <option value="IE">Ireland</option>
              <option value="IL">Israel</option>
              <option value="IT">Italy</option>
              <option value="JM">Jamaica</option>
              <option value="JP">Japan</option>
              <option value="JO">Jordan</option>
              <option value="KZ">Kazakhstan</option>
              <option value="KE">Kenya</option>
              <option value="KI">Kiribati</option>
              <option value="KP">Korea North</option>
              <option value="KR">Korea South</option>
              <option value="KW">Kuwait</option>
              <option value="KG">Kyrgyzstan</option>
              <option value="LA">Laos</option>
              <option value="LV">Latvia</option>
              <option value="LB">Lebanon</option>
              <option value="LS">Lesotho</option>
              <option value="LR">Liberia</option>
              <option value="LI">Liechtenstein</option>
              <option value="LT">Lithuania</option>
              <option value="LU">Luxembourg</option>
              <option value="MO">Macau</option>
              <option value="MK">Macedonia</option>
              <option value="MG">Madagascar</option>
              <option value="MW">Malawi</option>
              <option value="MY">Malaysia</option>
              <option value="MV">Maldives</option>
              <option value="ML">Mali</option>
              <option value="MT">Malta</option>
              <option value="MH">Marshall Islands</option>
              <option value="MQ">Martinique</option>
              <option value="MR">Mauritania</option>
              <option value="MU">Mauritius</option>
              <option value="MX">Mexico</option>
              <option value="FM">Micronesia</option>
              <option value="MD">Moldova</option>
              <option value="MC">Monaco</option>
              <option value="MN">Mongolia</option>
              <option value="MS">Montserrat</option>
              <option value="MA">Morocco</option>
              <option value="MZ">Mozambique</option>
              <option value="NA">Namibia</option>
              <option value="NP">Nepal</option>
              <option value="NL">Netherlands</option>
              <option value="AN">Netherlands Antilles</option>
              <option value="NC">New Caledonia</option>
              <option value="NZ">New Zealand</option>
              <option value="NI">Nicaragua</option>
              <option value="NE">Niger</option>
              <option value="NG">Nigeria</option>
              <option value="NO">Norway</option>
              <option value="OM">Oman</option>
              <option value="PK">Pakistan</option>
              <option value="PW">Palau</option>
              <option value="PS">Palestine Autonomous</option>
              <option value="PA">Panama</option>
              <option value="PG">Papua New Guinea</option>
              <option value="PY">Paraguay</option>
              <option value="PE">Peru</option>
              <option value="PH">Philippines</option>
              <option value="PL">Poland</option>
              <option value="PT">Portugal</option>
              <option value="PR">Puerto Rico</option>
              <option value="QA">Qatar</option>
              <option value="RE">Reunion</option>
              <option value="RO">Romania</option>
              <option value="RU">Russian Federation</option>
              <option value="RW">Rwanda</option>
              <option value="VC">Saint Vincent and the Grenadines</option>
              <option value="MP">Saipan</option>
              <option value="SM">San Marino</option>
              <option value="SA">Saudi Arabia</option>
              <option value="SN">Senegal</option>
              <option value="RS">Serbia</option>
              <option value="SC">Seychelles</option>
              <option value="SL">Sierra Leone</option>
              <option value="SG">Singapore</option>
              <option value="SK">Slovak Republic</option>
              <option value="SI">Slovenia</option>
              <option value="SO">Somalia</option>
              <option value="ZA">South Africa</option>
              <option value="ES">Spain</option>
              <option value="LK">Sri Lanka</option>
              <option value="KN">St. Kitts/Nevis</option>
              <option value="LC">St. Lucia</option>
              <option value="SD">Sudan</option>
              <option value="SR">Suriname</option>
              <option value="SZ">Swaziland</option>
              <option value="SE">Sweden</option>
              <option value="CH">Switzerland</option>
              <option value="SY">Syria</option>
              <option value="TW">Taiwan</option>
              <option value="TI">Tajikistan</option>
              <option value="TZ">Tanzania</option>
              <option value="TH">Thailand</option>
              <option value="TG">Togo</option>
              <option value="TK">Tokelau</option>
              <option value="TO">Tonga</option>
              <option value="TT">Trinidad and Tobago</option>
              <option value="TN">Tunisia</option>
              <option value="TR">Turkey</option>
              <option value="TM">Turkmenistan</option>
              <option value="TC">Turks and Caicos Islands</option>
              <option value="TV">Tuvalu</option>
              <option value="UG">Uganda</option>
              <option value="UA">Ukraine</option>
              <option value="AE">United Arab Emirates</option>
              <option value="UY">Uruguay</option>
              <option value="UZ">Uzbekistan</option>
              <option value="VU">Vanuatu</option>
              <option value="VE">Venezuela</option>
              <option value="VN">Viet Nam</option>
              <option value="VG">Virgin Islands (British)</option>
              <option value="VI">Virgin Islands (U.S.)</option>
              <option value="WF">Wallis and Futuna Islands</option>
              <option value="YE">Yemen</option>
              <option value="ZM">Zambia</option>
              <option value="ZW">Zimbabwe</option>
            </select></td>
        </tr>
        <tr>
          <th>State/Province: <?php echo required();?></th>
          <td><select name="state" id="state" class="select">
              <option value="">--- Please Select ---</option>
              <option value="AB">Alberta</option>
              <option value="BC">British Columbia</option>
              <option value="MB">Manitoba</option>
              <option value="NB">New Brunswick</option>
              <option value="NF">Newfoundland</option>
              <option value="NT">Northwest Territories</option>
              <option value="NS">Nova Scotia</option>
              <option value="NVT">Nunavut</option>
              <option value="ON">Ontario</option>
              <option value="PE">Prince Edward Island</option>
              <option value="QC">Quebec</option>
              <option value="SK">Saskatchewan</option>
              <option value="YK">Yukon</option>
              <option value="AL">Alabama</option>
              <option value="AK">Alaska</option>
              <option value="AZ">Arizona</option>
              <option value="AR">Arkansas</option>
              <option value="BVI">British Virgin Islands</option>
              <option value="CA">California</option>
              <option value="CO">Colorado</option>
              <option value="CT">Connecticut</option>
              <option value="DE">Delaware</option>
              <option value="FL">Florida</option>
              <option value="GA">Georgia</option>
              <option value="GU">Guam</option>
              <option value="HI">Hawaii</option>
              <option value="ID">Idaho</option>
              <option value="IL">Illinois</option>
              <option value="IN">Indiana</option>
              <option value="IA">Iowa</option>
              <option value="KS">Kansas</option>
              <option value="KY">Kentucky</option>
              <option value="LA">Louisiana</option>
              <option value="ME">Maine</option>
              <option value="MP">Mariana Islands</option>
              <option value="MPI">Mariana Islands (Pacific)</option>
              <option value="MD">Maryland</option>
              <option value="MA">Massachusetts</option>
              <option value="MI">Michigan</option>
              <option value="MN">Minnesota</option>
              <option value="MS">Mississippi</option>
              <option value="MO">Missouri</option>
              <option value="MT">Montana</option>
              <option value="NE">Nebraska</option>
              <option value="NV">Nevada</option>
              <option value="NH">New Hampshire</option>
              <option value="NJ">New Jersey</option>
              <option value="NM">New Mexico</option>
              <option value="NY">New York</option>
              <option value="NC">North Carolina</option>
              <option value="ND">North Dakota</option>
              <option value="OH">Ohio</option>
              <option value="OK">Oklahoma</option>
              <option value="OR">Oregon</option>
              <option value="PA">Pennsylvania</option>
              <option value="PR">Puerto Rico</option>
              <option value="RI">Rhode Island</option>
              <option value="SC">South Carolina</option>
              <option value="SD">South Dakota</option>
              <option value="TN">Tennessee</option>
              <option value="TX">Texas</option>
              <option value="UT">Utah</option>
              <option value="VT">Vermont</option>
              <option value="USVI">VI  U.S. Virgin Islands</option>
              <option value="VA">Virginia</option>
              <option value="WA">Washington</option>
              <option value="DC">Washington, D.C.</option>
              <option value="WV">West Virginia</option>
              <option value="WI">Wisconsin</option>
              <option value="WY">Wyoming</option>
              <option value="N/A">Other</option>
            </select></td>
        </tr>
        <tr>
          <th>Zip/Postal Code: <?php echo required();?></th>
          <td><input name="zip" type="text" class="inputbox" value="<?php echo $userdata->zip;?>" size="45" /></td>
        </tr>
        <tr>
          <th>Email Address: <?php echo required();?></th>
          <td><input name="email" type="text" class="inputbox" value="<?php echo $user->email;?>" size="45" /></td>
        </tr>
        <tr>
          <td colspan="2" align="center"><strong>Credit Card Information</strong></td>
        </tr>
        <tr>
          <th>Select One: <?php echo required();?></th>
          <td><input name="cctype" type="radio" value="V" class="lft-field" />
            <img src="gateways/anet/vs.png" class="lft-field" />
            <input name="cctype" type="radio" value="M" class="lft-field" />
            <img src="gateways/anet/mc.png" class="lft-field" />
            <input name="cctype" type="radio" value="A" class="lft-field" />
            <img src="gateways/anet/ae.png" class="lft-field" />
            <input name="cctype" type="radio" value="D" class="lft-field" />
            <img src="gateways/anet/dc.png" class="lft-field" /></td>
        </tr>
        <tr>
          <th>Card Number: <?php echo required();?></th>
          <td><input name="ccn" type="text" class="inputbox" size="45"  maxlength="16" /></td>
        </tr>
        <tr>
          <th>Name On Card: <?php echo required();?></th>
          <td><input name="ccname" type="text" class="inputbox" size="45" /></td>
        </tr>
        <tr>
          <th>Expiration Date: <?php echo required();?></th>
          <td><select name="month" style="width:120px" class="select">
              <?php foreach ($months as $month): ?>
              <option value="<?php echo $month['value']; ?>"><?php echo $month['text']; ?></option>
              <?php endforeach;?>
            </select>
            <select name="year" style="width:100px" class="select">
              <?php foreach ($year_expire as $year):?>
              <option value="<?php echo $year['value']; ?>"><?php echo $year['text']; ?></option>
              <?php endforeach;?>
            </select></td>
        </tr>
        <tr>
          <th>CVV: <?php echo required();?></th>
          <td><input name="cvv" type="text" class="inputbox" size="5" maxlength="4" />
          <?php echo tooltip('For Visa, MasterCard, and Discover cards, the card code is the last 3 digit number<br /> located on the back of your card on or above your signature line.<br />For an American Express card, it is the 4 digits on the FRONT above the end of your card number.');?></td>
        </tr>
        <tr>
          <th>Paying Now:</th>
          <td><?php echo $core->formatMoney($amount);?></td>
        </tr>
        <tr>
          <td colspan="2"><input type="submit" name="doauth" class="button" value="Submit Payment" /></td>
        </tr>
      </tbody>
    </table>
    <input type="hidden" name="item_name" value="Project Invoice - <?php echo cleanOut($row2->ptitle);?>" />
    <input type="hidden" name="item_number" value="<?php echo $row2->id;?>" />
    <input type="hidden" name="totalamount" value="<?php echo $amount;?>" />
  </form>
</div>
<script type="text/javascript">
// <![CDATA[
	$(document).ready(function () {
		var options = {
			target: "#msgholder",
			beforeSubmit:  showLoader,
			success: showResponse,
			url: "gateways/anet/ipn.php",
			resetForm : 0,
			clearForm : 0,
			data: {
				doAnet: 1
			}
		};
		$("#an_form").ajaxForm(options);
	});
	
	function showLoader() {
		$("#loader").fadeIn(200);
	}

	function hideLoader() {
		$("#loader").fadeOut(200);
	};	
			
	function showResponse(msg) {
		hideLoader();
		if (msg == 1) {
			window.location.href = SITEURL + '/account.php?do=billing&msg=6';
		} else {
			$(this).html(msg);
		}
		
		$("html, body").animate({
			scrollTop: 0
		}, 600);
	}
	
// ]]>
</script>