<?php
  /**
   * Language File
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2012
   * @version $Id: language.php, v1.00 2012-01-10 10:11:25 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php

  //add your locale settings here
  function lang($phrase)
  {
      static $lang = array(
			/* == Global == */
			'YES' => 'Yes',
			'NO' => 'No',
			'EDIT' => 'Edit',
			'DELETE' => 'Delete',
			'VIEW' => 'View',
			'INFO' => 'Info',
			'FROM' => 'From',
			'TO' => 'To',
			'FIND' => 'Find',
			'ADMIN' => 'Admin',
			'STAFF' => 'Staff',
			'CLIENT' => 'Client',
			'NAME' => 'Name',
			'YOU' => 'You',
			'LOGIN' => 'Login',
			'USERNAME' => 'Username',
			'USERNAME_R1' => 'Please Enter Valid Username',
			'USERNAME_R2' => 'Username Is Too Short (less Than 4 Characters Long).',
			'USERNAME_R3' => 'Invalid Characters Found In Username.',
			'USERNAME_R4' => 'Sorry, This Username Is Already Taken',
			'USERNAME_R5' => 'We are sorry, selected username does not exist in our database',
			'USERNAME_AVAIL' => 'Username Available',
			'USERNAME_NOAVAIL' => 'Username Not Available',
			'PASSWORD' => 'Password',
			'PASSWORD_T' => 'Leave it empty unless changing the password.',
			'PASSWORD_R1' => 'Please Enter Valid Password.',
			'PASSWORD_R2' => 'Password entered is not alphanumeric.',
			'PASSWORD_R3' => 'Your password did not match the confirmed password!',
			'PASSWORD_T2' => 'Password must be at least 6 characters long.',
			'COMPANY' => 'Company',
			'EMAIL' => 'Email Address',
			'EMAIL_R1' => 'Please Enter Valid Email Address',
			'EMAIL_R2' => 'Entered Email Address Is Already In Use.',
			'EMAIL_R3' => 'Entered Email Address Is Not Valid.',
			'EMAIL_R4' => 'Entered Email Address Does Not Exists.',
			'FNAME' => 'First Name',
			'FNAME_R' => 'Please Enter First Name',
			'LNAME' => 'Last Name',
			'LNAME_R' => 'Please Enter Last Name',
			'ADDRESS' => 'Address',
			'CITY' => 'City',
			'STATE' => 'Province/State',
			'COUNTRY' => 'Country',
			'ZIP' => 'Postal Code/Zip',
			'PHONE' => 'Phone Number',
			'LOGIN_R1' => 'Login and/or password did not match to the database.',
			'LOGIN_R2' => 'Your account has been banned.',
			'LOGIN_R3' => 'Your account it\'s not activated.',
			'LOGIN_R4' => 'You need to verify your email address.',
			'LOGIN_R5' => 'Please enter valid username and password',
			'PROJECT' => 'Project',
			'PROJECTS' => 'Projects',
			'TASK' => 'Task',
			'TASKS' => 'Tasks',
			'INVOICE' => 'Invoice',
			'INVOICES' => 'Invoices',
			'TICKET' => 'Ticket',
			'TICKETS' => 'Tickets',
			'SUBMISSION' => 'Submission',
			'SUBMISSIONS' => 'Submissions',
			'FILE' => 'File',
			'FILES' => 'Files',
			'BALANCE' => 'Balance',
			'TAX' => 'Tax',
			'HOUR' => 'Hour',
			'HOURS' => 'Hours',
			'JAN' => 'Jan',
			'FEB' => 'Feb',
			'MAR' => 'Mar',
			'APR' => 'Apr',
			'MAY' => 'May',
			'JUN' => 'Jun',
			'JUL' => 'Jul',
			'AUG' => 'Aug',
			'SEP' => 'Sep',
			'OCT' => 'Oct',
			'NOV' => 'Nov',
			'DEC' => 'Dec',
			'JAN_L' => 'January',
			'FEB_L' => 'February',
			'MAR_L' => 'March',
			'APR_L' => 'April',
			'MAY_L' => 'May',
			'JUN_L' => 'June',
			'JUL_L' => 'July',
			'AUG_L' => 'August',
			'SEP_L' => 'September',
			'OCT_L' => 'October',
			'NOV_L' => 'November',
			'DEC_L' => 'December',
			'SUN' => 'Sunday',
			'MON' => 'Monday',
			'TUE' => 'Tuesday',
			'WED' => 'Wednesday',
			'THU' => 'Thursday',
			'FRI' => 'Friday',
			'SAT' => 'Saturday',
			'SUBMIT' => 'Submit',
			'CANCEL' => 'Cancel',
			'DOWNLOAD' => 'Download',
			'FILESIZE' => 'Filesize',
			'VERSION' => 'Version',
			'CREATED' => 'Created',
			'TRANS' => 'Transactions',
			'NOTES' => 'Notes',
			'PAYMETHOD' => 'Payment Method',
			'OFFLINE' => 'Offline Method',
			'ONLINE' => 'Online Method',
			'STATUS' => 'Status',
			'ACTION' => 'Action',
			'ACTIONS' => 'Actions',
			'AMOUNT' => 'Amount',
			'TAXABLE' => 'Taxable',
			'PAID' => 'Paid',
			'UNPAID' => 'Unpaid',
			'OVERDUE' => 'Overdue',
			'NOTBILLED' => 'Not Billed Yet ',
			'NOTSTARTED' => 'Not Started Yet ',
			'INPROGRESS' => 'In Progress',
			'COMPLETED' => 'Completed',
			'TOTAL' => 'Total',
			'BILLING' => 'Billing',
			'DESC' => 'Description',
			'SEND' => 'Send',
			'HELP' => 'Help',
			'REPLY' => 'Reply',
			'AUTHOR' => 'Author',
			'REQFIELD1' => ' Fields marked ',
			'HIGH' => 'High',
			'MEDIUM' => 'Medium',
			'LOW' => 'Low',
			'OPEN' => 'Open',
			'CLOSED' => 'Closed',
			'NEW_CONCEPT' => 'New Concept',
			'REVISION' => 'Revision',
			'DRAFT' => 'Draft',
			'FINAL' => 'Final',
			'REQFIELD2' => ' are required.',
			'NOPROCCESS' => '<span>Alert!</span>Nothing to process.',
			'DELCONFIRM' => 'Are you sure you want to delete this record?<br /><strong>This action cannot be undone!!!</strong>',
			'NOACCESS' => '<span>Info!</span>Sorry you have not been assigned to this project.',
			'ADMINONLY' => '<span>Alert!</span>Sorry you don\'t have administrative privilege to access this page',

			/* == Class Paginator::  == */
			'PREV' => 'Prev',
			'NEXT' => 'Next',
			'GOTO' => 'Go To',
			'OF' => ' of ',
			'IPP' => 'Items Per Page',
			
			/* == Admin Dashboard == */
			'DASH_TITLE' => 'Welcome to Freelance Manager',
			'DASH_INFO' => 'Freelance Manager allows you to manage your freelance design and development clients with ease. With comprehensive project management and billing tools. Thanks to Freelance Manager you, your project team and your clients will always be on the same page.', 
			'DASH_ERR1' => '<span>Info!</span>There are no projects for selected Month...',
			'DASH_ERR2' => '<span>Info!</span>There are no transactions for selected Year...',
			'DASH_PROSTATS' => 'Project Statistics For › ',
			'DASH_PRSTATUS' => 'Project Status',
			'DASH_PYSTATUS' => 'Payment Status',
			'DASH_REVSTSTS' => 'Revenue Statistics For › ',
			'DASH_TOTALTRANS' => 'Total Transactions',
			'DASH_TOTALREV' => 'Total Revenue',
			'DASH_MONTHYEAR' => 'Month / Year',
			'DASH_TOTALTEAR' => 'Total Year',
			
			/* == Admin Staff  == */
			'STAFF_TITLE' => 'Staff Management &rsaquo; Edit Staff',
			'STAFF_INFO' => 'Here you can update your staff profile.',
			'STAFF_SUB' => 'Editing Staff &rsaquo; ',
			'STAFF_ACCLEVEL' => 'Access Level',
			'STAFF_ACCLEVEL_T' => 'Admin has full rights.<br />Staff has access to whatever is assigned to them.',
			'STAFF_LASTLOGIN' => 'Last Login',
			'STAFF_LASTIP' => 'Last Login IP',
			'STAFF_UPDATE' => 'Update Profile',
			'STAFF_TITLE1' => 'Staff Management &rsaquo; Add Staff',
			'STAFF_INFO1' => 'Here you can add new staff.',
			'STAFF_SUB1' => 'Adding Staff',
			'STAFF_NOTIFY' => 'Notify User',
			'STAFF_NOTIFY_T' => 'Send welcome email to this user.',
			'STAFF_ADD' => 'Add Staff',
			'STAFF_TITLE2' => 'Staff Management &rsaquo; Staff Overview',
			'STAFF_INFO2' => 'Here you can manage your staff.',
			'STAFF_SUB2' => 'Viewing Staff',
			'STAFF_DELUSER' => 'Delete Staff',
			'STAFF_DELUSER_ERR1' => '<span>Error!</span>You cannot delete main Administrator account!',
			'STAFF_DELUSER_OK' => '<span>Success!</span>User <strong> [USERNAME] </strong> deleted successfully!',
			'STAFF_UPDATED' => '<span>Success!</span>User updated successfully!',
			'STAFF_ADDED' => '<span>Success!</span>User added successfully!',
			'STAFF_ACTIVATION' => 'Account Activation - '/* email subject */,
			
			/* == Admin Clients  == */
			'CLIENT_TITLE' => 'Client Management &rsaquo; Edit Client',
			'CLIENT_INFO' => 'Here you can update your client profile.',
			'CLIENT_SUB' => 'Editing Client &rsaquo; ',
			'CLIENT_TITLE1' => 'Client Management &rsaquo; Add Client',
			'CLIENT_INFO1' => 'Here you can add new client.',
			'CLIENT_SUB1' => 'Adding Client',
			'CLIENT_ADD' => 'Add Client',
			'CLIENT_TITLE2' => 'Client Management &rsaquo; Client Overview',
			'CLIENT_INFO2' => 'Here you can manage your clients.<br /><strong>Note: Deleting active client will also delete all the projects, tasks, invoices etc.. assigned under the same client.</strong>',
			'CLIENT_SUB2' => 'Viewing Clients',
			'CLIENT_RESET' => '--- Reset Client Filter ---',
			'CLIENT_NOCLIENTS' => '<span>Alert!</span>You don\'t have any clients yet...',
			'CLIENT_DELCLIENT' => 'Delete Client',
			
			/* == Admin Projects  == */
			'PROJ_TITLE' => 'Project Manager &rsaquo; Edit Project',
			'PROJ_INFO' => 'Here you can update your project.',
			'PROJ_SUB' => 'Editing Project &rsaquo; ',
			'PROJ_NAME' => 'Project Name',
			'PROJ_NAME_R' => 'Please Enter Project Name',
			'PROJ_TYPE' => 'Project Type',
			'PROJ_TYPE_SEL' => '--- Select Project Type ---',
			'PROJ_TYPE_R' => 'Please Select Project Type',
			'PROJ_PRICE' => 'Project Price',
			'PROJ_PRICE_R' => 'Please Enter Project Price',
			'PROJ_START' => 'Start Date',
			'PROJ_END' => 'End Goal',
			'PROJ_BILLSTSTUS' => 'Billing Status',
			'PROJ_STATUS' => 'Project Status',
			'PROJ_DESC' => 'Project Description',
			'PROJ_COMPSTSTUS' => 'Percentage Completed',
			'PROJ_MANAGER' => 'Project Manager',
			'PROJ_FILES' => 'Project Files',
			'PROJ_UPDATE' => 'Update Project',
			'PROJ_NOPERM' => '<span>Info!</span>Sorry you don\'t have permission to create new project',
			'PROJ_TITLE1' => 'Project Manager &rsaquo; Add Project',
			'PROJ_INFO1' => 'Here you can add new project',
			'PROJ_SUB1' => 'Adding New Project',
			'PROJ_NOTIFY' => 'Notify Staff',
			'PROJ_ADD' => 'Add Project',
			'PROJ_TITLE2' => 'Project Manager &rsaquo; Project Details',
			'PROJ_INFO2' => 'Here you can view currently selected project details.',
			'PROJ_SUB2' => 'Project Details For &rsaquo; ',
			'PROJ_TASKS' => 'Project Tasks',
			'PROJ_SUBS' => 'Project Submissions',
			'PROJ_BACK' => 'Back to projects',
			'PROJ_TITLE3' => 'Manage Projects &rsaquo; Projects Overview',
			'PROJ_INFO3' => 'Here you can manage your projects.<br /><strong>Note: Deleting project will also delete all related items assigned under the same project</strong>.',
			'PROJ_SUB3' => 'Viewing All Projects',
			'PROJ_NOPROJECT' => '<span>Info!</span>You don\'t have any projects yet...',
			'PROJ_CLOVERVIEW' => 'Client Overview',
			'PROJ_DETAILS' => 'Project Details',
			'PROJ_PAID' => 'Project Paid',
			'PROJ_INVOICE' => 'Create Invoice',
			'PROJ_DELETE' => 'Delete Project',
			'PROJ_DELETE_OK' => '<span>Success!</span>Project <strong> [PROJECT] </strong> deleted successfully!',
			'PROJ_UPDATED' => '<span>Success!</span>Project updated successfully!',
			'PROJ_ADDED' => '<span>Success!</span>Project added successfully!',
			'PROJ_ESUBJECT' => 'New Project - '/* email subject */,

			/* == Admin Client Overview  == */
			'OVER_TITLE' => 'Project Manager &rsaquo; Client Overview',
			'OVER_INFO' => 'Here you view your client details such as projects, invoices etc...',
			'OVER_SUB' => 'Viewing Details For &rsaquo; ',
			'OVER_NOTE' => 'Admin Notes',
			'OVER_BSTATUS' => 'Balance Status',
			
			/* == Admin Project Types  == */
			'TYPE_TITLE' => 'Manage Project Types &rsaquo; Edit Type',
			'TYPE_INFO' => 'Here you can update your project type.',
			'TYPE_SUB' => 'Editing Project Type &rsaquo; ',
			'TYPE_NAME' => 'Type Name',
			'TYPE_NAME_R' => 'Please Enter Project Type Name',
			'TYPE_DESC' => 'Type Description',
			'TYPE_UPDATE' => 'Update Type',
			'TYPE_TITLE1' => 'Manage Project Types &rsaquo; Add Type',
			'TYPE_INFO1' => 'Here you can add new project type.',
			'TYPE_SUB1' => 'Adding Project',
			'TYPE_ADD' => 'Add Type',
			'TYPE_TITLE2' => 'Manage Project Types',
			'TYPE_INFO2' => 'Here you can manage your project types.',
			'TYPE_SUB2' => 'Viewing Project Types',
			'TYPE_NOTYPES' => '<span>Info!</span>You don\'t have any project types yet...',
			'TYPE_DELTYPE' => 'Delete Project Type',
			'TYPE_DELTYPE_OK' => '<span>Success!</span>Project Type <strong> [TYPE] </strong> deleted successfully!',
			'TYPE_UPDATED' => '<span>Success!</span>Project Type updated successfully!',
			'TYPE_ADDED' => '<span>Success!</span>Project Type added successfully!',
			
			/* == Admin Tasks  == */
			'TASK_TITLE' => 'Manage Project Tasks &rsaquo; Edit Task',
			'TASK_INFO' => 'Here you can update your project task.',
			'TASK_SUB' => 'Editing Project Task &rsaquo; ',
			'TASK_NAME' => 'Task Name',
			'TASK_NAME_R' => 'Please Enter Task Name',
			'TASK_SELPROJ' => 'Select Project',
			'TASK_SELPROJ_R' => 'Please Select Project',
			'TASK_START' => 'Start Date',
			'TASK_DUE' => 'Due Goal',
			'TASK_ASSIGNED' => 'Assigned To',
			'TASK_VISIBLE' => 'Visible To Client',
			'TASK_PROGRESS' => 'Task Progress',
			'TASK_COMPLETED' => 'Percentage Completed',
			'TASK_UPDATE' => 'Update Task',
			'TASK_TITLE1' => 'Manage Project Tasks &rsaquo; Add Task',
			'TASK_INFO1' => 'Here you can add new project task.',
			'TASK_SUB1' => 'Adding Project Task',
			'TASK_NOTIFY' => 'Notify Staff',
			'TASK_ADD' => 'Add Task',
			'TASK_TITLE2' => 'Manage Project Tasks',
			'TASK_INFO2' => 'Here you can manage your project tasks.',
			'TASK_SUB2' => 'Viewing Project Tasks',
			'TASK_NOTASKS' => '<span>Info!</span>You don\'t have any project tasks yet...',
			'TASK_DELTASK' => 'Delete Project Task',
			'TASK_DELTASK_OK' => '<span>Success!</span>Project Task <strong> [TASK] </strong> deleted successfully!',
			'TASK_UPDATED' => '<span>Success!</span>Project Task updated successfully!',
			'TASK_ADDED' => '<span>Success!</span>Project Task added successfully!',
			'TASK_ESUBJECT' => 'New Project Task - '/* email subject */,
			
			/* == Admin Files  == */
			'FILE_TITLE' => 'Manage Project Files &rsaquo; Edit File',
			'FILE_INFO' => 'Here you can update your project file.',
			'FILE_SUB' => 'Editing Project File &rsaquo; ',
			'FILE_SELPROJ' => 'Select Project',
			'FILE_SELPROJ_R' => 'Please Select Project',
			'FILE_NAME' => 'File Name',
			'FILE_NAME_R' => 'Please Enter Project File Name',
			'FILE_DESC' => 'File Description',
			'FILE_VER' => 'File Version',
			'FILE_ATTACH' => 'Attach File',
			'FILE_ATTACH_R' => 'Please Select File To Upload',
			'FILE_UPDATE' => 'Update File',
			'FILE_TITLE1' => 'Manage Project Files &rsaquo; Add File',
			'FILE_INFO1' => 'Here you can add new project file.',
			'FILE_SUB1' => 'Adding Project File',
			'FILE_ADD' => 'Add File',
			'FILE_TITLE2' => 'Manage Project Files',
			'FILE_INFO2' => 'Here you can manage your project files.',
			'FILE_SUB2' => 'Viewing Project Files',
			'FILE_NOFILES' => '<span>Info!</span>You don\'t have any project files yet...',
			'FILE_DELFILE' => 'Delete Project File',
			'FILE_DELFILE_OK' => '<span>Success!</span>Project File <strong> [FILE] </strong> deleted successfully!',
			'FILE_UPDATED' => '<span>Success!</span>Project File updated successfully!',
			'FILE_ADDED' => '<span>Success!</span>Project File added successfully!',
			
			/* == Admin Invoices  == */
			'INVC_TITLE' => 'Project Invoices &rsaquo; Edit Invoice',
			'INVC_INFO' => 'Here you can make modifications to currently selected invoice.',
			'INVC_SUB' => 'Editing Invoice For &rsaquo; ',
			'INVC_ERR' => '<span>Error!</span>You have selected invalid Invoice',
			'INVC_NAME' => 'Invoice Title',
			'INVC_NAME_R' => 'Please Enter Invoice Title',
			'INVC_AMOUNT_T' => 'Enter only numeric values.',
			'INVC_CNAME' => 'Client Name',
			'INVC_CEMAIL' => 'Client Email',
			'INVC_DUEDATE' => 'Due Date',
			'INVC_DUEDATE_R' => 'Please Enter Due Date',
			'INVC_TOTAL' => 'Invoice Total',
			'INVC_PAID' => 'Amount Paid',
			'INVC_EMAIL_T' => 'Email invoice to client',
			'INVC_PRINT_T' => 'Print Invoice',
			'INVC_PDF_T' => 'Create Pdf',
			'INVC_UPDATE' => 'Update Invoice',
			'INVC_EMAIL_T2' => 'Sending invoice to client',
			'INVC_SEND_T' => 'Are you sure you want to send this invoice?',
			'INVC_TITLE2' => 'Project Invoices &rsaquo; Add Invoice',
			'INVC_INFO2' => 'Here you can add invoice to currently selected project.',
			'INVC_SUB2' => 'Adding Invoice ',
			'INVC_SUB2_1' => 'For &rsaquo; ',
			'INVC_PROJCSELETC' => 'Select Project',
			'INVC_PROJCSELETC_R' => 'Please Select Project',
			'INVC_CLIENTSELECT' => 'Select Client',
			'INVC_CLIENTSELECT_R' => 'Please Select Client',
			'INVC_INITIALENTRY' => 'Initial Invoice Entry',
			'INVC_ADD' => 'Add Invoice',
			'INVC_TITLE3' => 'Manage Project Invoices',
			'INVC_INFO3' => 'Here you can manage your project invoices.<br /><strong>Note: Deleting active invoice will remove all paid/unpaid entries.</strong>',
			'INVC_SUB3' => 'Viewing Project Invoices For &rsaquo; ',
			'INVC_NOINVOICE' => '<span>Info!</span>You don\'t have any invoices for selected project yet...',
			'INVC_NOINVOICE2' => '<span>Info!</span>You don\'t have any invoices yet...',
			'INVC_DELETEINV' => 'Delete Invoice',
			'INVC_DELETEINV_OK' => '<span>Success!</span>Project Invoice <strong> [INVOICE] </strong> deleted successfully!',
			'INVC_ADDED' => '<span>Success!</span>Invoice Created Successfully',
			'INVC_UPDATED' => '<span>Success!</span>Invoice Updated Successfully',
			'INVC_SENT_ERR' => '<span>Error!</span>Invoice could not be sent.',
			'INVC_SENT_OK' => '<span>Success!</span>Invoice Sent Successfully',
			'INVC_SUBJECT' => 'Invoice For - '/* email subject */,
			'INVC_TITLE4' => 'View Invoice Status',
			'INVC_INFO4' => 'Here you can view invoices based on their status.',
			'INVC_SUB4' => 'Viewing Invoices',
			'INVC_RESET' => 'Reset Invoice Filter',
			'INVC_DUEFROM' => 'Duedate From',
			'INVC_DUETO' => 'Duedate To',
			
			'INVC_ADDENTRY' => 'Add Entry',
			'INVC_SUBENTRY' => 'Viewing Invoice Entries',
			'INVC_ENTRYTITLE' => 'Entry Title',
			'INVC_ENTRYTITLE_R' => 'Please Enter Entry Title',
			'INVC_ENTRYAMOUNT_R' => 'Please Enter Valid Entry Amount',
			'INVC_NOENTRY' => '<span>Info!</span>You don\'t have any invoice entries yet...',
			'INVC_DELENTRY' => 'Delete Invoice Entry',
			'INVC_SUBENTRY1' => 'Adding Invoice Entry',
			'INVC_ENTRYTITLE2' => 'Project Invoices &rsaquo; Edit Invoice Entry',
			'INVC_ENTRYINFO2' => 'Here you can make modifications to currently selected invoice entry.',
			'INVC_ENTRYSUB2' => 'Editing Invoice Entry &rsaquo; ',
			'INVC_ENTRYUPDATE' => 'Update Invoice Entry',
			'INVC_ENTRY_UPDATED' => '<span>Success!</span>Invoice Entry updated successfully',
			'INVC_ENTRY_ADDED' => '<span>Success!</span>Invoice Entry added successfully',
			'INVC_DELENTRY_OK' => '<span>Success!</span>Invoice Entry <strong> [ENTRY] </strong> deleted successfully!',
			
			'INVC_ADDRECORD' => 'Add Record',
			'INVC_SUBRECORD' => 'Viewing Payment Records',
			'INVC_RECPAID' => 'Date Paid',
			'INVC_RECAMOUNT_R' => 'Please Enter Valid Record Amount',
			'INVC_NORECORD' => '<span>Info!</span>You don\'t have any invoice payment records yet....',
			'INVC_DELRECORD' => 'Delete Invoice Record',
			'INVC_SUBRECORD1' => 'Adding Invoice Record',
			'INVC_RECTITLE2' => 'Project Invoices &rsaquo; Edit Invoice Record',
			'INVC_RECINFO2' => 'Here you can make modifications to currently selected invoice record.',
			'INVC_RECSUB2' => 'Editing Invoice Record For &rsaquo; ',
			'INVC_RECUPDATE' => 'Update Invoice Record',
			'INVC_REC_UPDATED' => '<span>Success!</span>Invoice Record updated successfully',
			'INVC_REC_ADDED' => '<span>Success!</span>Invoice Record added successfully',
			'INVC_DELRECORD_OK' => '<span>Success!</span>Invoice Record <strong> [RECORD] </strong> deleted successfully!',
			
			/* == Admin Transactions  == */
			'TRANS_TITLE' => 'Billing Management &rsaquo; Payment Transactions',
			'TRANS_INFO' => 'Here you can view your payment transactions.',
			'TRANS_SUB' => 'Viewing Payment Transactions',
			'TRANS_RESET' => 'Reset Payment Filter',
			'TRANS_REPORT' => 'Create Report',
			'TRANS_INVOICE' => 'Invoice',
			'TRANS_PAYDATE' => 'Payment Date',
			'TRANS_PAYAMOUNT' => 'Payment Amount',
			'TRANS_NOTRANS' => '<span>Info!</span>You don\'t have any payment transactions yet...',
			'TRANS_DELETE' => 'Delete Transaction Record',
			
			/* == Admin Time Billing  == */
			'BILL_TITLE' => 'Billing Management &rsaquo; Time Billing Details',
			'BILL_INFO' => 'Here you can view time billing details for selected project.',
			'BILL_SUB' => 'Viewing Time Billing Details For &rsaquo; ',
			'BILL_ADD_I' => 'Add New Invoice',
			'BILL_ADD_B' => 'Add Time Billing',
			'BILL_TNAME' => 'Time Record Name',
			'BILL_NOBILL' => '<span>Info!</span>You don\'t have any time billings yet...',
			'BILL_DELETE' => 'Delete Time Billing Record',
			'BILL_DELETE_OK' => '<span>Success!</span>Billing Record <strong> [TIMEBILL] </strong> deleted successfully!',
			'BILL_TITLE1' => 'Billing Management &rsaquo; Edit Time Billing Record',
			'BILL_INFO1' => 'Here you can edit time billing details for selected project.',
			'BILL_SUB1' => 'Editing Billing Record &rsaquo; ',
			'BILL_ENTRY' => 'Entry Title',
			'BILL_DOWORK' => 'Date of Work',
			'BILL_LOWORK' => 'Length of Work',
			'BILL_UPDATE' => 'Update Record',
			'BILL_TITLE2' => 'Billing Management &rsaquo; Add Time Billing Record',
			'BILL_INFO2' => 'Here you can add time billing details for selected project.',
			'BILL_SUB2' => 'Adding Billing Record',
			'BILL_NOTASK' => 'No Task Assigned',
			'BILL_ADD' => 'Add Record',
			'BILL_UPDATED' => '<span>Success!</span>Time Billing Record updated successfully',
			'BILL_ADDED' => '<span>Success!</span>Time Billing Record added successfully',
			'BILL_TITLE3' => 'Billing Management &rsaquo; Time Billing Records',
			'BILL_INFO3' => 'Here you can manage your project time billing records.',
			'BILL_SUB3' => 'Viewing Time Billing Records',
			'BILL_REPORT' => 'Create Report',
			'BILL_RECORDS' => 'Records',
			'BILL_NORECORDS' => '<span>Info!</span>You don\'t have any time billings yet...',
			'BILL_DELETE1' => 'Delete Time Billing',
			'BILL_RECNAME' => 'Record Name',

			/* == Admin Submissions  == */
			'SUBS_TITLE' => 'Project Submissions &rsaquo; Edit Submission',
			'SUBS_INFO' => 'Here you can update your project submission.',
			'SUBS_SUB' => 'Editing Project Submission &rsaquo; ',
			'SUBS_NAME' => 'Submission Name',
			'SUBS_NAME_R' => 'Please Enter Submission Name',
			'SUBS_NOTE_R' => 'Please Enter Submission Notes',
			'SUBS_TYPE' => 'Submission Type',
			'SUBS_DATE' => 'Submission Date',
			'SUBS_STATUS' => 'Submission Status',
			'SUBS_STATUS1' => 'Not Submitted to Client',
			'SUBS_STATUS2' => 'Waiting for client’s approval',
			'SUBS_STATUS3' => 'Approved by Client',
			'SUBS_STATUS4' => 'Rejected by Client',
			'SUBS_CREVIEW' => 'Client Review',
			'SUBS_DATEREVIEW' => 'Review Date',
			'SUBS_SENDREVIEW' => 'Send For Review',
			'SUBS_SENDREVIEW_T' => 'If Yes an email will be sent to notify client',
			'SUBS_UPDATE' => 'Update Submission',
			'SUBS_TITLE1' => 'Project Submissions &rsaquo; Add Submission',
			'SUBS_INFO1' => 'Here you can add new project submission, draft, and revision.',
			'SUBS_SUB1' => 'Adding Project Submissions For &rsaquo; ',
			'SUBS_ADD' => 'Add Submission',
			'SUBS_TITLE2' => 'Manage Project Submissions',
			'SUBS_INFO2' => 'Here you can manage your project submissions, drafts, and revisions.',
			'SUBS_SUB2' => 'Viewing Project Submissions For &rsaquo; ',
			'SUBS_NOSUBS' => '<span>Info!</span>You don\'t have any project submissions yet...',
			'SUBS_DELETE' => 'Delete Submission',
			'SUBS_DELETE_OK' => '<span>Success!</span>Submission <strong> [SUBMISSION] </strong> deleted successfully!',
			'SUBS_SUBJECT' => 'New Project Submission - '/* email subject */,
			'SUBS_UPDATED' => '<span>Success!</span>Project Submission updated successfully',
			'SUBS_ADDED' => '<span>Success!</span>Project Submission added successfully',

			/* == Admin Configuration  == */
			'CONF_TITLE' => 'System Configuration',
			'CONF_INFO' => 'Changes made here will affect the settings of Freelance Manager.',
			'CONF_SUB' => 'Update System Configuration',
			'CONF_COMPANY' => 'Company Name',
			'CONF_COMPANY_T' => 'This is your website slogan which will appear near your website heading',
			'CONF_COMPANY_R' => 'Please Enter Website Name',
			'CONF_URL' => 'Website Url',
			'CONF_URL_T' => 'Insert full URL WITHOUT any trailing slash  (e.g. http://www.yourdomain.com)',
			'CONF_URL_R' => 'Please Enter Website Url',
			'CONF_EMAIL' => 'Company Email',
			'CONF_EMAIL_T' => 'This is the main email notices will be sent to. It is also used as the from \'email\'<br />when emailing other automatic emails',
			'CONF_EMAIL_R' => 'Please enter valid Website Email address',
			'CONF_ADDRESS' => 'Address',
			'CONF_CITY' => 'City',
			'CONF_STATE' => 'Province/State',
			'CONF_ZIP' => 'Postal Code/Zip',
			'CONF_PHONE' => 'Telephone',
			'CONF_FAX' => 'Fax',
			'CONF_OFFLINE' => 'Enable Offline Payments',
			'CONF_OFFLINEINFO' => 'Offline Payments Info',
			'CONF_LOGO' => 'Company Logo',
			'CONF_LOGO_R' => 'Illegal file type. Only jpg and png file types allowed.',
			'CONF_DELLOGO' => 'Delete Logo',
			'CONF_DELLOGO_T' => 'If no logo exists, Company Name will be used instead.',
			'CONF_SDATE' => 'Short Date',
			'CONF_LDATE' => 'Long Date',
			'CONF_TZ' => 'Default Time Zone',
			'CONF_WEEK' => 'Week Starts On',
			'CONF_REGYES' => 'Allow Registrations',
			'CONF_REGYES_T' => 'If Yes clients will be able to register, otherwise manual registration is required',
			'CONF_TAX' => 'Enable Tax',
			'CONF_TAXNAME' => 'Tax Name',
			'CONF_TAXRATE' => 'Tax Rate',
			'CONF_TAXNO' => 'Tax/VAT Number',
			'CONF_TAXNO_T' => 'This is your Tax/Vat/Business number that will appear on all your invoices',
			'CONF_UPLOADS' => 'Enable Uploads',
			'CONF_AFT' => 'Allowed File Types',
			'CONF_AFT_T' => 'Enter coma , separated file extensions, no spaces.',
			'CONF_MFS' => 'Max File Size',
			'CONF_MFS_T' => 'Enter values in MB',
			'CONF_IPP' => 'Items Per Page',
			'CONF_IPP_T' => 'Default number of items used for pagination',
			'CONF_CURRENCY' => 'Default Currency',
			'CONF_CURRENCY_T' => 'Enter your currency such as CAD, USD, EUR',
			'CONF_CURRENCY_R' => 'Please Enter Valid Default currency',
			'CONF_CURSYMBOL' => 'Currency Symbol',
			'CONF_CURSYMBOL_T' => 'Enter your currency symbol such as $, &euro;, &pound;',
			'CONF_MAILER' => 'Default Mailer',
			'CONF_MAILER_T' => 'Use PHP Mailer or SMTP protocol for sending emails',
			'CONF_SMTP_HOST' => 'SMTP Hostname',
			'CONF_SMTP_HOST_T' => 'Specify main SMTP server. E.g.:(mail.yourserver.com)',
			'CONF_SMTP_HOST_R' => 'Please Enter Valid SMTP Host',
			'CONF_SMTP_USER' => 'SMTP Username',
			'CONF_SMTP_USER_R' => 'Please Enter Valid SMTP Username!',
			'CONF_SMTP_PASS' => 'SMTP Password',
			'CONF_SMTP_PORT' => 'SMTP Port',
			'CONF_SMTP_PASS_R' => 'Please Enter Valid SMTP Password!',
			'CONF_SMTP_PORT_T' => 'Mail server port ( Can be 25, 26. 456 for GMAIL. 587 for Yahoo ). Ask your host if uncertain.',
			'CONF_SMTP_PORT_R' => 'Please Enter Valid SMTP Port',
			'CONF_UPDATE' => 'Update Configuration',
			'CONF_UPDATED' => '<span>Success!</span>System Configuration updated successfully!',
			
			/* == Admin Gateways  == */
			'GATE_TITLE' => 'Manage Gateways &rsaquo; Edit Gateway',
			'GATE_INFO' => 'Here you can update your gateway settings.',
			'GATE_SUB' => 'Editing Gateway &rsaquo; ',
			'GATE_NAME' => 'Gateway Name',
			'GATE_NAME_R' => 'Please Enter Display Gateway Name',
			'GATE_LIVE' => 'Set Live Mode',
			'GATE_LIVE_T' => 'When in live mode all transactions will be processed in real time',
			'GATE_ACTIVE' => 'Active',
			'GATE_ACTIVE_T' => 'Only active gateways will be available for payment methods.',
			'GATE_IPN' => 'IPN Url',
			'GATE_UPDATE' => 'Update Gateway',
			'GATE_TITLE1' => 'Manage Payment Gateways',
			'GATE_INFO1' => 'Here you can manage your list of available gateways.',
			'GATE_SUB1' => 'Viewing Gateways',
			'GATE_NOGATE' => '<span>Error!</span>You are missing all gateways. You need to reinstall them manually',
			'GATE_UPDATED' => '<span>Success!</span>Gateway Configuration Updated Successfully',
			
			/* == Admin Database Backup  == */
			'DB_TITLE' => 'Database Maintenance',
			'DB_INFO' => 'Make sure your database is backed up frequently. Click on Create backup to manually backup your database.<br />The backups are stored in the [<strong>/admin/backups/</strong>] folder and can be downloaded from the list below. <br />Your most recent backup is highlighted. Make sure you download your most recent backup, and delete the rest.',
			'DB_SUB' => 'Viewing Backups',
			'DB_DOBACKUP' => 'Create Backup',
			'DB_DORESTORE' => 'Restore Database',
			'DB_RESTORE' => 'Restore Backup',
			'DB_DELETE' => 'Delete Database Backup',
			'DB_DELETE_OK' => '<span>Success!</span>Backup deleted successfully!',
			'DB_CREATED' => '<span>Success!</span>Backup created successfully!',
			'DB_RESTORED' => '<span>Success!</span>Database restored successfully!',
			
			/* == Admin System News  == */
			'NEWS_TITLE' => 'System Setup &rsaquo; Edit News',
			'NEWS_INFO' => 'Here you can update your news announcement.',
			'NEWS_SUB' => 'Editing News Announcement &rsaquo; ',
			'NEWS_NAME' => 'News Title',
			'NEWS_NAME_R' => 'Please Enter News Title',
			'NEWS_BODY_R' => 'Please Enter News Content',
			'NEWS_START' => 'News Start Date',
			'NEWS_START_T' => 'This option allows you to select a start date for this News Announcement.<br />This will be displayed as the publish date to website visitors.<br />If you select a future date, the content item will not appear on the website until that date.',
			'NEWS_ACTIVE' => 'Published',
			'NEWS_UPDATE' => 'Update News',
			'NEWS_TITLE1' => 'System Setup &rsaquo; Add News',
			'NEWS_INFO1' => 'Here you can add news announcement.',
			'NEWS_SUB1' => 'Adding News Announcement',
			'NEWS_ADD' => 'Add News',
			'NEWS_TITLE2' => 'System Setup &rsaquo; News Manager',
			'NEWS_INFO2' => 'Here you can manage your news announcements.',
			'NEWS_SUB2' => 'Viewing News Announcements',
			'NEWS_NONEWS' => '<span>Info!</span>You don\'t have any news announcement yet...',
			'NEWS_DELETE' => 'Delete News',
			'NEWS_DELETE_OK' => '<span>Success!</span>News <strong> [SUBMISSION] </strong> deleted successfully!',
			'NEWS_UPDATED' => '<span>Success!</span>Content News updated successfully',
			'NEWS_ADDED' => '<span>Success!</span>Content News added successfully',
			
			/* == Admin Email Manager  == */
			'MAIL_TITLE' => 'System Email Manager',
			'MAIL_INFO' => 'Here you can send mail to your staff users/clients.',
			'MAIL_SUB' => 'Sending Email',
			'MAIL_FROM' => 'Email From',
			'MAIL_REC' => 'Recipients',
			'MAIL_BODY_R' => 'Please Enter Email Message!',
			'MAIL_REC_ALL' => 'All Users',
			'MAIL_REC_C' => 'Clients Only',
			'MAIL_REC_S' => 'Staff Only',
			'MAIL_REC_SUJECT' => 'Email Subject',
			'MAIL_REC_SUJECT_R' => 'Please Enter Email Subject',
			'MAIL_NOTE' => 'Note: Do not replace variables between [ ]',
			'MAIL_SEND' => 'Send Mail',
			'MAIL_SENT' => '<span>Success!</span>All Email(s) have been sent successfully!',
			'MAIL_ALERT' => '<span>Alert!</span>Some of the emails could not be reached!',
			
			/* == Admin Calendar  == */
			'CAL_TITLE' => 'View Event Calendar',
			'CAL_INFO' => 'Here you can view important calendar events, such as pending invoices, tasks, project due dates etc...',
			'CAL_SUB' => '<span class="invoice-bullet">Invoices</span> <span class="project-bullet">Projects</span> <span class="task-bullet">Tasks</span>',
			
			/* == Admin Support  == */
			'SUP_TITLE' => 'Manage Tickets &rsaquo; Edit Ticket',
			'SUP_INFO' => 'Here you can replay to your support ticket.',
			'SUP_SUB' => 'Editing Support Ticket &rsaquo; ',
			'SUP_NOTICKET' => '<span>Info!</span>You don\'t have any support tickets yet...',
			'SUP_PRIORITY' => 'Ticket Priority',
			'SUP_PRIORITY1' => 'Priority',
			'SUP_STATUS' => 'Ticket Status',
			'SUP_ASSIGNED' => 'Assigned To',
			'SUP_STAFF' => 'Staff Name',
			'SUP_NOASSIGNED' => 'Unassigned',
			'SUP_SUBJECT' => 'Ticket Subject',
			'SUP_SUBJECT_R' => 'Please Enter Ticket Subject',
			'SUP_DETAIL' => 'Ticket Details',
			'SUP_DETAIL_R' => 'Please Enter Reply Message',
			'SUP_DETAIL_R1' => 'Please Enter Ticket Content',
			'SUP_CREATED' => 'Date Created',
			'SUP_UPDATE_S' => 'Update Status',
			'SUP_REPLYTO' => 'Reply To &rsaquo; ',
			'SUP_ESUBJECT' => 'New Ticket -'/* email subject */,
			'SUP_DELETE' => 'Delete Reply',
			'SUP_DELETE_OK' => '<span>Success!</span>Reply at <strong> [REPLY] </strong> deleted successfully!',
			'SUP_UPDATED' => '<span>Success!</span>Ticket status updated successfully!',
			'SUP_SENTOK' => '<span>Success!</span>Ticket Reply sent successfully!',
			'SUP_SENTOK1' => '<span>Success!</span>Ticket submitted successfully!',
			'SUP_TITLE1' => 'Manage Support Tickets',
			'SUP_INFO1' => 'Here you can manage your support tickets.',
			'SUP_SUB1' => 'Viewing Tickets',
			'SUP_RESET' => 'Reset Ticket Filter',
			'SUP_OPEN' => 'Open Ticket',
			'SUP_CLOSED' => 'Closed Ticket',
			'SUP_DELTICKET' => 'Delete Support Ticket',
			'SUP_DELTICKET_OK' => '<span>Success!</span>Support Ticket <strong> [TICKET] </strong> deleted successfully!',
			
			/* == Admin Forms  == */
			'FORM_TITLE' => 'Manage Visual Forms  &rsaquo; Edit Form',
			'FORM_INFO' => 'Here you can update your current form.',
			'FORM_SUB' => 'Editing Form &rsaquo; ',
			'FORM_NAME' => 'Form Name',
			'FORM_NAME_R' => 'Please Enter Form Name',
			'FORM_EMAIL' => 'Recipient Email',
			'FORM_EMAIL_R' => 'Please Enter Recipient Email',
			'FORM_EMAIL_R1' => 'Entered Email Address Is Invalid!',
			'FORM_MSG' => 'Success Message',
			'FORM_MSG_R' => 'Please Enter Success Message',
			'FORM_BTN' => 'Submit Button Name',
			'FORM_BTN_R' => 'Please Enter Submit Button Name',
			'FORM_CAPTCHA' => 'Enable Captcha',
			'FORM_ACTIVE' => 'Form Published',
			'FORM_NOTE' => 'Do Not Replace Variables Between [ ]',
			'FORM_UPDATE' => 'Update Form',
			'FORM_TITLE1' => 'Manage Visual Forms  &rsaquo; Add Form',
			'FORM_INFO1' => 'Here you can add new visual form.',
			'FORM_SUB1' => 'Adding Visual Form',
			'FORM_ADD' => 'Add Form',
			'FORM_DOWNLOAD' => 'Download Attachment',
			'FORM_UPDATED' => '<span>Success!</span>Form updated successfully',
			'FORM_ADDED' => '<span>Success!</span>Form added successfully',
			'FORM_ERROR1' => 'Please complete the',
			'FORM_ERROR2' => 'field',
			'FORM_ERROR3' => 'option',
			'FORM_ERROR4' => 'Please check at least one',
			'FORM_ERROR5' => 'choice',
			'FORM_ERROR6' => 'Please enter captcha code',
			'FORM_ERROR7' => 'Entered captcha code is incorrect',
			'FORM_ERROR8' => 'Invalid file extension. Allowed extensions are ',
			'FORM_ERROR9' => 'Sorry but there is an error in our server. Please try again later.',
			'FORM_ERROR10' => 'File is too big. Maximum allowed size is ',
			'FORM_ERROR11' => 'An unexpected error occurred, please try again later',
			'FORM_ERROR12' => 'Sorry but there is an error in our server. Please try again later.',
			'FORM_ERROR13' => 'The file could not be uploaded',
			'FORM_ERROR14' => '<span>Error!</span>You have selected invalid form!',
			'FORM_TITLE2' => 'Manage Visual Forms &rsaquo; Edit Fields',
			'FORM_INFO2' => 'Here you can create your form layout. Click on Top Bar field area to add new element.<br />Drag and drop elements to position them on layout grid.',
			'FORM_DATAERR' => 'Post data is missing.',
			'FORM_DATASAVED' => '<span>Success!</span>Form field layout updated successfully.',
			'FORM_F_SAVE' => 'Save Form Layout',
			'FORM_F_TEXT' => 'Text Field',
			'FORM_F_DATE' => 'Datepicker Field',
			'FORM_F_FILE' => 'File Attachment',
			'FORM_F_TITLE' => 'Title',
			'FORM_F_PARA' => 'Paragraph',
			'FORM_F_CHECK' => 'Checkboxes',
			'FORM_F_RADIO' => 'Radio',
			'FORM_F_SELECT' => 'Select List',
			'FORM_F_PICKER' => 'DatePicker',
			'FORM_F_LABEL' => 'Label',
			'FORM_F_PARAFIELD' => 'Paragraph Field',
			'FORM_F_SELECTO' => 'Select Options',
			'FORM_F_ADD' => 'Add',
			'FORM_F_CHECKG' => 'Checkbox Group',
			'FORM_F_REMOVEM' => 'Are you sure you want to remove this element?',
			'FORM_F_REMOVE' => 'Remove',
			'FORM_F_RADIOG' => 'Radio Group',
			'FORM_F_MULTI' => 'Allow Multiple Selections',
			'FORM_F_HIDE' => 'Hide',
			'FORM_F_REQ' => 'Required',
			'FORM_F_SHOW' => 'Show',
			'FORM_REMFIELD' => 'Remove Field',
			'FORM_TITLE2' => 'Manage Visual Forms &rsaquo; View Form Data',
			'FORM_INFO2' => 'Here you can view submitted form data.',
			'FORM_SUB2' => 'Viewing Form Data',
			'FORM_BACK' => 'Back to forms',
			'FORM_SUBMITTED' => 'Submitted',
			'FORM_VIEWD' => 'View Data',
			'FORM_NODATA' => '<span>Info!</span>You don\'t have any form data yet...',
			'FORM_DELDATA' => 'Delete Form Data',
			'FORM_DELDATA_OK' => '<span>Success!</span>Form Data For <strong> [FORMDATA] </strong> deleted successfully!',
			'FORM_TITLE3' => 'Manage Visual Forms',
			'FORM_INFO3' => 'Here you can manage your forms. First create new form, then click on Edit Fields to create fields and layout.',
			'FORM_SUB3' => 'Viewing Forms',
			'FORM_EDITFIELDS' => 'Edit Fields',
			'FORM_EDITFORM' => 'Edit Form',
			'FORM_PREVIEWF' => 'Preview Form',
			'FORM_PREVIEWD' => 'Preview Data',
			'FORM_NOFORM' => '<span>Info!</span>You don\'t have any forms yet...',
			'FORM_DELFORM' => 'Delete Visual Form',
			'FORM_DELFORM_OK' => '<span>Success!</span>Form <strong> [FORM] </strong> deleted successfully!',

			/* == Admin Messages  == */
			'MSG_TITLE' => 'Manage Instant Messages  &rsaquo; View Message',
			'MSG_INFO' => 'Here you can view and reply to your messages.',
			'MSG_SUB' => 'Viewing &rsaquo; ',
			'MSG_SENDER' => 'Sender Name',
			'MSG_SENT' => 'Message Sent',
			'MSG_DATESENT' => 'Date Sent',
			'MSG_SUBJECT' => 'Message Subject',
			'MSG_STATUS' => 'Message Status',
			'MSG_TITLE1' => 'Manage Instant Messages  &rsaquo; Send Message',
			'MSG_INFO1' => 'Here you can view and send a new message.',
			'MSG_SUB1' => 'Adding New Message',
			'MSG_RECEPIENT' => 'Recipient',
			'MSG_RECEPIENT_T' => 'Select Recipient',
			'MSG_RECEPIENT_R' => 'Please Select Recipient',
			'MSG_MSGERR1' => 'Please Enter Your Subject',
			'MSG_MSGERR2' => 'Please Enter Your Message',
			'MSG_TITLE2' => 'Manage Instant Messages',
			'MSG_INFO2' => 'Here you can manage your instant messages.',
			'MSG_SUB2' => 'Viewing Instant Messages',
			'MSG_RESET' => 'Reset Message Filter',
			'MSG_UNREAD' => 'Unread Messages',
			'MSG_ADDNEW' => 'Compose New Message',
			'MSG_NOMSG' => '<span>Info!</span>You don\'t have any messages yet...',
			'MSG_SENTOK' => '<span>Success!</span>Message sent successfully!',
			'MSG_DELETE' => 'Delete Message',
			'MSG_DELETE_OK' => '<span>Success!</span>Message From <strong> [MESSAGE] </strong> deleted successfully!',

			/* == Admin Header  == */
			'MENU_WELCOME' => 'Welcome',
			'MENU_MSG' => 'Messages',
			'MENU_LOGOUT' => 'Log Out',
			'MENU_STAFF' => 'Staff',
			'MENU_CLIENTS' => 'Clients',
			'MENU_PM' => 'Project Management',
			'MENU_MP' => 'Manage Projects',
			'MENU_PTYPES' => 'Project Types',
			'MENU_PTASKS' => 'Project Tasks',
			'MENU_PFILES' => 'Project Files',
			'MENU_BM' => 'Billing Management',
			'MENU_TB' => 'Time Billing',
			'MENU_CI' => 'Create Invoice',
			'MENU_VI' => 'View Invoices',
			'MENU_VT' => 'View Transactions',
			'MENU_SETUP' => 'System Setup',
			'MENU_SC' => 'System Configuration',
			'MENU_PG' => 'Payment Gateways',
			'MENU_DB' => 'Database Backup',
			'MENU_SN' => 'System News',
			'MENU_EM' => 'Email Manager',
			'MENU_CAL' => 'Calendar',
			'MENU_SUPPORT' => 'Support',
			'MENU_FORMS' => 'Forms',
			
			/* == Front Login  == */
			'LOGIN_TITLE' => 'Client Login',
			'LOGIN_INFO' => 'Please enter your valid username and password to login into your account.',
			'LOGIN_SUB' => 'Account Login',
			'LOGIN_BUT_NOW' => 'Login Now',
			'LOGIN_PASS_RESET' => 'Password Reset',
			'LOGIN_REG_NOW' => 'Register Account',
			'LOGIN_INFO1' => 'Enter your username and email address below to reset your password. A verification token will be sent to your email address.<br />Once you have received the token, you will be able to choose a new password for your account.',
			'LOGIN_SUB1' => 'Lost Password',
			'LOGIN_SUBMIT' => 'Submit Request',

			/* == Front Pass Reset  == */
			'PASS_OK' => '<span>Success!</span>You have successfully changed your password. Please check your email for further info!',
			'PASS_ERR' => '<span>Error!</span>There was an error during the process. Please contact the administrator.',
			'PASS_ESUBJECT' => 'Password Reset Request - '/* email subject */,
			
			/* == Front Register  == */
			'REG_TITLE' => 'User Registration',
			'REG_INFO' => 'Please fill out the form below to register your account.',
			'REG_SUB' => 'Create Account',
			'REG_SUBMIT' => 'Register Account',
			'REG_BACK' => 'Back to login',
			'REG_MSGOK' => '<span>Success!</span>You have successfully registered. <a href="index.php">Click here to login</a>',
			'REG_ERR' => '<span>Error!</span>There was an error during registration process. Please contact the administrator...',
			'REG_ESUBJECT' => 'Welcome to - '/* email subject */,
			
			/* == Front Profile  == */
			'PRO_TITLE' => 'Manage Your Account',
			'PRO_INFO' => 'Here you can make changes to your profile',
			'PRO_SUB' => 'User Account Edit',
			'PRO_SUBMIT' => 'Update Profile',
			'PRO_MSGOK' => '<span>Success!</span>Profile updated successfully!',
			
			/* == Front Dashboard  == */
			'FDASH_TITLE' => 'Welcome &rsaquo; ',
			'FDASH_INFO' => ' We\'ve made it easy for you to manage your billing, projects, and to communicate with our staff. Check the <a href="account.php?do=projects"><strong>Projects</strong></a> page to see if there are any items that need your attention. If the project manager sends an item for you to review, you\'ll be able to Approve or Reject the submission from this page. All client announcements are viewable from the <a href="account.php?do=contact"><strong>Messages</strong></a> page.',
			'FDASH_SUB' => 'Project Workflow',
			'FDASH_ITEM' => 'Item Name',
			'FDASH_PROJECT' => 'Project Name',
			'FDASH_SUBMITTED' => 'Submitted',
			'FDASH_ACTION' => 'Action Required',
			'FDASH_ACTION1' => 'Review Submission',
			'FDASH_ACTION2' => 'None',
			'FDASH_SUB1' => 'Pending Invoices',
			'FDASH_METHOD' => 'Method',
			'FDASH_PAY' => 'Pay Invoice!',
			
			/* == Front Projects  == */
			'FPRO_TITLE' => 'Current Project &rsaquo; ',
			'PFRO_ERR' => '<span>Info!</span>Ooops the selected project does not exist. <a href="account.php?do=projects">Back to Projects</a>',
			'FPRO_SUB' => 'Viewing &rsaquo; ',
			'FPRO_SENDFILE' => 'Submit a File',
			'FPRO_INFO' => 'This tool allows you to upload a file related to current project. The file will be stored in the project file for the staff to use. You will not be able to modify the file once it is submitted.',
			'FPRO_SUB1' => 'File Submission &rsaquo; ',
			'FPRO_SUB2' => 'Project Submissions, Drafts, &amp; Revisions',
			'FPRO_SUB3' => 'Related Tasks',
			'FPRO_TITLE1' => 'Current Project Submission',
			'FPRO_SUB4' => 'Viewing &rsaquo; ',
			'FPRO_ERR1' => '<span>Info!</span>Ooops the selected project does not exist. <a href="account.php?do=projects">Back to Projects</a>',
			'FPRO_REVIEW' => 'Review Notes',
			'FPRO_SUBMITTED' => 'Submitted By',
			'FPRO_DATESENT' => 'Date Submitted',
			'FPRO_APPREJ' => 'Approve/Reject',
			'FPRO_SUB5' => 'Review Submission',
			'FPRO_SUB6' => 'Review Decision',
			'FPRO_APPROVE' => 'Approve',
			'FPRO_REJECT' => 'Reject',
			'FPRO_COMMENTS' => 'Comments',
			'FPRO_SEND_REVIEW' => 'Submit Decision',
			'FPRO_SUBSENTOK' => '<span>Success!</span>Submission sent successfully!',
			'FPRO_SUBESUBJECT' => 'New Project Submission - '/* email subject */,
			'FPRO_TITLE2' => 'Related Project Files',
			'FPRO_FILESENTOK' => '<span>Success!</span>Project File added successfully!',
			'FPRO_TITLE3' => 'Current Projects',
			'FPRO_INFO2' => 'Monitor project progress and view notes or updates.',
			'FPRO_INFO3' => 'Please review each of the items below. These are important items that need your attention',
			
			/* == Front Billing  == */
			'FBILL_TITLE' => 'Billing Manager &rsaquo; Invoice Payment',
			'FBILL_SUB' => 'Viewing Invoice For &rsaquo; ',
			'FBILL_ERR' => '<span>Error!</span>You have selected invalid invoice',
			'FBILL_PAYOK' => '<span>Success!</span>Thank you, your payment has been processed.',
			'FBILL_PENDING'=> 'Amount Pending',
			'FBILL_PAYNOW'=> 'Paying Now',
			'FBILL_PAYNOW_T'=> 'If you don\'t wish to pay full amount at this time you can enter different value.<br />Change the value before selecting Payment Processor.',
			'FBILL_ERR1' => '<span>Error!</span>Payment amount cannot be zero or empty or greater than actual Amount Pending',
			'FBILL_ERR2' => '<span>Error!</span>You have selected an invalid payment method. Please try again',
			'FBILL_TITLE2' => 'Billing Manager &rsaquo; View Invoice',
			'FBILL_SUB2' => 'Viewing Invoice For &rsaquo; ',
			'FBILL_SUB3' => 'Viewing Invoice Entries',
			'FBILL_SUB4' => 'Viewing Payment Records',
			'FBILL_TITLE3' => 'Billing Manager',
			'FBILL_INFO' => 'Here you can view outstanding invoices, payment history etc...',
			'FBILL_NOPENDING' => '<span>Info!</span>You don\'t have any pending invoices yet...',
			'FBILL_SUB5' => 'Archived Invoices',
			
			/* == Front Messages  == */
			'FMSG_TITLE' => 'Message Center',
			'FMSG_INFO' => 'Here you can find latest news announcements, and also contact our support team',
			'FMSG_SUB' => 'Latest Announcements',
			'FMSG_POSTED' => 'Posted',
			'FMSG_CONTENT' => 'Content',
			'FMSG_SUB2' => 'Contact Us',
			'FMSG_MSG' => 'Message',
			'FMSG_MSGERR1' => 'Please enter your subject',
			'FMSG_MSGERR2' => 'Please enter your message',
			'FMSG_SEND' => 'Send Message',
			'FMSG_MSGOK' => '<span>Thank you!<\/span>Your message has been sent successfully',
			'FMSG_TITLE1' => 'Manage Instant Messages  &rsaquo; View Message',
			'FMSG_INFO1' => 'Here you can view and reply to your messages.',
			'FMSG_SUB3' => 'Viewing &rsaquo; ',
			'FMSG_SUB4' => 'My Messages',
			
			/* == Front Support  == */
			'FSUP_TITLE' => 'Manage Tickets &rsaquo; View Ticket',
			'FSUP_INFO' => 'Here you can replay to your support ticket.',
			'FSUP_SUB' => 'Ticket #',
			'FSUP_OPENCLOSE' => 'Open <a href="javascript:void:(0);" id="close-ticket">Close Ticket</a>',
			'FSUP_SUB1' => 'Submit a Reply To &rsaquo; ',
			'FSUP_BTNSEND' => 'Submit a Reply',
			'FSUP_TITLE1' => 'Manage Tickets &rsaquo; Send Ticket',
			'FSUP_INFO1' => 'Here you can create new support ticket.',
			'FSUP_SUB2' => 'Creating Support Ticket',
			'FSUP_SENDBTN' => 'Submit Ticket',
			'FSUP_TITLE2' => 'Support Center',
			'FSUP_INFO2' => 'Here you can find your support request tickets. <span><small class="open"></small> Open Ticket <small class="closed"></small> Closed Ticket</span>',
			'FSUP_SUB3' => 'Create Support Ticket',

			/* == Front Support  == */
			'FFORM_TITLE' => 'Request For Proposal',
			'FFORM_INFO' => 'Please use this form for requesting website design and development quotations.',
			'FFORM_ERR' => '<span>Error!</span>You have selected invalid form. Please select valid form from dropdown menu.',
			
			/* == Front Header  == */
			'FMENU_FORMS' => 'Select Form Option',
			'FMENU_SUPPORT' => 'Support Center',
			'FMENU_DASH' => 'Dashboard',
			'FMENU_DASH_T' => 'Respond to Workflow items',
			'FMENU_PROJECTS' => 'Projects',
			'FMENU_PROJECTS_T' => 'Monitor project progress',
			'FMENU_BILL' => 'Billing',
			'FMENU_BILL_T' => 'View invoices and payments',
			'FMENU_PROFILE' => 'Profile',
			'FMENU_PROFILE_T' => 'View and update profile',
			'FMENU_MSGS' => 'Messages',
			'FMENU_MSGS_T' => 'Contact and message area',
	  );
      
	  return $lang[$phrase];
  }
?>
