<?php
  /**
   * Mailer Class
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: class_mailer.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');

  class Mailer
  {
      private $company;
      private $mailer;
      private $smtp_host;
      private $smtp_user;
      private $smtp_pass;
      private $smtp_port;

      /**
       * Mailer::__construct()
       * 
       * @return
       */
      function __construct()
      {
          $this->company = Registry::get("Core")->company;
          $this->mailer = Registry::get("Core")->mailer;
          $this->smtp_host = Registry::get("Core")->smtp_host;
          $this->smtp_user = Registry::get("Core")->smtp_user;
          $this->smtp_pass = Registry::get("Core")->smtp_pass;
          $this->smtp_port = Registry::get("Core")->smtp_port;
      }

      /**
       * Mailer::sendMail()
       * 
       * @return
       */
      function sendMail()
      {
          require_once (BASEPATH . 'lib/swift/swift_required.php');

          if ($this->mailer == "SMTP") {
              $transport = Swift_SmtpTransport::newInstance($this->smtp_host, $this->smtp_port)->setUsername($this->smtp_user)->setPassword($this->smtp_pass);
          } else
              $transport = Swift_MailTransport::newInstance();

          return Swift_Mailer::newInstance($transport);
      }

  }
  $mail = new Mailer();
?>