<?php
  /**
   * Main
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: main.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php $subrow = $user->getSubmissions();?>
<?php $invactive = $user->getClientInvoices("<> 'Paid'");?>
<h1><?php echo lang('FDASH_TITLE') . $user->username;?></h1>
<p class="info"><?php echo lang('FDASH_INFO');?></p>
<?php if($subrow):?>
<h2><?php echo lang('FDASH_SUB');?></h2>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('FDASH_ITEM');?></th>
        <th class="left"><?php echo lang('FDASH_PROJECT');?></th>
        <th class="left"><?php echo lang('FDASH_SUBMITTED');?></th>
        <th class="left"><?php echo lang('FDASH_ACTION');?></th>
        <th><?php echo lang('VIEW');?></th>
      </tr>
    </thead>
    <?php foreach ($subrow as $row):?>
    <tr>
      <td align="center"><small><?php echo $row->id;?>.</small></td>
      <td><?php echo $row->title;?></td>
      <td><?php echo $row->ptitle;?></td>
      <td><?php echo Filter::doDate($core->short_date, $row->created);?></td>
      <td><?php echo ($row->status == 1) ? lang('FDASH_ACTION1') : lang('FDASH_ACTION2');?></td>
      <td align="center"><a href="account.php?do=projects&amp;action=viewsubmission&amp;id=<?php echo $row->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '. $row->title;?>"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<?php endif;?>

<?php if($invactive):?>
<h2 style="margin-top:10px"><?php echo lang('FDASH_SUB1');?></h2>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('FDASH_SUB1');?></th>
        <th class="left"><?php echo lang('INVC_DUEDATE');?></th>
        <th class="left"><?php echo lang('TOTAL');?></th>
        <th class="left"><?php echo lang('PAID');?></th>
        <th class="left"><?php echo lang('FDASH_METHOD');?></th>
        <th width="100"><?php echo lang('ACTION');?></th>
      </tr>
    </thead>
    <?php foreach ($invactive as $row):?>
    <tr>
      <td align="center" class="red"><small><?php echo $row->id;?></small></td>
      <td><a href="account.php?do=billing&amp;action=viewinvoice&amp;id=<?php echo $row->id;?>"><?php echo $row->title;?></a></td>
      <td><?php echo Filter::doDate($core->short_date, $row->duedate);?></td>
      <td><?php echo $row->amount_total;?></td>
      <td><?php echo $row->amount_paid;?></td>
      <td><?php echo $row->method;?></td>
      <td align="center" class="red"><a href="account.php?do=billing&amp;action=invoice&amp;id=<?php echo $row->id;?>"><?php echo lang('FDASH_PAY');?></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
  </table>
</div>
<?php endif;?>