<?php
  /**
   * Print Pdf
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: print_pdf.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
	  
  if (!$user->logged_in)
    redirect_to("index.php");

  $row = $user->getProjectInvoiceById();
  $invdata = $user->getProjectInvoiceData();
  $paydata = $user->getProjectInvoicePayments();
?>
<?php if($row):?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Invoice For &rsaquo;<?php echo $row->ptitle;?></title>
<style type="text/css">
body { background-color: #fff; color: #333; font-family: Verdana, Geneva, sans-serif; margin: 0px; font-size: 1em; padding: 0px; }
.data { background-color: #ddd; font-weight: bold; font-size: 0.7em; pborder-top-width: 1px; border: 1px solid #ddd; }
.data tr th { color: #222; background-color: #ddd; padding: 5px; font-size: 1.2em; }
.data tr td { background-color: #FFF; }
table { font-size: 1em; }
h4 { margin:0px; padding:0px; font-size: 1.2em; font-weight: normal; }
</style>
</head>
<body>
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td style="width: 60%;" valign="top">
    <?php if(file_exists(UPLOADS.'print_logo.png')):?>
    <img src="<?php echo UPLOADS;?>print_logo.png" alt="<?php echo Registry::get("Core")->company;?>" />
	<?php elseif (Registry::get("Core")->logo):?>
    <img src="<?php echo UPLOADS . Registry::get("Core")->logo;?>" alt="<?php echo Registry::get("Core")->company;?>" />
	<?php else:?>
	<?php echo Registry::get("Core")->company;?>
	<?php endif;?></td>
    <td valign="top" style="width:40%;text-align: right"><h4 style="margin:0px;padding:0px;font-size: 12px;">Invoice: #<?php echo $row->id;?></h4>
      <h4 style="margin:0px;padding:0px;font-size: 12px;"><?php echo date('M d Y');?></h4></td>
  </tr>
</table>
<div style="background-color:#ddd;height:1px">&nbsp;</div>
<div style="height:20px"></div>
<table width="100%" border="0" cellpadding="5" cellspacing="0">
  <tr>
    <td valign="top" style="width:60%">Payment To</td>
    <td colspan="2" valign="top" style="width:40%">Bill To</td>
  </tr>
  <tr>
    <td valign="top" style="width:60%"><h2 style="font-size: 18px; margin: 0px; padding: 0px;"><?php echo $core->company;?></h2>
      <?php echo $core->address;?><br />
      <?php echo $core->city.', '.$core->state.' '.$core->zip;?><br />
      <?php echo ($core->phone) ? 'Phone: '.$core->phone : '';?><br />
      <?php echo ($core->fax) ? 'Fax: '.$core->fax : '';?></td>
    <td colspan="2" valign="top" style="width:40%"><h2 style="font-size: 18px; margin: 0px; padding: 0px;"><?php echo $row->name;?></h2>
      <?php echo $row->company;?><br />
      <?php echo $row->address;?><br />
      <?php echo $row->city.', '.$row->state.' '.$row->zip;?><br />
      <?php echo ($row->phone) ? 'Phone: '.$row->phone : '';?></td>
  </tr>
  <tr>
    <td colspan="3" valign="top" style="padding:5px"><div style="background-color:#777;height:3px">&nbsp;</div></td>
  </tr>
  <tr>
    <td valign="top" style="width:60%">Business Number: <?php echo Registry::get("Core")->tax_number;?></td>
    <td valign="top" style="width:20%">Invoice Total:<br />
      <?php echo ($row->amount_paid != $row->amount_total) ? '<span style="color:#F00000">Amount Paid</span>' : 'Balance Due';?>:<br />
      Due Date:</td>
    <td valign="top" style="width:20%"><?php echo $row->amount_total;?><br />
      <?php echo ($row->amount_paid != $row->amount_total) ? '<span style="color:#F00000">'.$row->amount_paid.'</span>' : $row->amount_paid;?> <br />
      <?php echo $row->ddate;?></td>
  </tr>
</table>
<div style="height:20px"></div>
<table width="100%" border="0" cellpadding="5" cellspacing="0" class="data" style="width:100%">
  <tr>
    <th align="left" style="width:60%">Invoice Items</th>
    <th align="right" style="width:40%">Price</th>
  </tr>
  <?php if($invdata):?>
  <?php foreach($invdata as $irow):?>
  <tr>
    <td><h4><?php echo $irow->title;?></h4>
      <?php echo $irow->description;?></td>
    <td align="right"><?php echo $irow->amount;?></td>
  </tr>
  <?php endforeach;?>
  <?php if($row->tax):?>
  <tr>
    <td align="right"><?php echo $core->tax_name;?>:</td>
    <td align="right"><?php echo $row->tax;?></td>
  </tr>
  <?php endif;?>
  <tr>
    <td align="right">Invoice Total:</td>
    <td align="right"><?php echo $row->amount_total;?></td>
  </tr>
  <?php endif;?>
</table>
<?php if($paydata):?>
<div style="height:20px"></div>
<table width="100%" border="0" cellpadding="5" cellspacing="0" class="data" style="width:100%">
  <tr>
    <th align="left" style="width:60%">Payment Records</th>
    <th align="right" style="width:40%">Amount</th>
  </tr>
  <?php foreach($paydata as $prow):?>
  <tr>
    <td valign="top"><h4>Reference on: <?php echo $prow->cdate?></h4>
      <?php echo $prow->description?></td>
    <td align="right" valign="top"><?php echo $prow->amount;?></td>
  </tr>
  <?php endforeach;?>
</table>
<?php endif;?>
<div style="height:30px"></div>
<table width="100%" border="0" cellpadding="5" cellspacing="0" class="data" style="width:100%">
  <tr>
    <th align="center">To make a payment, please, login to the client area at: <?php echo $core->site_url;?></th>
  </tr>
</table>
<div style="background-color:#777;height:2px">&nbsp;</div>
</body>
</html>
<?php else:?>
<?php die('You have selected invalid invoice');?>
<?php endif;?>