<?php
  /**
   * Projects
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: projects.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "viewproject": ?>
<?php $row = $user->getProjectById();?>
<?php if(!$row):?>
<?php echo Filter::msgInfo(lang('PFRO_ERR'),false);?>
<?php else:?>
<?php $subrow = $user->getSubmissionsByProjectId();?>
<?php $taskrow = $user->getTasksByProjectId();?>
<h1><img src="images/project-front.png" alt="" /><?php echo lang('FPRO_TITLE') . $row->title;?></h1>
<div class="box">
  <table width="100%" cellpadding="0" cellspacing="0" class="forms">
    <thead>
      <tr>
        <th colspan="4" class="left"><?php echo lang('FPRO_SUB') . $row->title;?></th>
      </tr>
    </thead>
    <tr>
      <th width="200"><?php echo lang('PROJ_TYPE');?>:</th>
      <td><?php echo $row->typetitle;?>&nbsp;</td>
      <td width="200">&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <th><?php echo lang('PROJ_DESC');?>:</th>
      <td><?php echo cleanOut($row->body);?>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <th><?php echo lang('PROJ_STATUS');?>:</th>
      <td><?php echo $content->progressBarStatus($row->p_status);?></td>
      <th><?php echo lang('PROJ_MANAGER');?>:</th>
      <td><?php echo $row->staffname;?></td>
    </tr>
    <tr>
      <th><?php echo lang('PROJ_START');?>:</th>
      <td><?php echo Filter::doDate($core->short_date, $row->start_date);?></td>
      <th><?php echo lang('PROJ_END');?>:</th>
      <td><?php echo Filter::doDate($core->short_date, $row->end_date);?></td>
    </tr>
    <tr>
      <th><?php echo lang('PROJ_BILLSTSTUS');?>:</th>
      <td><?php echo $content->progressBarBilling($row->b_status, $row->cost);?></td>
      <th><?php echo lang('PROJ_PRICE');?>:</th>
      <td><?php echo $core->formatMoney($row->cost);?></td>
    </tr>
  </table>
</div>
<br />
<?php if($core->enable_uploads):?>
<h2><a href="javascript:void(0);" class="do-upload img-wrap2"><?php echo lang('FPRO_SENDFILE');?></a></h2>
<div id="show-upload" style="display:none">
  <p class="info"><?php echo lang('FPRO_INFO');?></p>
  <div class="box">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table width="100%" cellpadding="0" cellspacing="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('FPRO_SUB1') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('FILE_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_DESC');?>:</th>
          <td><textarea name="filedesc" cols="45" rows="5"></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('FILE_ATTACH');?>: <?php echo required();?></th>
          <td><input name="filename" type="file" size="40" class="fileinput mask" /></td>
        </tr>
        <tr>
          <td colspan="3"><input name="addfile" type="submit" value="<?php echo lang('FILE_ADD');?>" class="button"/></td>
        </tr>
      </table>
      <input name="project_id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
  <br />
</div>
<?php echo Core::doForm("processProjectFile","ajax/controller.php");?> 
<script type="text/javascript">
// <![CDATA[
 $(".mask").filestyle({ 
     image: "images/file-button.png",
     imageheight : 29,
     imagewidth : 75,
     width : 230
 });
  $("a.do-upload").click(function () {
	$("#show-upload").toggle();
  });
// ]]>
</script>
<?php endif;?>
<div class="box">
<h2><?php echo lang('FPRO_SUB2');?></h2>
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th width="200" nowrap="nowrap" class="left"><?php echo lang('SUBS_NAME');?></th>
        <th width="150" nowrap="nowrap" class="left"><?php echo lang('SUBS_TYPE');?></th>
        <th width="100" nowrap="nowrap" class="left"><?php echo lang('CREATED');?></th>
        <th nowrap="nowrap" class="left"><?php echo lang('STATUS');?></th>
        <th width="50"><?php echo lang('VIEW');?></th>
      </tr>
    </thead>
    <?php if(!$subrow):?>
    <tr>
      <td colspan="6"><?php echo Filter::msgInfo(lang('SUBS_NOSUBS'),false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($subrow as $srow):?>
    <tr>
      <td align="center"><small><?php echo $srow->id;?>.</small></td>
      <td><?php echo $srow->title;?></td>
      <td><?php echo $srow->s_type;?></td>
      <td><?php echo Filter::doDate($core->short_date, $srow->created);?></td>
      <td><?php echo $content->projectSubmissionStatus($srow->status);?></td>
      <td align="center"><a href="account.php?do=projects&amp;action=viewsubmission&amp;id=<?php echo $srow->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$srow->title;?>"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($srow);?>
    <?php endif;?>
  </table>
<br />
<h2><?php echo lang('FPRO_SUB3');?></h2>
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th width="200" nowrap="nowrap" class="left"><?php echo lang('TASK_NAME');?></th>
        <th width="150" nowrap="nowrap" class="left"><?php echo lang('TASK_PROGRESS');?></th>
        <th width="100" nowrap="nowrap" class="left"><?php echo lang('TASK_START');?></th>
        <th nowrap="nowrap" class="left"><?php echo lang('INVC_DUEDATE');?></th>
        <th width="50"><?php echo lang('INFO');?></th>
      </tr>
    </thead>
    <?php if(!$taskrow):?>
    <tr>
      <td colspan="6"><?php echo Filter::msgInfo(lang('TASK_NOTASKS'),false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($taskrow as $trow):?>
    <tr>
      <td align="center"><small><?php echo $trow->id;?>.</small></td>
      <td><?php echo $trow->title;?></td>
      <td><?php echo $content->progressBarStatus($trow->progress);?></td>
      <td><?php echo Filter::doDate($core->short_date, $trow->created);?></td>
      <td><?php echo Filter::doDate($core->short_date, $trow->duedate);?></td>
      <td align="center"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo cleanOut(wordwrap($trow->details,40, "<br />\n"));?>"/></td>
    </tr>
    <?php endforeach;?>
    <?php unset($trow);?>
    <?php endif;?>
  </table>
</div>
<?php endif;?>
<?php break;?>
<?php case"viewsubmission":?>
<h1><img src="images/project-front.png" alt="" /><?php echo lang('FPRO_TITLE1');?></h1>
<?php $row = $user->getSingleSubmissionsById();?>
<?php if(!$row):?>
<?php echo Filter::msgInfo(lang('FPRO_ERR1'),false);?>
<?php else:?>
<?php $filerow = $user->getFilesByProject($row->project_id);?>
<div class="box">
  <table width="100%" cellpadding="0" cellspacing="0" class="forms">
    <thead>
      <tr>
        <th colspan="2" class="left"><?php echo lang('FPRO_SUB4') . $row->title;?></th>
      </tr>
    </thead>
    <tr>
      <th width="200"><?php echo lang('SUBS_NAME');?></th>
      <td><?php echo $row->title;?></td>
    </tr>
    <tr>
      <th><?php echo lang('SUBS_TYPE');?>:</th>
      <td><?php echo $row->s_type;?></td>
    </tr>
    <tr>
      <th><?php echo lang('PROJ_NAME');?>:</th>
      <td><?php echo $row->ptitle;?></td>
    </tr>
    <tr>
      <th><?php echo lang('NOTES');?>:</th>
      <td><?php echo cleanOut($row->description);?></td>
    </tr>
    <tr>
      <th><?php echo lang('FPRO_REVIEW');?>:</th>
      <td><?php echo cleanOut($row->review);?></td>
    </tr>
    <tr>
      <th><?php echo lang('FPRO_SUBMITTED');?>:</th>
      <td><?php echo $row->staffname;?></td>
    </tr>
    <tr>
      <th><?php echo lang('FPRO_DATESENT');?>:</th>
      <td><?php echo $row->start;?></td>
    </tr>
    <tr>
      <th><?php echo lang('STATUS');?>:</th>
      <td><?php echo $content->projectSubmissionStatus($row->status);?></td>
    </tr>
    <?php if(!$row->reviewed):?>
    <tr>
      <td><a href="javascript:void(0);" class="button" id="do-submission"><?php echo lang('FPRO_APPREJ');?></a></td>
      <td>&nbsp;</td>
    </tr>
    <?php endif;?>
  </table>
</div>
<div id="dialog-add-submission" style="display:none;" title="<?php echo lang('FPRO_SUB5');?>">
  <form action="" method="post" id="record_form" name="record_form">
    <table cellspacing="0" cellpadding="0" class="forms">
      <tbody>
        <tr>
          <th width="200"><?php echo lang('FPRO_SUB6');?>:</th>
          <td><select class="select" name="status" style="width:170px">
              <option value="2"><?php echo lang('FPRO_APPROVE');?></option>
              <option value="3"><?php echo lang('FPRO_REJECT');?></option>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('FPRO_COMMENTS');?>:</th>
          <td><textarea name="review" cols="50" rows="4"></textarea></td>
        </tr>
      </tbody>
    </table>
    <input name="processSubmissionRecord" type="hidden" value="<?php echo Filter::$id;?>" />
  </form>
</div>
<script type="text/javascript">
// <![CDATA[
$(document).ready(function () {
    // Add Entry
    $('a#do-submission').live('click', function () {
        $("#dialog-add-submission").dialog('open');
        return false;
    });
	
    $("#dialog-add-submission").dialog({
        resizable: true,
        autoOpen: false,
        width: 600,
        height: "auto",
        zindex: 9998,
        modal: false,
        buttons: {
            '<?php echo lang('FPRO_SEND_REVIEW');?>': function () {
				var str = $("#record_form").serialize();
                $.ajax({
                    type: 'post',
                    url: "ajax/controller.php",
                    data: str,
					success: function (res) {
						$("#msgholder").html(res);
						$("html, body").animate({
							scrollTop: 0
						}, 600);
					}
                });
            },
            '<?php echo lang('CANCEL');?>': function () {
                $(this).dialog('close');
            }
        }
    });
});
// ]]>
</script> 
<br />
<h2><?php echo lang('FPRO_TITLE2');?></h2>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('FILE_NAME');?></th>
        <th class="left"><?php echo lang('FILESIZE');?></th>
        <th class="left"><?php echo lang('FDASH_SUBMITTED');?></th>
        <th><?php echo lang('VERSION');?></th>
        <th><?php echo lang('DESC');?></th>
        <th><?php echo lang('DOWNLOAD');?></th>
      </tr>
    </thead>
    <?php if(!$filerow):?>
    <tr>
      <td colspan="7"><?php echo Filter::msgInfo(lang('FILE_NOFILES'),false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($filerow as $frow):?>
    <tr>
      <td align="center"><small><?php echo $frow->id;?>.</small></td>
      <td><?php echo $frow->title;?></td>
      <td><?php echo getSize($frow->filesize);?></td>
      <td><?php echo Filter::doDate($core->short_date, $frow->created);?></td>
      <td align="center"><?php echo $frow->version;?></td>
      <td align="center"><img src="images/info2.png" alt="" class="tooltip img-wrap2" title="<?php echo cleanOut(wordwrap($frow->filedesc,40, "<br />\n"));?>"/></td>
      <td align="center"><a href="download.php?fid=<?php echo $frow->id;?>&amp;pid=<?php echo $frow->pid;?>"><img src="images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD').': '.$frow->title;?>"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($frow);?>
    <?php endif;?>
  </table>
</div>
<?php endif;?>
<?php break;?>
<?php default: ?>
<?php $projectrow = $user->getProjects();?>
<?php $subrow = $user->getSubmissions();?>
<h1><img src="images/project-front.png" alt="" /><?php echo lang('FPRO_TITLE3');?></h1>
<p class="info"><?php echo lang('FPRO_INFO2');?>.</p>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('PROJ_NAME');?></th>
        <th class="left"><?php echo lang('PROJ_TYPE');?></th>
        <th class="left"><?php echo lang('PROJ_END');?></th>
        <th class="left"><?php echo lang('COMPLETED');?></th>
        <th><?php echo lang('VIEW');?></th>
      </tr>
    </thead>
    <?php if(!$projectrow):?>
    <tr>
      <td colspan="6"><?php echo Filter::msgInfo(lang('PROJ_NOPROJECT'),false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($projectrow as $row):?>
    <tr>
      <td align="center"><small><?php echo $row->id;?>.</small></td>
      <td><?php echo $row->title;?></td>
      <td><?php echo $row->typetitle;?></td>
      <td><?php echo $row->enddate;?></td>
      <td><?php echo $content->progressBarStatus($row->p_status);?></td>
      <td align="center"><a href="account.php?do=projects&amp;action=viewproject&amp;id=<?php echo $row->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->title;?>"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
    <?php endif;?>
  </table>
</div>
<br />
<h2><?php echo lang('FDASH_SUB');?></h2>
<p class="info"><?php echo lang('FPRO_INFO3');?></p>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('FDASH_ITEM');?></th>
        <th class="left"><?php echo lang('PROJ_NAME');?></th>
        <th class="left"><?php echo lang('FDASH_SUBMITTED');?></th>
        <th class="left"><?php echo lang('FDASH_ACTION');?></th>
        <th><?php echo lang('VIEW');?></th>
      </tr>
    </thead>
    <?php if(!$subrow):?>
    <tr>
      <td colspan="6"><?php echo Filter::msgInfo(lang('SUBS_NOSUBS'),false);?></td>
    </tr>
    <?php else:?>
    <?php foreach ($subrow as $row):?>
    <tr>
      <td align="center"><small><?php echo $row->id;?>.</small></td>
      <td><?php echo $row->title;?></td>
      <td><?php echo $row->ptitle;?></td>
      <td><?php echo $row->start;?></td>
      <td><?php echo ($row->status == 1) ? lang('FDASH_ACTION1'): lang('FDASH_ACTION2');?></td>
      <td align="center"><a href="account.php?do=projects&amp;action=viewsubmission&amp;id=<?php echo $row->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->title;?>"/></a></td>
    </tr>
    <?php endforeach;?>
    <?php unset($row);?>
    <?php endif;?>
  </table>
</div>
<?php break;?>
<?php endswitch;?>
