-- ================================================================
--
-- @version $Id: structure.sql 2011-12-27 10:12:05 gewa $
-- @package Freelance Manager
-- @copyright 2011. wojoscripts.com
--
-- ================================================================
-- Database structure
-- ================================================================

--
-- Table structure for table `forms`
--

CREATE TABLE IF NOT EXISTS `forms` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `form_data` text,
  `form_hash` varchar(50) DEFAULT NULL,
  `template` text,
  `mailto` varchar(50) DEFAULT NULL,
  `captcha` tinyint(1) NOT NULL DEFAULT '0',
  `sendmessage` varchar(200) DEFAULT NULL,
  `submit_btn` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `forms_data`
--

CREATE TABLE IF NOT EXISTS `forms_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL DEFAULT '0',
  `form_data` text,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `gateways`
--

CREATE TABLE IF NOT EXISTS `gateways` (
  `id` tinyint(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `displayname` varchar(200) NOT NULL,
  `dir` varchar(200) NOT NULL,
  `live` tinyint(1) NOT NULL DEFAULT '0',
  `extra_txt` varchar(200) NOT NULL,
  `extra_txt2` varchar(200) NOT NULL,
  `extra_txt3` varchar(200) DEFAULT NULL,
  `extra` varchar(200) NOT NULL,
  `extra2` varchar(200) NOT NULL,
  `extra3` varchar(200) DEFAULT NULL,
  `info` text,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `gateways`
--

INSERT INTO `gateways` (`id`, `name`, `displayname`, `dir`, `live`, `extra_txt`, `extra_txt2`, `extra_txt3`, `extra`, `extra2`, `extra3`, `info`, `active`) VALUES
(1, 'paypal', 'PayPal', 'paypal', 0, 'Paypal Email Address', 'Currency Code', 'Not in Use', 'you@paypalemail.com', 'CAD', '', '&lt;p&gt;&lt;a href=&quot;http://www.paypal.com/&quot; title=&quot;PayPal&quot; rel=&quot;nofollow&quot; target=&quot;_blank&quot;&gt;Click here to setup an account with Paypal&lt;/a&gt; &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n			If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Paypal email address&lt;/strong&gt; - Enter your PayPal Business email address here. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Currency Code&lt;/strong&gt; - Enter your currency code here. Valid choices are: &lt;/p&gt;\r\n				&lt;ul&gt;\r\n					&lt;li&gt; USD (U.S. Dollar)&lt;/li&gt;\r\n					&lt;li&gt; EUR (Euro) &lt;/li&gt;\r\n					&lt;li&gt; GBP (Pound Sterling) &lt;/li&gt;\r\n					&lt;li&gt; CAD (Canadian Dollar) &lt;/li&gt;\r\n					&lt;li&gt; JPY (Yen). &lt;/li&gt;\r\n					&lt;li&gt; If omitted, all monetary fields will use default system setting Currency Code. &lt;/li&gt;\r\n				&lt;/ul&gt;\r\n			&lt;p&gt;&lt;strong&gt;Not in Use&lt;/strong&gt; - This field it&#039;s not in use. Leave it empty. &lt;/p&gt;\r\n	        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', 1),
(2, 'moneybookers', 'MoneyBookers', 'moneybookers', 0, 'MoneyBookers Email Address', 'Currency Code', 'Secret Passphrase', 'you@mb.com', 'EUR', 'mypassphrase', '&lt;p&gt;&lt;a href=&quot;http://www.moneybookers.com/&quot; title=&quot;http://www.moneybookers.net/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with MoneyBookers&lt;/a&gt;&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n			If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - MoneyBookers does not have demo mode. You need to open testing acounts. One seller and one buyer. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;MoneyBookers email address&lt;/strong&gt; - Enter your MoneyBookers email address here. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Secret Passphrase&lt;/strong&gt; - This field must be set at Moneybookers.com.&lt;/p&gt;\r\n	        &lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - If using recurring payment method, you need to set up and activate the IPN Url in your account: &lt;/p&gt;', 1),
(3, 'alertpay', 'AlertPay', 'alertpay', 0, 'AlertPay Email Address', 'Currency Code', 'IPN Security Code', 'seller_1_you@mail.com', 'USD', 'dh897987dfh89', '&lt;p&gt;&lt;a href=&quot;http://www.alertpay.com/&quot; title=&quot;http://www.alertpay.net/&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with AlertPay&lt;/a&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n  If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;AlertPay email address&lt;/strong&gt; - Enter your AlertPay email address here. &lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Security Code&lt;/strong&gt; - This code needs to be generated in your AlertPay control panel.&lt;/p&gt;\r\n&lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - This has to be set in the AlertPay control panel. You will also need to check the &quot;IPN Status&quot; to enabled.&lt;/p&gt;', 1),
(4, 'anet', 'AuthorizeNet', 'anet', 0, 'API Login Id', 'MD5 Hash Key', 'Transaction Key', 'dfdfhdfh', '123456', 'df09u0dfoh', '&lt;p&gt;&lt;a href=&quot;http://www.authorize.net/&quot; title=&quot;http://www.authorize.net//&quot; rel=&quot;nofollow&quot;&gt;Click here to setup an account with Authorize.Net&lt;/a&gt;&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Gateway Name&lt;/strong&gt; - Enter the name of the payment provider here.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Active&lt;/strong&gt; - Select Yes to make this payment provider active. &lt;br/&gt;\r\n			  If this box is not checked, the payment provider will not show up in the payment provider list during checkout.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Set Live Mode&lt;/strong&gt; - If you would like to test the payment provider settings, please select No. &lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;Login ID&lt;/strong&gt; - To obtain your API Login ID:&lt;/p&gt;\r\n			&lt;ol type=&quot;1&quot;&gt;\r\n			  &lt;li&gt; Log into the Merchant Interface at &lt;a href=&quot;https://secure.authorize.net&quot; target=&quot;_blank&quot;&gt;https://secure.authorize.net&lt;/a&gt;&lt;/li&gt;\r\n			  &lt;li&gt; Select Settings under Account in the main menu on the left &lt;/li&gt;\r\n			  &lt;li&gt; Click API Login ID and Transaction Key in the Security Settings section &lt;/li&gt;\r\n			  &lt;li&gt; If you have not already obtained an API Login ID and Transaction Key for your account,&lt;br/&gt;\r\n				you will need to enter the secret answer to the secret question you configured at account activation. &lt;/li&gt;\r\n			  &lt;li&gt; Click Submit. &lt;/li&gt;\r\n			&lt;/ol&gt;\r\n			&lt;p&gt;&lt;strong&gt;MD5 Hash&lt;/strong&gt; - To obtain your MD5 Hash:&lt;/p&gt;\r\n			&lt;ol type=&quot;1&quot;&gt;\r\n			  &lt;li&gt; Log into the Merchant Interface at &lt;a href=&quot;https://secure.authorize.net&quot; target=&quot;_blank&quot;&gt;https://secure.authorize.net&lt;/a&gt;&lt;/li&gt;\r\n			  &lt;li&gt; Select Settings under Account in the main menu on the left &lt;/li&gt;\r\n			  &lt;li&gt; Click MD5 Hash in the Security Settings section &lt;/li&gt;\r\n			  &lt;li&gt;Enter a secret word, phrase, or value and remember this.&lt;/li&gt;\r\n			  &lt;li&gt; Click Submit. &lt;/li&gt;\r\n			&lt;/ol&gt;\r\n			&lt;strong&gt;Transaction Key&lt;/strong&gt; - To obtain a Transaction Key:\r\n			&lt;ol type=&quot;1&quot;&gt;\r\n			  &lt;li&gt; Log on to the Merchant Interface at &lt;a href=&quot;https://secure.authorize.net&quot; target=&quot;_blank&quot;&gt;https://secure.authorize.net&lt;/a&gt;&lt;/li&gt;\r\n			  &lt;li&gt; Select Settings under Account in the main menu on the left &lt;/li&gt;\r\n			  &lt;li&gt; Click API Login ID and Transaction Key in the Security Settings section &lt;/li&gt;\r\n			  &lt;li&gt; Enter the secret answer to the secret question you configured when you activated your user account &lt;/li&gt;\r\n			  &lt;li&gt; Click Submit &lt;/li&gt;\r\n			&lt;/ol&gt;\r\n			&lt;p&gt;The Transaction Key for your account is displayed on a confirmation page.&lt;/p&gt;\r\n			&lt;p&gt;&lt;strong&gt;IPN Url&lt;/strong&gt; - This option it\\&#039;s not being used.&lt;/p&gt;', 1);

--
-- Table structure for table `invoices`
--

CREATE TABLE IF NOT EXISTS `invoices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `project_id` int(11) NOT NULL DEFAULT '0',
  `client_id` int(11) NOT NULL DEFAULT '0',
  `created` date NOT NULL,
  `duedate` date NOT NULL,
  `amount_total` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  `amount_paid` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  `method` varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `tax` decimal(7,2) NOT NULL DEFAULT '0.00',
  `status` varchar(45) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `invoice_data`
--

CREATE TABLE IF NOT EXISTS `invoice_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `invoice_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL,
  `description` text NOT NULL,
  `amount` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  `tax` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `invoice_payments`
--

CREATE TABLE IF NOT EXISTS `invoice_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  `method` varchar(20) NOT NULL,
  `amount` decimal(7,2) NOT NULL DEFAULT '0.00',
  `created` date NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `sender` INT(11) NOT NULL,
  `recipient` INT(11) NOT NULL,
  `created` DATETIME NOT NULL,
  `msgsubject` VARCHAR(200) NOT NULL,
  `body` TEXT NOT NULL,
  `status_s` TINYINT(1) NOT NULL DEFAULT '0',
  `status_r` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

--
-- Table structure for table `news`
--

CREATE TABLE IF NOT EXISTS `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `body` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `author` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `created` date NOT NULL DEFAULT '0000-00-00',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `permissions`
--

CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `projects`
--

CREATE TABLE IF NOT EXISTS `projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `project_type` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `body` text NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `cost` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  `b_status` DECIMAL(13,2) NOT NULL DEFAULT '0.00',
  `p_status` varchar(3) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `project_files`
--

CREATE TABLE IF NOT EXISTS `project_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL DEFAULT '0',
  `project_id` int(11) NOT NULL DEFAULT '0',
  `client_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(200) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `filename` varchar(60) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `filedesc` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `filesize` decimal(10,2) NOT NULL,
  `created` datetime NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `project_types`
--

CREATE TABLE IF NOT EXISTS `project_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `settings`
--

CREATE TABLE IF NOT EXISTS `settings` (
  `company` varchar(75) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `site_url` varchar(75) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `site_email` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `address` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `city` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `state` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `zip` varchar(16) NOT NULL,
  `phone` varchar(16) DEFAULT NULL,
  `fax` varchar(16) DEFAULT NULL,
  `logo` varchar(60) NOT NULL,
  `short_date` varchar(20) NOT NULL,
  `long_date` varchar(20) NOT NULL,
  `dtz` varchar(200) NOT NULL,
  `weekstart` tinyint(1) NOT NULL DEFAULT '1',
  `enable_reg` tinyint(1) NOT NULL DEFAULT '1',
  `enable_tax` tinyint(1) NOT NULL DEFAULT '0',
  `tax_name` varchar(55) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `tax_rate` float(3,2) NOT NULL,
  `tax_number` VARCHAR(100) DEFAULT NULL,
  `enable_offline` tinyint(1) NOT NULL DEFAULT '1',
  `offline_info` text,
  `enable_uploads` tinyint(1) NOT NULL DEFAULT '1',
  `file_types` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `file_max` varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `perpage` varchar(3) NOT NULL DEFAULT '10',
  `sbackup` varchar(50) DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `cur_symbol` varchar(2) DEFAULT NULL,
  `mailer` enum('PHP','SMTP') NOT NULL DEFAULT 'PHP',
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_user` varchar(50) DEFAULT NULL,
  `smtp_pass` varchar(50) DEFAULT NULL,
  `smtp_port` int(2) DEFAULT NULL,
  `crmv` varchar(5) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`company`, `site_url`, `site_email`, `address`, `city`, `state`, `zip`, `phone`, `fax`, `logo`, `short_date`, `long_date`, `dtz`, `weekstart`, `enable_reg`, `enable_tax`, `tax_name`, `tax_rate`,  `tax_number`, `enable_offline`, `offline_info`, `enable_uploads`, `file_types`, `file_max`, `perpage`, `sbackup`, `currency`, `cur_symbol`, `mailer`, `smtp_host`, `smtp_user`, `smtp_pass`, `smtp_port`, `crmv`) VALUES
('', '', '', '123 Main St.', 'Toronto', 'Ontario', 'M2J 1K5', '555-555-5555', '444-444-4444', 'logo.png', '%b %d %Y', '%d %B %Y %H:%M', 'America/Toronto', 1, 1, 1, 'HST', '0.13', '123456789-WOJO-321', 1, 'Instructions for offline payments\r\nSuch as bank info, address etc...', 1, 'gif,png,jpg,jpeg,pdf,zip,rar', '10485760', '10', '', 'CAD', '$', 'PHP', '', '', '', 0, '1.06');

--
-- Table structure for table `submissions`
--

CREATE TABLE IF NOT EXISTS `submissions` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `project_id` INT(4) NOT NULL,
  `staff_id` INT(4) NOT NULL,
  `title` VARCHAR(255) NOT NULL,
  `description` TEXT NOT NULL,
  `s_type` VARCHAR(55) NOT NULL,
  `created` DATETIME NOT NULL,
  `review_date` DATETIME NOT NULL,
  `review` TEXT NOT NULL,
  `reviewed` TINYINT(1) NOT NULL DEFAULT '0',
  `status` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `support_responses`
--

CREATE TABLE IF NOT EXISTS `support_responses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL DEFAULT '0',
  `user_type` varchar(15) NOT NULL,
  `created` datetime NOT NULL,
  `body` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `support_tickets`
--

CREATE TABLE IF NOT EXISTS `support_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL DEFAULT '0',
  `client_id` int(11) NOT NULL DEFAULT '0',
  `department` varchar(50) DEFAULT NULL,
  `priority` varchar(50) DEFAULT NULL,
  `subject` varchar(200) DEFAULT NULL,
  `body` text,
  `created` datetime DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `tasks`
--

CREATE TABLE IF NOT EXISTS `tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL,
  `staff_id` int(55) NOT NULL,
  `client_access` tinyint(1) NOT NULL DEFAULT '0',
  `author_id` int(11) NOT NULL,
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `details` text CHARACTER SET utf8 COLLATE utf8_bin,
  `created` datetime DEFAULT NULL,
  `duedate` datetime DEFAULT NULL,
  `progress` varchar(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `time_billing`
--

CREATE TABLE IF NOT EXISTS `time_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(8) NOT NULL DEFAULT '0',
  `client_id` int(8) NOT NULL DEFAULT '0',
  `project_id` int(8) NOT NULL DEFAULT '0',
  `task_id` int(8) NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '0',
  `description` text,
  `hours` tinyint(2) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(50) NOT NULL,
  `email` varchar(40) NOT NULL,
  `fname` varchar(32) NOT NULL,
  `lname` varchar(32) NOT NULL,
  `company` varbinary(150) DEFAULT NULL,
  `address` varchar(200) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `zip` varchar(20) DEFAULT NULL,
  `phone` varchar(16) DEFAULT NULL,
  `userlevel` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT '0000-00-00 00:00:00',
  `notes` text,
  `lastlogin` datetime DEFAULT '0000-00-00 00:00:00',
  `lastip` varchar(16) DEFAULT '0',
  `active` enum('y','n','t','b') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;