<?php
  /**
   * Support
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: support.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "view": ?>
<?php $row = $user->getSupportTicketById();?>
<?php $resrow = $user->getResponseByTicketId();?>
<h1><img src="images/support.png" alt="" /><?php echo lang('FSUP_TITLE');?></h1>
<p class="info"><?php echo lang('FSUP_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<?php if(!$row):?>
<?php echo Filter::msgInfo(lang('SUP_NOTICKET'),false);?>
<?php else:?>
<div class="box">
  <form action="" method="post" id="admin_form" name="admin_form">
    <table cellpadding="0" cellspacing="0" class="forms">
      <thead>
        <tr>
          <th colspan="2" class="left"><?php echo lang('FSUP_SUB') . $row->id;?></th>
        </tr>
      </thead>
      <tr>
        <th width="200"><?php echo lang('SUP_PRIORITY');?>: </th>
        <td><?php echo $row->priority;?></td>
      </tr>
      <tr>
        <th><?php echo lang('SUP_STATUS');?>:</th>
        <td><span id="ticket-status-closed"><?php echo ($row->status == "Closed") ? $row->status : lang('FSUP_OPENCLOSE');?></span></td>
      </tr>
      <tr>
        <th><?php echo lang('SUP_ASSIGNED');?>:</th>
        <td><?php echo $row->staffname;?></td>
      </tr>
      <tr>
        <th><?php echo lang('SUP_SUBJECT');?>:</th>
        <td><?php echo $row->subject;?></td>
      </tr>
      <tr>
        <th><?php echo lang('SUP_DETAIL');?>:</th>
        <td colspan="2"><?php echo cleanOut($row->body);?></td>
      </tr>
      <tr>
        <td colspan="2" style="padding:13px 5px"><a href="account.php?do=support" class="button-alt"><?php echo lang('CANCEL');?></a></td>
      </tr>
    </table>
    <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
  </form>
</div>
<div class="box" style="margin-top:10px">
  <form action="" method="post" id="reply_form" name="reply_form">
    <table cellpadding="0" cellspacing="0" class="forms">
      <thead>
        <tr>
          <th class="left"><?php echo lang('FSUP_SUB1') . $row->subject;?></th>
        </tr>
      </thead>
      <tr>
        <td><textarea name="body" cols="50" rows="6" id="bodycontent" style="width:98%"></textarea></td>
      </tr>
      <tr>
        <td><input name="doreply" id="send-reply" type="submit" value="<?php echo lang('FSUP_BTNSEND');?>"  class="button"/></td>
      </tr>
    </table>
    <input name="replySupportTicket" type="hidden" value="<?php echo Filter::$id;?>" />
  </form>
  <?php if($resrow):?>
  <div id="replydata" style="margin-top:10px">
    <ul id="reply-list">
      <?php foreach($resrow as $trow):?>
      <li class="<?php echo ($trow->user_type == "client") ? 'row-client' : 'row-staff';?>"><strong><?php echo lang('CREATED');?></strong>: <?php echo $trow->cdate;?> - <strong><?php echo lang('AUTHOR');?></strong>: <?php echo $trow->name;?> [<?php echo ($trow->user_type == "client") ? lang('YOU') : $trow->user_type;?>]
        <div><?php echo cleanOut($trow->body);?></div>
      </li>
      <?php endforeach;?>
    </ul>
  </div>
  <?php endif;?>
</div>
<script type="text/javascript">
// <![CDATA[
function loadEntryList() {
	$.ajax({
		type: 'post',
		url: "ajax/controller.php",
		data: 'loadReplyEntries=' + <?php echo Filter::$id;?>,
		cache: false,
		success: function (html) {
			$("#replydata").html(html);
		}
	});
	$('#loader').fadeOut(200);
}
  $(document).ready(function() {
	  $('#close-ticket').click(function () {
		  var str = 'closeTicket=' + <?php echo Filter::$id;?>;
		  $.ajax({
			  type: 'post',
			  url: "ajax/controller.php",
			  data: str,
			  success: function () {
				  $("#ticket-status-closed").html(' + <?php echo lang('CLOSED');?> + ');
			  }
		  });
		  return false;
		  
      });
		  
	  $('#send-reply').click(function () {
		  var str = $("#reply_form").serialize();
		  $('#loader').fadeIn(200);
		  $.ajax({
			  type: 'post',
			  url: "ajax/controller.php",
			  data: str,
			  success: function (res) {
				  $("#msgholder").html(res);
				  $("html, body").animate({
					  scrollTop: 0
				  }, 600);
				  setTimeout(function () {
					  $(loadEntryList()).fadeIn("slow");
				  }, 2000);
			  }
		  });
		  return false;
	  });
  });
// ]]>
</script>
<?php endif;?>
<?php break;?>
<?php case "add": ?>
<h1><img src="images/support.png" alt="" /><?php echo lang('FSUP_TITLE1');?></h1>
<p class="info"><?php echo lang('FSUP_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="box">
  <form action="" method="post" id="admin_form" name="admin_form">
    <table cellpadding="0" cellspacing="0" class="forms">
      <thead>
        <tr>
          <th class="left" colspan="2"><?php echo lang('FSUP_SUB2');?></th>
        </tr>
      </thead>
      <tr>
        <th width="200"><?php echo lang('SUP_PRIORITY');?>: </th>
        <td><select name="priority" class="custombox" style="width:150px">
            <?php echo $content->ticketPriorityList();?>
          </select></td>
      </tr>
      <tr>
        <th><?php echo lang('SUP_SUBJECT');?>: <?php echo required();?></th>
        <td><input name="subject" type="text" class="inputbox" size="70"/></td>
      </tr>
      <tr>
        <td colspan="2"><textarea name="body" cols="50" rows="6" id="bodycontent" style="width:98%"></textarea></td>
      </tr>
      <tr>
        <td><input name="doreply" type="submit" value="<?php echo lang('FSUP_SENDBTN');?>"  class="button"/></td>
        <td><a href="account.php?do=support" class="button-alt"><?php echo lang('CANCEL');?></a></td>
      </tr>
    </table>
  </form>
</div>
<?php echo Core::doForm("processSupportTicket","ajax/controller.php");?>
<?php break;?>
<?php default: ?>
<?php $ticketrow = $user->getSupportTickets();?>
<h1><span><a href="account.php?do=support&amp;action=add" class="button-alt-sml"><?php echo lang('FSUP_SUB3');?></a></span><img src="images/support.png" alt="" /><?php echo lang('FSUP_TITLE2');?></h1>
<p class="info"><?php echo lang('FSUP_INFO2');?></p>
<div class="box">
  <table cellpadding="0" cellspacing="0" class="display">
    <thead>
      <tr>
        <th width="20">#</th>
        <th class="left"><?php echo lang('SUP_SUBJECT');?></th>
        <th class="left"><?php echo lang('SUP_ASSIGNED');?></th>
        <th class="left"><?php echo lang('CREATED');?></th>
        <th class="left"><?php echo lang('SUP_PRIORITY1');?></th>
        <th><?php echo lang('VIEW');?></th>
      </tr>
    </thead>
    <tbody>
      <?php if(!$ticketrow):?>
      <tr>
        <td colspan="6"><?php echo Filter::msgInfo(lang('SUP_NOTICKET'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($ticketrow as $row):?>
      <tr>
        <th align="center" class="<?php echo ($row->status == "Open") ? 'open' : 'closed';?>"></th>
        <td><?php echo $row->subject;?></td>
        <td><?php echo (!$row->staffname) ? lang('SUP_NOASSIGNED') : $row->staffname;?></td>
        <td><?php echo Filter::doDate($core->long_date, $row->created);?></td>
        <td><span class="<?php echo strtolower($row->priority);?>"><?php echo $row->priority;?></span></td>
        <td align="center"><a href="account.php?do=support&amp;action=view&amp;id=<?php echo $row->id;?>"><img src="images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('VIEW').': '.$row->subject;?>"/></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </tbody>
  </table>
</div>
<?php break;?>
<?php endswitch;?>