<?php
  error_reporting(E_ALL);
  define("_VALID_PHP", true);

  $BASEPATH = str_replace("upgrade.php", "", realpath(__file__));
  define("BASEPATH", $BASEPATH);

  $configFile = BASEPATH . "lib/config.ini.php";
  if (file_exists($configFile)) {
      require_once ($configFile);
  } else {
      exit("Configuration file is missing. Upgrade can not continue");
  }

  require_once (BASEPATH . "lib/class_db.php");
  $db = new Database(DB_SERVER, DB_USER, DB_PASS, DB_DATABASE);
  $db->connect();
  $version = $db->first("SELECT crmv FROM settings");


  /**
   * redirect_to()
   * 
   * @param mixed $location
   * @return
   */
  function redirect_to($location)
  {
      if (!headers_sent()) {
          header('Location: ' . $location);
          exit;
      } else {
          echo '<script type="text/javascript">';
          echo 'window.location.href="' . $location . '";';
          echo '</script>';
          echo '<noscript>';
          echo '<meta http-equiv="refresh" content="0;url=' . $location . '" />';
          echo '</noscript>';
      }
  }

  if (isset($_POST['submit'])) {

	  $db->query("ALTER TABLE settings ADD COLUMN tax_number varchar(100) NULL AFTER tax_rate");
	  $db->query("ALTER TABLE users ADD COLUMN country varchar(100) NULL AFTER zip");

      $setdata['crmv'] = '1.06';
      $db->update("settings", $setdata);

      redirect_to("upgrade.php?update=done");
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Freelance Manager - System Upgrade</title>
<script type="text/javascript" src="assets/jquery.js"></script>
<link href="http://fonts.googleapis.com/css?family=Maven+Pro" rel="stylesheet" type="text/css" />
<style type="text/css">
body { font-family: Maven Pro,"Trebuchet MS", Arial, Helvetica, sans-serif; font-size: 13px; margin: 0px; padding: 0px; }
#wrap { width: 800px; margin-top: 120px; margin-right: auto; margin-left: auto; background-color: #f2f5f6; padding: 20px; border: 4px solid #A6BEC6; -moz-border-radius:7px; -khtml-border-radius:7px; -webkit-border-radius:7px; border-radius:7px; background: #f2f5f6; background: -moz-linear-gradient(top, #f2f5f6 0%, #e3eaed 37%, #c8d7dc 100%); background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#f2f5f6), color-stop(37%,#e3eaed), color-stop(100%,#c8d7dc)); background: -webkit-linear-gradient(top, #f2f5f6 0%,#e3eaed 37%,#c8d7dc 100%); background: -o-linear-gradient(top, #f2f5f6 0%,#e3eaed 37%,#c8d7dc 100%); background: -ms-linear-gradient(top, #f2f5f6 0%,#e3eaed 37%,#c8d7dc 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#f2f5f6', endColorstr='#c8d7dc',GradientType=0 );
background: linear-gradient(top, #f2f5f6 0%,#e3eaed 37%,#c8d7dc 100%); 
box-shadow: 0px 1px 1px 1px rgba(0, 0, 0, 0.1);text-shadow:1px 1px 0 #ddd;}
p.info { background-color: #E5ECEE; color: #F00; padding: 5px; border: 1px solid #A6BEC6; font-weight: 600; -moz-border-radius:5px; -khtml-border-radius:5px; -webkit-border-radius:5px; border-radius:5px; }
h1 { font-size: 28px; font-weight: normal; margin: 0px; padding: 0px; color: #88A8B3; text-shadow:1px 1px 0 #fff; letter-spacing: -1px; }
p.msgOk{ padding: 5px; background-color: #C8D7DC; border: 2px solid #F2F5F6; font-size: 16px; font-weight: lighter; -moz-border-radius:5px; -khtml-border-radius:5px; -webkit-border-radius:5px; border-radius:5px;text-shadow:1px 1px 0 #eee;  }
p.msgOk span { color: #F00; }
.button, a.button {
margin: 0 2px; padding: 5px 16px;outline: none; cursor: pointer; vertical-align: baseline; text-shadow: 0 1px 0 rgba(255,255,255,.4); font-size: 13px; line-height: 17px; font-weight: bold; text-align: center; text-decoration: none; border: solid 1px #b8b8b8; border-color: #c4c4c4 #b8b8b8 #adadad;background: #d4d4d4;
background: -webkit-gradient(linear, left top, left bottom, from(#dedede), to(#c7c7c7));
background: -moz-linear-gradient(top, #dedede,  #c7c7c7);
background: linear-gradient(#dedede, #c7c7c7);
-webkit-border-radius: 2px; -moz-border-radius: 2px; border-radius: 2px; 
-webkit-box-shadow: 0 1px 2px rgba(0,0,0,.08), inset 0 1px 0 rgba(255,255,255,.3);
-moz-box-shadow: 0 1px 2px rgba(0,0,0,.08), inset 0 1px 0 rgba(255,255,255,.3); 
box-shadow: 0 1px 2px rgba(0,0,0,.08), inset 0 1px 0 rgba(255,255,255,.3);
-webkit-background-clip: padding-box;}
.button:hover{text-decoration: none;border-color:#bababa #b0b0b0 #a6a6a6;background:#e0e0e0;
background:-webkit-gradient(linear, left top, left bottom, from(#ededed), to(#cfcfcf));
background:-moz-linear-gradient(top, #ededed,  #cfcfcf);
background:linear-gradient(#ededed, #cfcfcf);
-webkit-box-shadow:0 1px 2px rgba(0,0,0,.15), inset 0 1px 0 rgba(255,255,255,.2); 
-moz-box-shadow:0 1px 2px rgba(0,0,0,.15), inset 0 1px 0 rgba(255,255,255,.2); 
box-shadow:0 1px 2px rgba(0,0,0,.15), inset 0 1px 0 rgba(255,255,255,.2);}
.version{float:right;display:inline-block}
</style>
</head>
<body>
<div id ="wrap">
  <?php if(isset($_GET['update']) && $_GET['update'] == "done"):?>
  <h1>Welcome to Freelance Manager Upgrade &rsaquo; v.1.06</h1>
  <p class="msgOk">Installation Completed. Please delete <span>upgrade.php</span></p>
  <?php else:?>
  <h1>Welcome to Freelance Manager Upgrade &rsaquo; v.1.06</h1>
  <p class="info">Warning: Please make sure you have performed database backup!!!</p>
  <p>When ready click Install button.</p>
  <p><span>Please be patient, and<strong> DO NOT</strong> Refresh your browser. This process might take a while</span>.</p>
  <div>
    <form action="" method="post" name="upgrade_form">
      <input name="submit" type="submit" class="button" value="Upgrade System" id="submit" />
    </form>
    <span class="version">Current Version: <?php echo $version->crmv;?></span>
  </div>
  <?php endif;?>
</div>
</body>
</html>