<?php
  /**
   * Invoice Status
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: invstatus.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php $invrow = $content->getInvoicesByStatus();?>
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('INVC_TITLE4');?></h1>
<p class="info"><?php echo lang('INVC_INFO4');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <tr>
        <td class="subtitle"><select name="sort" class="custombox" id="invfilter" style="width:200px">
            <option value="NA">--- <?php echo lang('INVC_RESET');?> ---</option>
            <?php echo $content->invoiceStatusList(get('sort'));?>
          </select></td>
        <td align="center" class="subtitle"><form action="" method="post" id="dForm">
            <strong><?php echo lang('INVC_DUEFROM');?></strong>
            <input name="fromdate" type="text" style="margin-right:3px" class="inputbox-sml" size="10" id="fromdate" />
            <strong><?php echo lang('INVC_DUETO');?></strong>
            <input name="enddate" type="text" class="inputbox-sml" size="10" id="enddate" />
            <input name="find" type="submit" class="button-alt button-blue" value="<?php echo lang('FIND');?>" />
          </form></td>
        <td align="right" class="subtitle"><?php echo $pager->items_per_page();?> &nbsp;&nbsp; <?php echo $pager->jump_menu();?></td>
      </tr>
    </table>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><?php echo lang('INVC_SUB4');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('INVC_NAME');?></th>
          <th class="left"><?php echo lang('INVC_CNAME');?></th>
          <th class="left"><?php echo lang('INVC_DUEDATE');?></th>
          <th class="left"><?php echo lang('TOTAL');?></th>
          <th class="left"><?php echo lang('BALANCE');?></th>
          <th class="left"><?php echo lang('STATUS');?></th>
          <th><?php echo lang('VIEW');?></th>
        </tr>
      </thead>
      <tbody>
        <?php if(!$invrow):?>
        <tr>
          <td colspan="8"><?php echo Filter::msgInfo(lang('INVC_NOINVOICE2'),false);?></td>
        </tr>
        <?php else:?>
        <?php foreach ($invrow as $row):?>
        <tr>
          <th><?php echo $row->id;?>.</th>
          <td><?php echo $row->title;?></td>
          <td><?php echo $row->name;?></td>
          <td><?php echo $row->ddate;?></td>
          <td><?php echo $row->amount_total;?></td>
          <td><?php echo $row->amount_paid;?></td>
          <td><?php echo $row->status;?></td>
          <td align="center"><a href="index.php?do=invoices&amp;action=edit&amp;pid=<?php echo $row->project_id;?>&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        </tr>
        <?php endforeach;?>
        <?php unset($row);?>
        <?php endif;?>
      </tbody>
    </table>
  </div>
</div>
<script type="text/javascript"> 
// <![CDATA[  
$(document).ready(function () {
    $('#invfilter').change(function () {
		var res = $("#invfilter option:selected").val();
		(res == "NA" ) ? window.location.href = 'index.php?do=invstatus' : window.location.href = 'index.php?do=invstatus&sort=' + res;
    })
});
$(function () {
    var dates = $('#fromdate, #enddate').datepicker({
        defaultDate: "+1w",
        changeMonth: false,
        numberOfMonths: 2,
        dateFormat: 'yy-mm-dd',
        onSelect: function (selectedDate) {
            var option = this.id == "fromdate" ? "minDate" : "maxDate";
            var instance = $(this).data("datepicker");
            var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
            dates.not(this).datepicker("option", option, date);
        }
    });
});
// ]]>
</script>