<?php
  /**
   * Projects
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: projects.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("projects", Filter::$id);?>
<?php if(!$user->checkProjectAccess($row->id)): print Filter::msgInfo(lang('NOACCESS'), false); return; endif;?>
<?php $ptype = $content->getProjectTypes();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('PROJ_TITLE');?></h1>
<p class="info"><?php echo lang('PROJ_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-header">
    <ul class="idTabs" id="tabs">
      <li><a href="#general"><?php echo lang('PROJECT');?></a></li>
      <li><a href="#tasks"><?php echo lang('TASKS');?></a></li>
      <li><a href="#submissions"><?php echo lang('SUBMISSIONS');?></a></li>
      <li><a href="#files"><?php echo lang('FILES');?></a></li>
    </ul>
    <div class="clear"></div>
    <h2><?php echo lang('PROJ_SUB') . $row->title;?></h2>
  </div>
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td colspan="2"><div id="general" class="tab_content">
              <table cellspacing="0" cellpadding="0" class="forms">
                <tr>
                  <th width="200"><?php echo lang('PROJ_NAME');?>: <?php echo required();?></th>
                  <td><input name="title" type="text" class="inputbox " value="<?php echo $row->title;?>" size="55" /></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_TYPE');?>: <?php echo required();?></th>
                  <td><select name="project_type" class="custombox" style="width:250px">
                      <option value=""><?php echo lang('PROJ_TYPE_SEL');?></option>
                      <?php if ($ptype):?>
                      <?php foreach ($ptype as $prow):?>
                      <option value="<?php echo $prow->id;?>"<?php if($prow->id == $row->project_type)echo 'selected="selected"';?>><?php echo $prow->title;?></option>
                      <?php endforeach;?>
                      <?php unset($prow);?>
                      <?php endif;?>
                    </select></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_PRICE');?>: <?php echo required();?></th>
                  <td><input name="cost" type="text" class="inputbox " size="10" value="<?php echo $row->cost;?>" /></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_START');?>:</th>
                  <td colspan="2"><input name="start_date" type="text" class="inputbox" id="start_date" size="25" value="<?php echo $row->start_date;?>"/></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_END');?>:</th>
                  <td><input name="end_date" type="text" class="inputbox" id="end_date" size="25" value="<?php echo $row->end_date;?>"/></td>
                </tr>
                <tr>
                  <td colspan="2"><textarea name="body" cols="20" rows="1" id="bodycontent"><?php echo $row->body;?></textarea></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_BILLSTSTUS');?>:</th>
                  <td><?php echo $content->progressBarBilling($row->b_status, $row->cost);?>
                  <?php /*?>
                  <label for="b_status">Payment Amount:</label>
                    <input type="text" id="b_status" style="border:0; color:#5AB814;font-weight:bold; background-color:transparent" name="b_status"/>
                    <div id="b_status-range" style="width: 250px;margin-top:2px"></div>
					<?php */?>
					</td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_STATUS');?>:</th>
                  <td><label for="p_status"><?php echo lang('PROJ_COMPSTSTUS');?>:</label>
                    <input type="text" id="p_status" style="border:0; color:#0084FF;background-color:transparent" name="p_status"/>
                    <div id="p_status-range" style="width: 250px;margin-top:2px"></div></td>
                </tr>
                <tr>
                  <th><?php echo lang('PROJ_MANAGER');?>:</th>
                  <td><select name="staff_id" class="custombox" style="width:250px">
                      <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
                      <option value="<?php echo $srow->id;?>"<?php if($srow->id == $row->staff_id) echo 'selected="selected"';?>><?php echo $srow->name;?></option>
                      <?php endforeach;?>
                      <?php unset($srow);?>
                    </select></td>
                </tr>
              </table>
            </div>
            <div id="tasks" class="tab_content">
              <?php $taskrow = $content->getTasksByProject();?>
              <table cellpadding="0" cellspacing="0" class="display">
                <thead>
                  <tr>
                    <th width="20">#</th>
                    <th class="left"><?php echo lang('TASK_NAME');?></th>
                    <th class="left"><?php echo lang('TASK_PROGRESS');?></th>
                    <th class="left"><?php echo lang('CREATED');?></th>
                    <th><?php echo lang('EDIT');?></th>
                  </tr>
                </thead>
                <?php if(!$taskrow):?>
                <tr>
                  <td colspan="5"><?php echo Filter::msgAlert(lang('TASK_NOTASKS'),false);?></td>
                </tr>
                <?php else:?>
                <?php foreach ($taskrow as $trow):?>
                <tr>
                  <th align="center"><?php echo $trow->id;?>.</th>
                  <td><?php echo $trow->title;?></td>
                  <td><?php echo $content->progressBarStatus($trow->progress);?></td>
                  <td><?php echo Filter::dodate($core->short_date, $trow->created);?></td>
                  <td align="center"><a href="index.php?do=tasks&amp;action=edit&amp;id=<?php echo $trow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$trow->title;?>"/></a></td>
                </tr>
                <?php endforeach;?>
                <?php unset($trow);?>
                <?php endif;?>
              </table>
            </div>
            <div id="submissions" class="tab_content">
              <?php $subrow = $content->getProjectSubmissions();?>
              <table cellpadding="0" cellspacing="0" class="display">
                <thead>
                  <tr>
                    <th width="20">#</th>
                    <th class="left"><?php echo lang('SUBS_NAME');?></th>
                    <th class="left"><?php echo lang('SUBS_TYPE');?></th>
                    <th class="left"><?php echo lang('STATUS');?></th>
                    <th><?php echo lang('EDIT');?></th>
                  </tr>
                </thead>
                <?php if(!$subrow):?>
                <tr>
                  <td colspan="5"><?php echo Filter::msgAlert(lang('SUBS_NOSUBS'),false);?></td>
                </tr>
                <?php else:?>
                <?php foreach ($subrow as $brow):?>
                <tr>
                  <th align="center"><?php echo $brow->id;?>.</th>
                  <td><?php echo $brow->title;?></td>
                  <td><?php echo $brow->s_type;?></td>
                  <td><?php echo $content->projectSubmissionStatus($brow->status);?></td>
                  <td align="center"><a href="index.php?do=submissions&amp;action=edit&amp;id=<?php echo $brow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '. $brow->title;?>"/></a></td>
                </tr>
                <?php endforeach;?>
                <?php unset($brow);?>
                <?php endif;?>
              </table>
            </div>
            <div id="files" class="tab_content">
              <?php $filerow = $content->getFilesByProject();?>
              <table cellpadding="0" cellspacing="0" class="display">
                <thead>
                  <tr>
                    <th width="20">#</th>
                    <th class="left"><?php echo lang('FILE_NAME');?></th>
                    <th class="left"><?php echo lang('FILESIZE');?></th>
                    <th class="left"><?php echo lang('DOWNLOAD');?></th>
                    <th><?php echo lang('EDIT');?></th>
                  </tr>
                </thead>
                <?php if(!$filerow):?>
                <tr>
                  <td colspan="5"><?php echo Filter::msgAlert(lang('FILE_NOFILES'),false);?></td>
                </tr>
                <?php else:?>
                <?php foreach ($filerow as $frow):?>
                <tr>
                  <th align="center"><?php echo $frow->id;?>.</th>
                  <td><?php echo $frow->title;?></td>
                  <td><?php echo getSize($frow->filesize);?></td>
                  <td><a href="<?php echo UPLOADURL . 'data/' . $frow->filename;?>"><img src="../images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD');?>"/></a></td>
                  <td align="center"><a href="index.php?do=files&amp;action=edit&amp;id=<?php echo $frow->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$frow->title;?>"/></a></td>
                </tr>
                <?php endforeach;?>
                <?php unset($frow);?>
                <?php endif;?>
              </table>
          </div></td>
        </tr>
        <tr>
          <td width="200" style="padding:5px"><input type="submit" name="dosubmit"  value="<?php echo lang('PROJ_UPDATE');?>" class="button button-green"/></td>
          <td style="padding:5px"><a href="index.php?do=projects" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="client_id" type="hidden" value="<?php echo $row->client_id;?>" />
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processProject");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:250});
	
	$(".tab_content").hide();
	$("#tabs li:first").addClass("selected").show(); 
	$(".tab_content:first").show();
	$("#tabs li").click(function () {
	    $("#tabs li").removeClass("selected");
	    $(this).addClass("selected");
	    $(".tab_content").hide();
	    var activeTab = $(this).find("a").attr("href");
	    $(activeTab).show();
	    return false;
	});
  });
$(function() {
	$( "#p_status-range" ).slider({
		value:<?php echo $row->p_status;?>,
		min: 0,
		max: 100,
		step: 5,
		slide: function(event, ui) {
			$("#p_status").val( ui.value + "%");
		}
	});
	$("#p_status").val( $("#p_status-range").slider("value") + "%");
});
<?php /*?>
$(function() {
	$( "#b_status-range" ).slider({
		value:<?php echo $row->b_status;?>,
		min: 0,
		max: <?php echo $row->cost;?>,
		slide: function(event, ui) {
			$("#b_status").val("<?php echo $core->cur_symbol;?>" + ui.value);
		}
	});
	$("#b_status").val("<?php echo $core->cur_symbol;?>" + $("#b_status-range").slider("value"));
});
<?php */?>
$(function () {
    $("#start_date, #end_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php case"add":?>
<?php if($user->userlevel == 5): print Filter::msgInfo(lang('PROJ_NOPERM'), false); return; endif;?>
<?php $ptype = $content->getProjectTypes();?>
<?php $userlist = $user->getUserList(1);?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('PROJ_TITLE1');?></h1>
<p class="info"><?php echo lang('PROJ_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('PROJ_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('PROJ_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('INVC_CNAME');?>: <?php echo required();?></th>
          <td><select name="client_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('INVC_CLIENTSELECT');?> ---</option>
              <?php if($userlist):?>
              <?php foreach ($userlist as $crow):?>
              <option value="<?php echo $crow->id;?>"><?php echo $crow->name;?></option>
              <?php endforeach;?>
              <?php unset($crow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_TYPE');?>: <?php echo required();?></th>
          <td><select name="project_type" class="custombox" style="width:250px">
              <option value="">--- Select Project Type ---</option>
              <?php if ($ptype):?>
              <?php foreach ($ptype as $prow):?>
              <option value="<?php echo $prow->id;?>"><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_PRICE');?>: <?php echo required();?></th>
          <td><input name="cost" type="text" class="inputbox" size="10" id="cost" /></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_START');?>:</th>
          <td><input name="start_date" type="text" class="inputbox" id="start_date" size="25" value="<?php echo date('Y-m-d');?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_END');?>:</th>
          <td><input name="end_date" type="text" class="inputbox" id="end_date" size="25" value="<?php echo date('Y-m-d');?>"/></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="body" cols="20" rows="1" id="bodycontent"></textarea></td>
        </tr>
        <?php /*?>
        <tr>
          <th>Billing Status:</th>
          <td><label for="b_status">Payment Amount:</label>
            <input type="text" id="b_status" style="border:0; color:#5AB814;font-weight:bold; background-color:transparent" name="b_status"/>
            <div id="b_status-range" style="width: 250px;margin-top:2px;margin-left:5px"></div></td>
        </tr>
		<?php */?>
        <tr>
          <th><?php echo lang('PROJ_STATUS');?>:</th>
          <td><label for="p_status"><?php echo lang('PROJ_COMPSTSTUS');?>:</label>
            <input type="text" id="p_status" style="border:0; color:#0084FF;background-color:transparent" name="p_status"/>
            <div id="p_status-range" style="width:250px;margin-top:2px;margin-left:5px"></div></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_MANAGER');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('PROJ_NOTIFY');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="notify_staff" value="1" />
            <?php echo lang('NO');?>
            <input name="notify_staff" type="radio" value="0" checked="checked" /></td>
        </tr>
        <tr>
          <td><input name="submit" type="submit" value="<?php echo lang('PROJ_ADD');?>" class="button button-green"/></td>
          <td><a href="index.php?do=projects" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processProject");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:250});
  });
<?php /*?>
$(function() {
	$( "#b_status-range" ).slider({
		value:0,
		min: 0,
		max: 0,
		slide: function(event, ui) {
			$("#b_status").val("<?php echo $core->cur_symbol;?>" + ui.value);
		}
	});
	 $('#cost').change(function() {
	  $('#b_status-range').slider('option','max',parseInt($(this).val()));
	});
	$("#b_status").val("<?php echo $core->cur_symbol;?>" + $("#b_status-range").slider("value"));
});
<?php */?>
$(function() {
	$( "#p_status-range" ).slider({
		value:0,
		min: 0,
		max: 100,
		step: 5,
		slide: function(event, ui) {
			$("#p_status").val( ui.value + "%");
		}
	});
	$("#p_status").val( $("#p_status-range").slider("value") + "%");
});

$(function () {
    $("#start_date, #end_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php case"details":?>
<?php $row = Core::getRowById("projects", Filter::$id);?>
<?php $urow = Core::getRowById("users", $row->staff_id);?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('PROJ_TITLE2');?></h1>
<p class="info"><?php echo lang('PROJ_INFO2');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="forms">
      <thead>
        <tr>
          <th colspan="2" class="left"><?php echo lang('PROJ_SUB2') . $row->title;?></th>
        </tr>
      </thead>
      <tr>
        <th width="200"><?php echo lang('PROJ_NAME');?>:</th>
        <td><?php echo $row->title;?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_TYPE');?>:</th>
        <td><?php echo getValue("title","project_types","id = '".$row->project_type."'");?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_PRICE');?>:</th>
        <td><?php echo $core->formatMoney($row->cost);?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_START');?>:</th>
        <td><?php echo Filter::dodate($core->short_date, $row->start_date);?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_END');?>:</th>
        <td><?php echo Filter::dodate($core->short_date, $row->end_date);?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_DESC');?>:</th>
        <td><?php echo cleanOut($row->body);?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_STATUS');?>:</th>
        <td><div style="width:350px"><?php echo $content->progressBarStatus($row->p_status);?></div></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_BILLSTSTUS');?>:</th>
        <td><div style="width:350px"><?php echo $content->progressBarBilling($row->b_status, $row->cost);?></div></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_MANAGER');?>:</th>
        <td><?php echo $urow->fname.' '.$urow->lname;?></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_TASKS');?>:</th>
        <td><?php $taskrow = $content->getTasksByProject();?>
          <table cellpadding="0" cellspacing="0" class="display">
            <thead>
              <tr>
                <th width="20">#</th>
                <th width="350" class="left"><?php echo lang('TASK_NAME');?></th>
                <th class="left"><?php echo lang('TASK_PROGRESS');?></th>
              </tr>
            </thead>
            <?php if(!$taskrow):?>
            <tr>
              <td colspan="3"><?php echo Filter::msgInfo(lang('TASK_NOTASKS'),false);?></td>
            </tr>
            <?php else:?>
            <?php foreach ($taskrow as $trow):?>
            <tr>
              <td align="center"><?php echo $trow->id;?>.</td>
              <td><a href="index.php?do=tasks&amp;action=edit&amp;id=<?php echo $trow->id;?>"><?php echo $trow->title;?></a></td>
              <td><?php echo $content->progressBarStatus($trow->progress);?></td>
            </tr>
            <?php endforeach;?>
            <?php unset($trow);?>
            <?php endif;?>
          </table></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_SUBS');?>:</th>
        <td><?php $subrow = $content->getProjectSubmissions();?>
          <table cellpadding="0" cellspacing="0" class="display">
            <thead>
              <tr>
                <th width="20">#</th>
                <th width="350" class="left"><?php echo lang('SUBS_NAME');?></th>
                <th class="left"><?php echo lang('SUBS_TYPE');?></th>
              </tr>
            </thead>
            <?php if(!$subrow):?>
            <tr>
              <td colspan="3"><?php echo Filter::msgInfo(lang('SUBS_NOSUBS'),false);?></td>
            </tr>
            <?php else:?>
            <?php foreach ($subrow as $brow):?>
            <tr>
              <td align="center"><?php echo $brow->id;?>.</td>
              <td><a href="index.php?do=submissions&amp;action=edit&amp;id=<?php echo $brow->id;?>"><?php echo $brow->title;?></a></td>
              <td><?php echo $brow->s_type;?></td>
            </tr>
            <?php endforeach;?>
            <?php unset($brow);?>
            <?php endif;?>
          </table></td>
      </tr>
      <tr>
        <th><?php echo lang('PROJ_FILES');?>:</th>
        <td><?php $filerow = $content->getFilesByProject();?>
          <table cellpadding="0" cellspacing="0" class="display">
            <thead>
              <tr>
                <th width="20">#</th>
                <th width="350" class="left"><?php echo lang('FILE_NAME');?></th>
                <th class="left"><?php echo lang('FILESIZE');?></th>
                <th class="left"><?php echo lang('DOWNLOAD');?></th>
              </tr>
            </thead>
            <?php if(!$filerow):?>
            <tr>
              <td colspan="4"><?php echo Filter::msgInfo(lang('FILE_NOFILES'),false);?></td>
            </tr>
            <?php else:?>
            <?php foreach ($filerow as $frow):?>
            <tr>
              <td align="center"><?php echo $frow->id;?>.</td>
              <td><a href="index.php?do=files&amp;action=edit&amp;id=<?php echo $frow->id;?>"><?php echo $frow->title;?></a></td>
              <td><?php echo getSize($frow->filesize);?></td>
              <td><a href="<?php echo UPLOADURL . 'data/' . $frow->filename;?>"><img src="../images/save.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DOWNLOAD');?>"/></a></td>
            </tr>
            <?php endforeach;?>
            <?php unset($frow);?>
            <?php endif;?>
          </table></td>
      </tr>
      <tr>
        <td><a href="index.php?do=projects" class="button-alt button-blue"><?php echo lang('PROJ_BACK');?></a></td>
        <td>&nbsp;</td>
      </tr>
    </table>
  </div>
</div>
<?php break;?>
<?php default: ?>
<?php $projectrow = $content->getProjects();?>
<?php $userlist = $user->getUserList(1);?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('PROJ_TITLE3');?></h1>
<p class="info"><?php echo lang('PROJ_INFO3');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <tr>
        <td class="subtitle"><select name="select" class="custombox" id="clientfilter" style="width:200px">
            <option value="NA">--- <?php echo lang('INVC_CLIENTSELECT');?> ---</option>
            <?php if($userlist):?>
            <?php foreach ($userlist as $crow):?>
            <option value="<?php echo $crow->id;?>"<?php if($crow->id == get('sort')) echo 'selected="selected"';?>><?php echo $crow->name;?></option>
            <?php endforeach;?>
            <?php unset($crow);?>
            <?php endif;?>
          </select></td>
        <td align="right" class="subtitle"><?php echo $pager->items_per_page();?> &nbsp;&nbsp; <?php echo $pager->jump_menu();?></td>
      </tr>
    </table>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><?php if($user->userlevel == 9):?><span><a href="index.php?do=projects&amp;action=add" class="add"><?php echo lang('PROJ_ADD');?></a></span><?php endif;?><?php echo lang('PROJ_SUB3');?></h2>
  </div>
  <div class="block-content">
    <table cellspacing="0" cellpadding="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('PROJ_NAME');?></th>
          <th class="left"><?php echo lang('INVC_CNAME');?></th>
          <th class="left"><?php echo lang('PROJ_MANAGER');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th class="left"><?php echo lang('STATUS');?></th>
          <th class="left"><?php echo lang('BILLING');?></th>
          <th class="right"><?php echo lang('ACTIONS');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="8"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <?php if($projectrow == 0):?>
      <tr>
        <td colspan="8"><?php echo Filter::msgInfo(lang('PROJ_NOPROJECT'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($projectrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->pid;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><?php echo $row->clientname;?></td>
        <td><?php echo $row->staffname;?></td>
        <td><?php echo Filter::dodate($core->short_date, $row->start_date);?></td>
        <td><?php echo $content->progressBarStatus($row->p_status);?></td>
        <td><?php echo $content->progressBarBilling($row->b_status, $row->cost);?></td>
        <td class="right"><a href="index.php?do=projects&amp;action=details&amp;id=<?php echo $row->pid;?>"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('PROJ_DETAILS');?>"/></a> <a href="index.php?do=overview&amp;id=<?php echo $row->uid;?>"><img src="../images/client-overview.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('PROJ_CLOVERVIEW');?>"/></a>
          <?php if ($row->b_status == $row->cost):?>
          <a href="index.php?do=invoices&amp;id=<?php echo $row->pid;?>"><img src="../images/project-paid.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('PROJ_PAID');?>"/></a>
          <?php else:?>
          <a href="index.php?do=invoices&amp;action=add&amp;id=<?php echo $row->pid;?>"><img src="../images/payment-pending.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('PROJ_INVOICE');?>"/></a>
          <?php endif;?>
          <a href="index.php?do=submissions&amp;id=<?php echo $row->pid;?>"><img src="../images/project-submission.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('PROJ_SUBS');?>"/></a>
          <a href="index.php?do=timebilling&amp;action=add&amp;id=<?php echo $row->pid;?>"><img src="../images/time.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('BILL_ADD_B');?>"/></a> <a href="index.php?do=projects&amp;action=edit&amp;id=<?php echo $row->pid;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>" /></a> <a href="javascript:void(0);" class="delete" id="item_<?php echo $row->pid;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('PROJ_DELETE'),"deleteProject");?> 
<script type="text/javascript"> 
// <![CDATA[  
$(document).ready(function () {
    $('#clientfilter').change(function () {
		var res = $("#clientfilter option:selected").val();
		(res == "NA" ) ? window.location.href = 'index.php?do=projects' : window.location.href = 'index.php?do=projects&sort=' + res;
    })
});
// ]]>
</script>
<?php break;?>
<?php endswitch;?>