<?php
  /**
   * Project Tasks
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: tasks.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php switch(Filter::$action): case "edit": ?>
<?php $row = Core::getRowById("tasks", Filter::$id);?>
<?php if(!$user->checkProjectAccess($row->project_id)): print Filter::msgInfo(lang('NOACCESS'), false); return; endif;?>
<?php $plist = $content->getProjectList();?>
<?php $stafflist = $user->getUserList("9' or userlevel = '5");?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TASK_TITLE');?></h1>
<p class="info"><?php echo lang('TASK_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('TASK_SUB') . $row->title;?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('TASK_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox" value="<?php echo $row->title;?>" size="55" /></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_SELPROJ');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('TASK_SELPROJ');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"<?php if($prow->id == $row->project_id)echo 'selected="selected"';?>><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="details" cols="20" rows="1" id="bodycontent"><?php echo $row->details;?></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_START');?>:</th>
          <td><input name="created" type="text" class="inputbox" id="start_date" size="25" value="<?php echo $row->created;?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_DUE');?>:</th>
          <td><input name="duedate" type="text" class="inputbox" id="end_date" size="25" value="<?php echo $row->duedate;?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_ASSIGNED');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($stafflist as $srow):?>
              <option value="<?php echo $srow->id;?>"<?php if($srow->id == $row->staff_id)echo 'selected="selected"';?>><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_VISIBLE');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="client_access" value="1" <?php getChecked($row->client_access, 1); ?> />
            <?php echo lang('NO');?>
            <input type="radio" name="client_access" value="0" <?php getChecked($row->client_access, 0); ?> /></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_PROGRESS');?>:</th>
          <td><label for="progress"><?php echo lang('TASK_COMPLETED');?>:</label>
            <input type="text" id="progress" style="border:0; color:#5AB814;font-weight:bold; background-color:transparent" name="progress"/>
            <div id="progress-range" style="width: 250px;margin-top:2px"></div></td>
        </tr>
        <tr>
          <td><input name="update" type="submit" value="<?php echo lang('TASK_UPDATE');?>"  class="button button-green"/></td>
          <td><a href="index.php?do=tasks" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
      <input name="id" type="hidden" value="<?php echo Filter::$id;?>" />
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectTask");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
$(function() {
	$( "#progress-range" ).slider({
		value:<?php echo $row->progress;?>,
		min: 0,
		max: 100,
		slide: function(event, ui) {
			$("#progress").val( ui.value + "%");
		}
	});
	$("#progress").val( $("#progress-range").slider("value") + "%");
});
$(function () {
    $("#start_date, #end_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php case"add": ?>
<?php $plist = $content->getProjectList();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TASK_TITLE1');?></h1>
<p class="info"><?php echo lang('TASK_INFO1') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="block-border">
  <div class="block-content">
    <form action="" method="post" id="admin_form" name="admin_form">
      <table cellspacing="0" cellpadding="0" class="forms">
        <thead>
          <tr>
            <th colspan="2" class="left"><?php echo lang('TASK_SUB1');?></th>
          </tr>
        </thead>
        <tr>
          <th width="200"><?php echo lang('TASK_NAME');?>: <?php echo required();?></th>
          <td><input name="title" type="text" class="inputbox"  size="55"/></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_SELPROJ');?>: <?php echo required();?></th>
          <td><select name="project_id" class="custombox" style="width:250px">
              <option value="">--- <?php echo lang('TASK_SELPROJ');?> ---</option>
              <?php if ($plist):?>
              <?php foreach ($plist as $prow):?>
              <option value="<?php echo $prow->id;?>"><?php echo $prow->title;?></option>
              <?php endforeach;?>
              <?php unset($prow);?>
              <?php endif;?>
            </select></td>
        </tr>
        <tr>
          <td colspan="2"><textarea name="details" cols="20" rows="1" id="bodycontent"></textarea></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_START');?>:</th>
          <td><input name="created" type="text" class="inputbox" id="start_date" size="25" value="<?php echo date('Y-m-d');?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_DUE');?>:</th>
          <td><input name="duedate" type="text" class="inputbox" id="end_date" size="25" value="<?php echo date('Y-m-d');?>"/></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_ASSIGNED');?>:</th>
          <td><select name="staff_id" class="custombox" style="width:250px">
              <?php foreach ($user->getUserList("9' or userlevel = '5") as $srow):?>
              <option value="<?php echo $srow->id;?>"><?php echo $srow->name;?></option>
              <?php endforeach;?>
              <?php unset($srow);?>
            </select></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_VISIBLE');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="client_access" id="client_access-1" value="1" />
            <?php echo lang('NO');?>
    <input name="client_access" type="radio" id="client_access-2" value="0" checked="checked" /></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_NOTIFY');?>:</th>
          <td><?php echo lang('YES');?>
            <input type="radio" name="notify_staff" value="1" />
            <?php echo lang('NO');?>
    <input name="notify_staff" type="radio" value="0" checked="checked" /></td>
        </tr>
        <tr>
          <th><?php echo lang('TASK_PROGRESS');?>:</th>
          <td><label for="progress"><?php echo lang('TASK_COMPLETED');?>:</label>
            <input type="text" id="progress" style="border:0; font-weight:bold; background-color:transparent" name="progress"/>
            <div id="progress-range" style="width: 250px;margin-top:2px"></div></td>
        </tr>
        <tr>
          <td><input name="add" type="submit" value="<?php echo lang('TASK_ADD');?>"  class="button button-green"/></td>
          <td colspan="2"><a href="index.php?do=tasks" class="button-alt button-gray"><?php echo lang('CANCEL');?></a></td>
        </tr>
      </table>
    </form>
  </div>
</div>
<?php echo Core::doForm("processProjectTask");?> 
<script type="text/javascript">
  $(document).ready(function() {
	$("#bodycontent").cleditor({height:200});
  });
$(function() {
	$( "#progress-range" ).slider({
		value:0,
		min: 0,
		max: 100,
		slide: function(event, ui) {
			$("#progress").val( ui.value + "%");
		}
	});
	$("#progress").val( $("#progress-range").slider("value") + "%");
});
$(function () {
    $("#start_date, #end_date").datepicker({
        showOn: 'button',
        buttonImage: '../images/calendar.png',
        buttonImageOnly: true,
        dateFormat: 'yy-mm-dd'
    });
});
</script>
<?php break;?>
<?php default: ?>
<?php $taskrow = $content->getProjectTasks();?>
<h1><img src="../images/projects.png" alt="" /><?php echo lang('TASK_TITLE2');?></h1>
<p class="info"><?php echo lang('TASK_INFO2');?></p>
<div class="block-border">
  <div class="block-header">
    <h2><span><a href="index.php?do=tasks&amp;action=add" class="add"><?php echo lang('TASK_ADD');?></a></span><?php echo lang('TASK_SUB2');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('TASK_NAME');?></th>
          <th class="left"><?php echo lang('PROJ_NAME');?></th>
          <th class="left"><?php echo lang('TASK_PROGRESS');?></th>
          <th class="left"><?php echo lang('CREATED');?></th>
          <th><?php echo lang('EDIT');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="7"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <?php if(!$taskrow):?>
      <tr>
        <td colspan="7"><?php echo Filter::msgInfo(lang('TASK_NOTASKS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($taskrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><?php echo $row->title;?></td>
        <td><a href="index.php?do=projects&amp;action=edit&amp;id=<?php echo $row->pid;?>"><?php echo $row->ptitle;?></a></td>
        <td><?php echo $content->progressBarStatus($row->progress);?></td>
        <td><?php echo Filter::dodate($core->short_date, $row->created);?></td>
        <td align="center"><a href="index.php?do=tasks&amp;action=edit&amp;id=<?php echo $row->id;?>"><img src="../images/edit.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('EDIT').': '.$row->title;?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->title;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->title;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('TASK_DELTASK'),"deleteProjectTask");?>
<?php break;?>
<?php endswitch;?>