<?php
  /**
   * Payment Transactions
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: transactions.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');
?>
<?php $transrow = $content->getPaymentTransactions();?>	
<h1><img src="../images/gateway.png" alt="" /><?php echo lang('TRANS_TITLE');?></h1>
<p class="info"><?php echo lang('TRANS_INFO');?></p>
<div class="block-border">
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <tr>
        <td class="subtitle"><select name="select" class="custombox" id="paymentfilter" style="width:200px">
            <option value="NA">--- <?php echo lang('TRANS_RESET');?> ---</option>
            <?php echo $content->getPaymentFilter();?>
          </select></td>
        <td align="center" class="subtitle"><form action="" method="post" id="dForm">
            <strong> <?php echo lang('FROM');?></strong>
            <input name="fromdate" type="text" style="margin-right:3px" class="inputbox-sml" size="10" id="fromdate" />
            <strong> <?php echo lang('TO');?></strong>
            <input name="enddate" type="text" class="inputbox-sml" size="10" id="enddate" />
            <input name="find" type="submit" class="button-alt button-blue" value="<?php echo lang('FIND');?>" />
          </form></td>
        <td align="right" class="subtitle"><?php echo $pager->items_per_page();?> &nbsp;&nbsp; <?php echo $pager->jump_menu();?></td>
      </tr>
    </table>
  </div>
</div>
<div class="block-border">
  <div class="block-header">
    <h2><?php if($transrow):?><span><a href="controller.php?action=createReport" class="add"><?php echo lang('TRANS_REPORT');?></a><?php endif;?></span><?php echo lang('TRANS_SUB');?></h2>
  </div>
  <div class="block-content">
    <table cellpadding="0" cellspacing="0" class="display">
      <thead>
        <tr>
          <th width="20">#</th>
          <th class="left"><?php echo lang('PROJ_NAME');?></th>
          <th class="left">#<?php echo lang('TRANS_INVOICE');?></th>
          <th class="left"><?php echo lang('TRANS_PAYDATE');?></th>
          <th class="left"><?php echo lang('PAYMETHOD');?></th>
          <th class="left"><?php echo lang('AMOUNT');?></th>
          <th><?php echo lang('INFO');?></th>
          <th><?php echo lang('DELETE');?></th>
        </tr>
      </thead>
      <?php if($pager->display_pages()):?>
      <tfoot>
        <tr>
          <td colspan="8"><?php echo $pager->display_pages();?></td>
        </tr>
      </tfoot>
      <?php endif;?>
      <?php if(!$transrow):?>
      <tr>
        <td colspan="8"><?php echo Filter::msgInfo(lang('TRANS_NOTRANS'),false);?></td>
      </tr>
      <?php else:?>
      <?php foreach ($transrow as $row):?>
      <tr>
        <th align="center"><?php echo $row->id;?>.</th>
        <td><a href="index.php?do=projects&amp;action=edit&amp;id=<?php echo $row->project_id;?>"><?php echo $row->ptitle;?></a></td>
        <td><a href="index.php?do=invoices&amp;action=edit&amp;pid=<?php echo $row->project_id;?>&amp;id=<?php echo $row->invoice_id;?>"><?php echo $row->ititle;?></a></td>
        <td><?php echo Filter::dodate($core->short_date, $row->created);?></td>
        <td><?php echo $row->method;?></td>
        <td><?php echo $row->amount;?></td>
        <td align="center"><a href="javascript:void(0);"><img src="../images/view.png" alt="" class="tooltip img-wrap2" title="<?php echo wordwrap($row->description, 20, "<br />\n");?>"/></a></td>
        <td align="center"><a href="javascript:void(0);" class="delete" id="item_<?php echo $row->id;?>" rel="<?php echo $row->ptitle;?>"><img src="../images/delete.png" alt="" class="tooltip img-wrap2" title="<?php echo lang('DELETE').': '.$row->ptitle;?>" /></a></td>
      </tr>
      <?php endforeach;?>
      <?php unset($row);?>
      <?php endif;?>
    </table>
  </div>
</div>
<?php echo Core::doDelete(lang('TRANS_DELETE'),"deleteInvoiceRecord");?> 
<script type="text/javascript"> 
// <![CDATA[  
$(document).ready(function () {
    $('#paymentfilter').change(function () {
		var res = $("#paymentfilter option:selected").val();
		(res == "NA" ) ? window.location.href = 'index.php?do=transactions' : window.location.href = 'index.php?do=transactions&sort=' + res;
    })
});
$(function () {
    var dates = $('#fromdate, #enddate').datepicker({
        defaultDate: "+1w",
        changeMonth: false,
        numberOfMonths: 2,
        dateFormat: 'yy-mm-dd',
        onSelect: function (selectedDate) {
            var option = this.id == "fromdate" ? "minDate" : "maxDate";
            var instance = $(this).data("datepicker");
            var date = $.datepicker.parseDate(instance.settings.dateFormat || $.datepicker._defaults.dateFormat, selectedDate, instance.settings);
            dates.not(this).datepicker("option", option, date);
        }
    });
});
// ]]>
</script>