<?php
  /**
   * Core Class
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2011
   * @version $Id: core_class.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');

  class Core
  {

      const sTable = "settings";
      public $year = null;
      public $month = null;
      public $day = null;


      /**
       * Core::__construct()
       * 
       * @return
       */
      function __construct()
      {
          $this->getSettings();

          ($this->dtz) ? date_default_timezone_set($this->dtz) : date_default_timezone_set('GMT');

          $this->year = (get('year')) ? get('year') : strftime('%Y');
          $this->month = (get('month')) ? get('month') : strftime('%m');
          $this->day = (get('day')) ? get('day') : strftime('%d');

          return mktime(0, 0, 0, $this->month, $this->day, $this->year);
      }


      /**
       * Core::getSettings()
       * 
       * @return
       */
      private function getSettings()
      {
          $sql = "SELECT * FROM " . self::sTable;
          $row = Registry::get("Database")->first($sql);

          $this->company = $row->company;
          $this->site_url = $row->site_url;
          $this->site_email = $row->site_email;
          $this->address = $row->address;
          $this->city = $row->city;
          $this->state = $row->state;
          $this->zip = $row->zip;
          $this->phone = $row->phone;
          $this->fax = $row->fax;
          $this->logo = $row->logo;
          $this->short_date = $row->short_date;
          $this->long_date = $row->long_date;
          $this->dtz = $row->dtz;
		  $this->weekstart  = $row->weekstart ;
		  $this->enable_reg = $row->enable_reg;
          $this->enable_tax = $row->enable_tax;
          $this->tax_name = $row->tax_name;
          $this->tax_rate = $row->tax_rate;
		  $this->tax_number = $row->tax_number;
		  $this->enable_offline = $row->enable_offline;
		  $this->offline_info = $row->offline_info;
          $this->enable_uploads = $row->enable_uploads;
          $this->file_types = $row->file_types;
          $this->file_max = $row->file_max;
          $this->perpage = $row->perpage;
          $this->sbackup = $row->sbackup;
          $this->currency = $row->currency;
          $this->cur_symbol = $row->cur_symbol;
          $this->mailer = $row->mailer;
          $this->smtp_host = $row->smtp_host;
          $this->smtp_user = $row->smtp_user;
          $this->smtp_pass = $row->smtp_pass;
          $this->smtp_port = $row->smtp_port;

          $this->crmv = $row->crmv;

      }

      /**
       * Core::processConfig()
       * 
       * @return
       */
      public function processConfig()
      {
          if (empty($_POST['company']))
              Filter::$msgs['company'] = lang('CONF_COMPANY_R');

          if (empty($_POST['site_url']))
              Filter::$msgs['site_url'] = lang('CONF_URL_R');

          if (empty($_POST['site_email']))
              Filter::$msgs['site_email'] = lang('CONF_EMAIL_R');

          if (empty($_POST['currency']))
              Filter::$msgs['currency'] = lang('CONF_CURRENCY_R');

          if (isset($_POST['mailer']) && $_POST['mailer'] == "SMTP") {
              if (empty($_POST['smtp_host']))
                  Filter::$msgs['smtp_host'] = lang('CONF_SMTP_HOST_R');
              if (empty($_POST['smtp_user']))
                  Filter::$msgs['smtp_user'] = lang('CONF_SMTP_USER_R');
              if (empty($_POST['smtp_pass']))
                  Filter::$msgs['smtp_pass'] = lang('CONF_SMTP_PASS_R');
              if (empty($_POST['smtp_port']))
                  Filter::$msgs['smtp_port'] = lang('CONF_SMTP_PORT_R');
          }

          if (!empty($_FILES['logo']['name'])) {
              $file_info = getimagesize($_FILES['logo']['tmp_name']);
              if (empty($file_info))
                  Filter::$msgs['logo'] = lang('CONF_LOGO_R');
          }

          if (empty(Filter::$msgs)) {
              $data = array(
					  'company' => sanitize($_POST['company']),
					  'site_url' => sanitize($_POST['site_url']),
					  'site_email' => sanitize($_POST['site_email']),
					  'address' => sanitize($_POST['address']), 
					  'city' => sanitize($_POST['city']),
					  'state' => sanitize($_POST['state']),
					  'zip' => sanitize($_POST['zip']),
					  'phone' => sanitize($_POST['phone']),
					  'fax' => sanitize($_POST['fax']),
					  'short_date' => sanitize($_POST['short_date']),
					  'long_date' => sanitize($_POST['long_date']),
					  'dtz' => trim($_POST['dtz']),
					  'weekstart' => intval($_POST['weekstart']),
					  'enable_reg' => intval($_POST['enable_reg']),
					  'enable_tax' => intval($_POST['enable_tax']),
					  'tax_name' => sanitize($_POST['tax_name']),
					  'tax_rate' => intval($_POST['tax_rate']) / 100,
					  'tax_number' => sanitize($_POST['tax_number']),
					  'enable_offline' => intval($_POST['enable_offline']),
					  'offline_info' => sanitize($_POST['offline_info']),
					  'enable_uploads' => intval($_POST['enable_uploads']),
					  'file_types' => trim($_POST['file_types']),
					  'file_max' => intval($_POST['file_max']*1048576),				  
					  'perpage' => intval($_POST['perpage']),
					  'currency' => sanitize($_POST['currency']),
					  'cur_symbol' => sanitize($_POST['cur_symbol']),					  
					  'mailer' => sanitize($_POST['mailer']),
					  'smtp_host' => sanitize($_POST['smtp_host']),
					  'smtp_user' => sanitize($_POST['smtp_user']),
					  'smtp_pass' => sanitize($_POST['smtp_pass']),
					  'smtp_port' => intval($_POST['smtp_port'])
				  );

			  if (isset($_POST['dellogo']) and $_POST['dellogo'] == 1) {
				  $data['logo'] = "NULL";
			  } elseif (!empty($_FILES['logo']['name'])) {
				  if ($this->logo) {
					  @unlink(UPLOADS . $this->logo);
				  }
					  move_uploaded_file($_FILES['logo']['tmp_name'], UPLOADS.$_FILES['logo']['name']);

				  $data['logo'] = sanitize($_FILES['logo']['name']);
			  } else {
				$data['logo'] = $this->logo;
			  }
			  
              Registry::get("Database")->update(self::sTable, $data);
              (Registry::get("Database")->affected()) ? Filter::msgOk(lang('CONF_UPDATED')) : Filter::msgAlert(lang('NOPROCCESS'));
          } else
              print Filter::msgStatus();
      }


      /**
       * Core::getShortDate()
       * 
       * @return
       */
      public function getShortDate()
      {
          $arr = array(
				 '%m-%d-%Y' => '12-21-2009 (MM-DD-YYYY)',
				 '%e-%m-%Y' => '21-12-2009 (D-MM-YYYY)',
				 '%m-%e-%y' => '12-21-09 (MM-D-YY)',
				 '%e-%m-%y' => '21-12-09 (D-MM-YY)',
				 '%b %d %Y' => 'Dec 21 2009'
		  );

          $shortdate = '';
          foreach ($arr as $key => $val) {
              if ($key == $this->short_date) {
                  $shortdate .= "<option selected=\"selected\" value=\"" . $key . "\">" . $val . "</option>\n";
              } else
                  $shortdate .= "<option value=\"" . $key . "\">" . $val . "</option>\n";
          }
          unset($val);
          return $shortdate;
      }


      /**
       * Core::getLongDate()
       * 
       * @return
       */
      public function getLongDate()
      {
          $arr = array(
				'%B %d, %Y' => 'December 21, 2009',
				'%d %B %Y %H:%M' => '21 December 2009 19:00',
				'%B %d, %Y %I:%M %p' => 'December 21, 2009 4:00 am',
				'%A %d %B, %Y' => 'Monday 21 December, 2009',
				'%A %d %B, %Y %H:%M' => 'Monday 21 December 2009 07:00',
				'%a %d, %B' => 'Mon. 12, December'
		  );

          $longdate = '';
          foreach ($arr as $key => $val) {
              if ($key == $this->long_date) {
                  $longdate .= "<option selected=\"selected\" value=\"" . $key . "\">" . $val . "</option>\n";
              } else
                  $longdate .= "<option value=\"" . $key . "\">" . $val . "</option>\n";
          }
          unset($val);
          return $longdate;
      }

      /**
       * Core::yearlyStats()
       * 
       * @return
       */
      public function yearlyStats()
      {
          $sql = "SELECT *, YEAR(created) as year, MONTH(created) as month," 
		  . "\n COUNT(id) as total, SUM(amount) as totalprice" 
		  . "\n FROM invoice_payments" 
		  . "\n WHERE YEAR(created) = '" . $this->year . "'" 
		  . "\n GROUP BY year DESC, month DESC ORDER by created";

          $row = Registry::get("Database")->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Core::getYearlySummary()
       * 
       * @return
       */
      public function getYearlySummary()
      {
          $sql = "SELECT YEAR(created) as year, MONTH(created) as month," 
		  . "\n COUNT(id) as total, SUM(amount) as totalprice" 
		  . "\n FROM invoice_payments" 
		  . "\n WHERE YEAR(created) = '" . $this->year . "' GROUP BY year";

          $row = Registry::get("Database")->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Core::yearList()
       * 
       * @param mixed $start_year
       * @param mixed $end_year
       * @return
       */
      function yearList($start_year, $end_year)
      {
          $selected = is_null(get('year')) ? date('Y') : get('year');
          $r = range($start_year, $end_year);

          $select = '';
          foreach ($r as $year) {
              $select .= "<option value=\"$year\"";
              $select .= ($year == $selected) ? ' selected="selected"' : '';
              $select .= ">$year</option>\n";
          }
          return $select;
      }


      /**
       * Core::monthList()
       * 
       * @return
       */
      public function monthList()
      {
          $selected = is_null(get('month')) ? strftime('%m') : get('month');

          $arr = array(
		          '01' => lang('JAN'), 
		          '02' => lang('FEB'), 
		          '03' => lang('MAR'), 
		          '04' => lang('APR'), 
		          '05' => lang('MAY'), 
		          '06' => lang('JUN'), 
		          '07' => lang('JUL'), 
		          '08' => lang('AUG'), 
		          '09' => lang('SEP'), 
		          '10' => lang('OCT'), 
		          '11' => lang('NOV'), 
		          '12' => lang('DEC')
          );

          $monthlist = '';
          foreach ($arr as $key => $val) {
              $monthlist .= "<option value=\"$key\"";
              $monthlist .= ($key == $selected) ? ' selected="selected"' : '';
              $monthlist .= ">$val</option>\n";
          }
          unset($val);
          return $monthlist;
      }

      /**
       * Core::weekList()
       * 
       * @return
       */
      public function weekList()
      {
          $arr = array(
		          '1' => lang('SUN'), 
		          '2' => lang('MON'), 
		          '3' => lang('TUE'), 
		          '4' => lang('WED'), 
		          '5' => lang('THU'), 
		          '6' => lang('FRI'), 
		          '7' => lang('SAT')
          );

          $weeklist = '';
          foreach ($arr as $key => $val) {
              $weeklist .= "<option value=\"$key\"";
              $weeklist .= ($key == $this->weekstart) ? ' selected="selected"' : '';
              $weeklist .= ">$val</option>\n";
          }
          unset($val);
          return $weeklist;
      }
	  
      /**
       * Core::projectStats()
       * 
       * @return
       */
      public function projectStats()
      {
          $sql = "SELECT *, MONTH(start_date) as month" 
		  . "\n FROM projects" 
		  . "\n WHERE MONTH(start_date) = '" . $this->month . "'" 
		  . "\n AND YEAR(start_date) = '" . $this->year . "'" 
		  . "\n ORDER by start_date";

          $row = Registry::get("Database")->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Core::progressBarBilling()
       * 
       * @param mixed $paid
       * @param mixed $total
       * @return
       */
      public function progressBarBilling($paid, $total)
      {
          $percent = number_format(($paid * 100) / $total);
          return $percent;
      }

      /**
       * Core::getTimezones()
       * 
       * @return
       */
      public function getTimezones()
      {
          $data = '';
          $tzone = DateTimeZone::listIdentifiers();
          $data .= '<select name="dtz" style="width:250px" class="custombox">';
          foreach ($tzone as $zone) {
              $selected = ($zone == $this->dtz) ? ' selected="selected"' : '';
              $data .= '<option value="' . $zone . '"' . $selected . '>' . $zone . '</option>';
          }
          $data .= '</select>';
          return $data;
      }

      /**
       * Core::formatMoney()
       * 
       * @param mixed $amount
       * @return
       */
      function formatMoney($amount)
      {
          return $this->cur_symbol . number_format($amount, 2, '.', ',') . $this->currency;
      }

      /**
       * Core::getRowById()
       * 
       * @param mixed $table
       * @param mixed $id
       * @param bool $and
       * @param bool $is_admin
       * @return
       */
      public function getRowById($table, $id, $and = false, $is_admin = true)
      {
          $id = sanitize($id, 8, true);
          if ($and) {
              $sql = "SELECT * FROM " . (string )$table . " WHERE id = '" . Registry::get("Database")->escape((int)$id) . "' AND " . Registry::get("Database")->escape($and) . "";
          } else
              $sql = "SELECT * FROM " . (string )$table . " WHERE id = '" . Registry::get("Database")->escape((int)$id) . "'";

          $row = Registry::get("Database")->first($sql);

          if ($row) {
              return $row;
          } else {
              if ($is_admin)
                  Filter::error("You have selected an Invalid Id - #" . $id, "Core::getRowById()");
          }
      }

      /**
       * Core::countInvoices()
       * 
       * @return
       */
      public function countInvoices()
      {
		  $sql = "SELECT COUNT(id) as total"
		  . "\n FROM invoices"
		  . "\n WHERE YEAR(duedate) = " . date('Y')
		  . "\n AND MONTH(duedate) = " . date('m')
		  . "\n AND status = 'Unpaid'";
		  $row = Registry::get("Database")->first($sql);
		  
		  return ($row) ? $row->total : 0;

      }

      /**
       * Core::countProjects()
       * 
       * @return
       */
      public function countProjects()
      {
		  $sql = "SELECT COUNT(id) as total"
		  . "\n FROM projects"
		  . "\n WHERE YEAR(end_date) = " . date('Y')
		  . "\n AND MONTH(end_date) = " . date('m')
		  . "\n AND p_status <> 100";
		  $row = Registry::get("Database")->first($sql);
		  
		  return ($row) ? $row->total : 0;

      }

      /**
       * Core::countTasks()
       * 
       * @return
       */
      public function countTasks()
      {
		  $sql = "SELECT COUNT(id) as total"
		  . "\n FROM tasks"
		  . "\n WHERE YEAR(duedate) = " . date('Y')
		  . "\n AND MONTH(duedate) = " . date('m')
		  . "\n AND progress <> 100";
		  $row = Registry::get("Database")->first($sql);
		  
		  return ($row) ? $row->total : 0;

      }

      /**
       * Core::countTickets()
       * 
       * @return
       */
      public function countTickets()
      {
		  $sql = "SELECT COUNT(id) as total"
		  . "\n FROM support_tickets"
		  . "\n WHERE YEAR(created) = " . date('Y')
		  . "\n AND MONTH(created) = " . date('m')
		  . "\n AND status = 'Open'";
		  $row = Registry::get("Database")->first($sql);
		  
		  return ($row) ? $row->total : 0;

      }

      /**
       * Core::countMessages()
       * 
       * @return
       */
      public function countMessages()
      {
          if (Registry::get("Users")->userlevel == 5) {
              $access = "AND recipient='" . Registry::get("Users")->uid . "'";
          } else {
			  $access = null;
          }
		  
		  $sql = "SELECT COUNT(id) as total"
		  . "\n FROM messages"
		  . "\n WHERE status_r = 1"
		  . "\n $access";
		  $row = Registry::get("Database")->first($sql);
		  
		  return ($row) ? $row->total : 0;

      }
	  
      /**
       * Core::doForm()
       * 
       * @param mixed $data
       * @param string $url
       * @param integer $reset
       * @param integer $clear
       * @param string $form_id
       * @param string $msgholder
       * @return
       */
      public static function doForm($data, $url = "controller.php", $reset = 0, $clear = 0, $form_id = "admin_form", $msgholder = "msgholder")
      {
          $display = '
		  <script type="text/javascript">
		  // <![CDATA[
			  $(document).ready(function () {
				  var options = {
					  target: "#' . $msgholder . '",
					  beforeSubmit:  showLoader,
					  success: showResponse,
					  url: "' . $url . '",
					  resetForm : ' . $reset . ',
					  clearForm : ' . $clear . ',
					  data: {
						  ' . $data . ': 1
					  }
				  };
				  $("#' . $form_id . '").ajaxForm(options);
			  });
			  
			  function showLoader() {
				  $("#loader").fadeIn(200);
			  }
		  
			  function hideLoader() {
				  $("#loader").fadeOut(200);
			  };	
			  		  
			  function showResponse(msg) {
				  hideLoader();
				  $(this).html(msg);
				  $("html, body").animate({
					  scrollTop: 0
				  }, 600);
			  }
			  ';
          $display .= '
		  // ]]>
		  </script>';

          print $display;
      }


      /**
       * Core::doDelete()
       * 
       * @param mixed $title
       * @param mixed $varpost
       * @param string $attr
       * @param string $id
       * @param string $dialog
       * @param string $url
       * @return
       */
      public static function doDelete($title, $varpost, $attr = 'item_', $id = 'a.delete', $dialog = 'dialog-confirm', $url = "controller.php")
      {
          $display = "
		  <div id=\"" . $dialog . "\" style=\"display:none;\" title=\"" . $title . "\">
			<p><span class=\"ui-icon ui-icon-alert\" style=\"float:left; margin:0 7px 20px 0;\"></span>" . lang('DELCONFIRM') ."</p>
		  </div>
		  <script type=\"text/javascript\"> 
		  // <![CDATA[
		  $(document).ready(function () {
			  $('" . $id . "').live('click', function () {
				  var id = $(this).attr('id').replace('" . $attr . "', '')
				  var parent = $(this).parent().parent();
				  var title = $(this).attr('rel');
				  $(\"#" . $dialog . "\").data({
					  'delid': id,
					  'parent': parent,
					  'title': title
				  }).dialog('open');
				  return false;
			  });
		  
			  $(\"#" . $dialog . "\").dialog({
				  resizable: false,
				  bgiframe: true,
				  autoOpen: false,
				  width: 400,
				  height: 'auto',
				  zindex: 9998,
				  modal: false,
				  buttons: {
					  '" . lang('DELETE') . "': function () {
						  var parent = $(this).data('parent');
						  var id = $(this).data('delid');
						  var title = $(this).data('title');
		  
						  $.ajax({
							  type: 'post',
							  url: '" . $url . "',
							  data: '" . $varpost . "=' + id + '&title=' + encodeURIComponent(title),
							  beforeSend: function () {
								  parent.animate({
									  'backgroundColor': '#FFBFBF'
								  }, 400);
							  },
							  success: function (msg) {
								  parent.fadeOut(400, function () {
									  parent.remove();
								  });
								  $('html, body').animate({scrollTop:0}, 600);
								  $(\"#msgholder\").html(msg);
							  }
						  });
		  
						  $(this).dialog('close');
					  },
					  '" . lang('CANCEL') . "': function () {
						  $(this).dialog('close');
					  }
				  }
			  });
		  });
		  // ]]>
		  </script>";

          print $display;
      }
  }
?>