<?php
  /**
   * User Class
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: class_user.php, v1.00 2011-06-05 10:12:05 gewa Exp $
   */
  
  if (!defined("_VALID_PHP"))
      die('Direct access to this location is not allowed.');

  class Users
  {
      const uTable = "users";
      public $logged_in = null;
      public $uid = 0;
      public $userid = 0;
      public $username;
      public $sesid;
      public $email;
      public $name;
      public $userlevel;
      private $lastlogin = "NOW()";
      private static $db;

      /**
       * Users::__construct()
       * 
       * @return
       */
      function __construct()
      {
          self::$db = Registry::get("Database");

          $this->getUserId();
          $this->startSession();
      }

      /**
       * Users::getUserId()
       * 
       * @return
       */
      private function getUserId()
      {
          if (isset($_GET['userid'])) {
              $userid = (is_numeric($_GET['userid']) && $_GET['userid'] > -1) ? intval($_GET['userid']) : false;
              $userid = sanitize($userid);

              if ($userid == false) {
                  Filter::error("You have selected an Invalid Userid", "Users::getUserId()");
              } else
                  return $this->userid = $userid;
          }
      }


      /**
       * Users::startSession()
       * 
       * @return
       */
      private function startSession()
      {
          session_start();
          $this->logged_in = $this->loginCheck();

          if (!$this->logged_in) {
              $this->username = $_SESSION['username'] = "Guest";
              $this->sesid = sha1(session_id());
              $this->userlevel = 0;
          }
      }

      /**
       * Users::loginCheck()
       * 
       * @return
       */
      private function loginCheck()
      {
          if (isset($_SESSION['username']) && $_SESSION['username'] != "Guest") {

              $row = $this->getUserInfo($_SESSION['username']);
              $this->uid = $row->id;
              $this->username = $row->username;
              $this->email = $row->email;
              $this->name = $row->fname . ' ' . $row->lname;
              $this->userlevel = $row->userlevel;
              $this->sesid = sha1(session_id());
              return true;
          } else {
              return false;
          }
      }

      /**
       * Users::is_Admin()
       * 
       * @return
       */
      public function is_Admin()
      {
          return ($this->userlevel == 9 or $this->userlevel == 5);

      }

      /**
       * Users::login()
       * 
       * @param mixed $username
       * @param mixed $password
       * @return
       */
      public function login($username, $password)
      {
          if ($username == "" && $password == "") {
              Filter::$msgs['username'] = lang('LOGIN_R5');
          } else {
              $status = $this->checkStatus($username, $password);

              switch ($status) {
                  case 0:
                      Filter::$msgs['username'] = lang('LOGIN_R1');
                      break;

                  case 1:
                      Filter::$msgs['username'] = lang('LOGIN_R2');
                      break;

                  case 2:
                      Filter::$msgs['username'] = lang('LOGIN_R3');
                      break;

                  case 3:
                      Filter::$msgs['username'] = lang('LOGIN_R4');
                      break;
              }
          }
          if (empty(Filter::$msgs) && $status == 5) {
              $row = $this->getUserInfo($username);
              $this->uid = $_SESSION['userid'] = $row->id;
              $this->username = $_SESSION['username'] = $row->username;
              $this->email = $_SESSION['email'] = $row->email;
              $this->userlevel = $_SESSION['userlevel'] = $row->userlevel;

              $data = array('lastlogin' => $this->lastlogin, 'lastip' => sanitize($_SERVER['REMOTE_ADDR']));
              self::$db->update(self::uTable, $data, "username='" . $this->username . "'");

              return true;
          } else
              Filter::msgStatus();
      }

      /**
       * Users::logout()
       * 
       * @return
       */
      public function logout()
      {
          unset($_SESSION['username']);
          unset($_SESSION['email']);
          unset($_SESSION['name']);
          unset($_SESSION['userid']);
          unset($_SESSION['uid']);
          session_destroy();
          session_regenerate_id();

          $this->logged_in = false;
          $this->username = "Guest";
          $this->userlevel = 0;
      }

      /**
       * Users::getUserInfo()
       * 
       * @param mixed $username
       * @return
       */
      public function getUserInfo($username)
      {
          $username = sanitize($username);
          $username = self::$db->escape($username);

          $sql = "SELECT * FROM " . self::uTable . " WHERE username = '" . $username . "'";
          $row = self::$db->first($sql);
          if (!$username)
              return false;

          return ($row) ? $row : 0;
      }

      /**
       * Users::getUserList()
       * 
       * @param mixed $userlevel
       * @return
       */
      public function getUserList($userlevel)
      {
          $sql = "SELECT id, CONCAT(fname,' ',lname) as name, email  FROM " . self::uTable . " WHERE userlevel = '" . $userlevel . "'";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::checkStatus()
       * 
       * @param mixed $username
       * @param mixed $password
       * @return
       */
      public function checkStatus($username, $password)
      {

          $username = sanitize($username);
          $username = self::$db->escape($username);
          $password = sanitize($password);

          $sql = "SELECT password, active FROM " . self::uTable . " WHERE username = '" . $username . "'";
          $result = self::$db->query($sql);

          if (self::$db->numrows($result) == 0)
              return 0;

          $row = self::$db->fetch($result);
          $entered_pass = sha1($password);

          switch ($row->active) {
              case "b":
                  return 1;
                  break;

              case "n":
                  return 2;
                  break;

              case "t":
                  return 3;
                  break;

              case "y" && $entered_pass == $row->password:
                  return 5;
                  break;
          }
      }

      /**
       * Users::getClients()
       * 
       * @param bool $from
       * @return
       */
      public function getClients($from = false)
      {
          $pager = Paginator::instance();
          $pager->items_total = countEntries(self::uTable, 'userlevel', 1);
          $pager->default_ipp = Registry::get("Core")->perpage;
          $pager->paginate();

          if (isset($_GET['sort'])) {
              $data = explode("-", $_GET['sort']);
              if (count($data) > 1) {
                  $sort = sanitize($data[0]);
                  $order = sanitize($data[1]);
                  if (in_array($sort, array("company", "fname", "lname", "email"))) {
                      $ord = ($order == 'DESC') ? " DESC" : " ASC";
                      $sorting = " u." . $sort . $ord;
                  } else
                      $sorting = " u.created DESC";
              } else
                  $sorting = " u.created DESC";
          } else
              $sorting = " u.created DESC";

          $clause = (isset($clause)) ? $clause : null;

          if (isset($_POST['fromdate']) && $_POST['fromdate'] <> "" || isset($from) && $from != '') {
              $enddate = date("Y-m-d");
              $fromdate = (empty($from)) ? $_POST['fromdate'] : $from;
              if (isset($_POST['enddate']) && $_POST['enddate'] <> "") {
                  $enddate = $_POST['enddate'];
              }
              $clause .= " AND u.created BETWEEN '" . trim($fromdate) . "' AND '" . trim($enddate) . " 23:59:59'";
          }

          $where = (isset($where)) ? $where : null;
          $sql = "SELECT u.*, u.id as id, CONCAT(u.fname,' ',u.lname) as fullname," 
		  . "\n DATE_FORMAT(u.created, '" . Registry::get("Core")->short_date . "') as cdate," 
		  . "\n DATE_FORMAT(u.lastlogin, '" . Registry::get("Core")->short_date . "') as adate," 
		  . "\n (SELECT COUNT(client_id) FROM projects WHERE client_id = u.id) as projects," 
		  . "\n (SELECT SUM(amount_paid) FROM invoices WHERE status <> 'Paid' AND client_id = u.id) as balance" 
		  . "\n FROM " . self::uTable . " as u" 
		  . "\n WHERE userlevel = 1" 
		  . "\n " . $clause 
		  . "\n ORDER BY " . $sorting . $pager->limit;
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getUsers()
       * 
       * @return
       */
      public function getUsers()
      {
          $sql = "SELECT * FROM " . self::uTable . " WHERE userlevel <> 1 ORDER BY created";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::processUser()
       * 
       * @return
       */
      public function processUser()
      {
          if (!Filter::$id) {
              if (empty($_POST['username']))
                  Filter::$msgs['username'] = lang('USERNAME_R1');

              if ($value = $this->usernameExists($_POST['username'])) {
                  if ($value == 1)
                      Filter::$msgs['username'] = lang('USERNAME_R2');
                  if ($value == 2)
                      Filter::$msgs['username'] = lang('USERNAME_R3');
                  if ($value == 3)
                      Filter::$msgs['username'] = lang('USERNAME_R4');
              }
          }

          if (empty($_POST['fname']))
              Filter::$msgs['fname'] = lang('FNAME_R');

          if (empty($_POST['lname']))
              Filter::$msgs['lname'] = lang('LNAME_R');

          if (!Filter::$id) {
              if (empty($_POST['password']))
                  Filter::$msgs['password'] = lang('PASSWORD_R1');
          }

          if (empty($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R1');
          if (!Filter::$id) {
              if ($this->emailExists($_POST['email']))
                  Filter::$msgs['email'] = lang('EMAIL_R2');
          }
          if (!$this->isValidEmail($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R3');

          if (empty(Filter::$msgs)) {

              $data = array(
					'username' => sanitize($_POST['username']), 
					'email' => sanitize($_POST['email']), 
					'lname' => sanitize($_POST['lname']), 
					'fname' => sanitize($_POST['fname']), 
					'company' => isset($_POST['company']) ? sanitize($_POST['company']) : 'NULL', 
					'address' => sanitize($_POST['address']),
					'city' => sanitize($_POST['city']), 
					'state' => sanitize($_POST['state']), 
					'country' => sanitize($_POST['country']),
					'zip' => sanitize($_POST['zip']), 
					'phone' => sanitize($_POST['phone']), 
					'notes' => sanitize($_POST['notes']), 
					'userlevel' => intval($_POST['userlevel']), 
					'active' => 'y'
			  );

              if (!Filter::$id)
                  $data['created'] = "NOW()";

              if (Filter::$id)
                  $userrow = Registry::get("Core")->getRowById(self::uTable, Filter::$id);

              if ($_POST['password'] != "") {
                  $data['password'] = sha1($_POST['password']);
              } else
                  $data['password'] = $userrow->password;

              (Filter::$id) ? self::$db->update(self::uTable, $data, "id='" . Filter::$id . "'") : self::$db->insert(self::uTable, $data);
              $message = (Filter::$id) ? lang('STAFF_UPDATED') : lang('STAFF_ADDED');

              if (self::$db->affected()) {
                  Filter::msgOk($message);
                  if (isset($_POST['notify']) && intval($_POST['notify']) == 1) {
                      require_once (BASEPATH . "lib/class_mailer.php");
					  $pass = sanitize($_POST['password']);
                      $mailer = $mail->sendMail();
                      $subject = lang('STAFF_ACTIVATION') . $data['fname'] . ' ' . $data['lname'];

                      ob_start();
                      require_once (BASEPATH . 'mailer/Member_Welcome_Message.tpl.php');
                      $html_message = ob_get_contents();
                      ob_end_clean();

                      $msg = Swift_Message::newInstance()
							  ->setSubject($subject)
							  ->setTo(array($data['email'] => $data['fname'] . ' ' . $data['lname']))
							  ->setFrom(array(Registry::get("Core")->site_email => Registry::get("Core")->company))
							  ->setBody($html_message, 'text/html');

                      $numSent = $mailer->send($msg);
                  }
              } else
                  Filter::msgAlert(lang('NOPROCCESS'));
          } else
              print Filter::msgStatus();
      }

      /**
       * Users::updateProfile()
       * 
       * @return
       */
      public function updateProfile()
      {
          if (empty($_POST['fname']))
              Filter::$msgs['fname'] = lang('FNAME_R');

          if (empty($_POST['lname']))
              Filter::$msgs['lname'] = lang('LNAME_R');

          if (empty($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R1');

          if (!$this->isValidEmail($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R3');

          if (empty(Filter::$msgs)) {

              $data = array(
					'email' => sanitize($_POST['email']), 
					'lname' => sanitize($_POST['lname']), 
					'fname' => sanitize($_POST['fname']), 
					'company' => sanitize($_POST['company']), 
					'address' => sanitize($_POST['address']), 
					'city' => sanitize($_POST['city']), 
					'state' => sanitize($_POST['state']), 
					'country' => sanitize($_POST['country']),
					'zip' => sanitize($_POST['zip']), 
					'phone' => sanitize($_POST['phone'])
			  );

              $userpass = getValue("password", self::uTable, "id = '" . $this->uid . "'");

              if ($_POST['password'] != "") {
                  $data['password'] = sha1($_POST['password']);
              } else
                  $data['password'] = $userpass;

              self::$db->update(self::uTable, $data, "id='" . $this->uid . "'");

              (self::$db->affected()) ? Filter::msgOk(lang('PRO_MSGOK')) : Filter::msgAlert(lang('NOPROCCESS'));
          } else
              print Filter::msgStatus();
      }

      /**
       * Users::register()
       * 
       * @return
       */
      public function register()
      {
          if (empty($_POST['username']))
              Filter::$msgs['username'] = lang('USERNAME_R1');

          if ($value = $this->usernameExists($_POST['username'])) {
              if ($value == 1)
                  Filter::$msgs['username'] = lang('USERNAME_R2');
              if ($value == 2)
                  Filter::$msgs['username'] = lang('USERNAME_R3');
              if ($value == 3)
                  Filter::$msgs['username'] = lang('USERNAME_R4');
          }

          if (empty($_POST['fname']))
              Filter::$msgs['fname'] = lang('FNAME_R');

          if (empty($_POST['lname']))
              Filter::$msgs['lname'] = lang('LNAME_R');

          if (empty($_POST['pass']))
              $this->msgs['pass'] = lang('PASSWORD_R1');

          if (strlen($_POST['pass']) < 6)
              Filter::$msgs['pass'] = lang('PASSWORD_T2');
          elseif (!preg_match("/^([0-9a-z])+$/i", ($_POST['pass'] = trim($_POST['pass']))))
              Filter::$msgs['pass'] = lang('PASSWORD_R2');
          elseif ($_POST['pass'] != $_POST['pass2'])
              Filter::$msgs['pass'] = lang('PASSWORD_R3');

          if (empty($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R1');

          if ($this->emailExists($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R2');

          if (!$this->isValidEmail($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R3');

          if (empty(Filter::$msgs)) {

              $pass = sanitize($_POST['pass']);
              $data = array(
					'username' => sanitize($_POST['username']), 
					'password' => sha1($_POST['pass']), 
					'email' => sanitize($_POST['email']), 
					'fname' => sanitize($_POST['fname']), 
					'lname' => sanitize($_POST['lname']), 
					'company' => sanitize($_POST['company']), 
					'address' => sanitize($_POST['address']),
					'city' => sanitize($_POST['city']), 
					'state' => sanitize($_POST['state']), 
					'country' => sanitize($_POST['country']),
					'zip' => sanitize($_POST['zip']), 
					'phone' => sanitize($_POST['phone']), 
					'active' => 'y', 
					'created' => "NOW()"
			  );

              self::$db->insert(self::uTable, $data);
              (self::$db->affected()) ? print "OK" : Filter::msgError(lang('REG_ERR'), false);

              require_once (BASEPATH . "lib/class_mailer.php");
              $mailer = $mail->sendMail();
              $subject = lang('REG_ESUBJECT') . Registry::get("Core")->company;

              ob_start();
              require_once (BASEPATH . 'mailer/Member_Welcome_Message.tpl.php');
              $html_message = ob_get_contents();
              ob_end_clean();

              $msg = Swift_Message::newInstance()
					->setSubject($subject)
					->setTo(array($data['email'] => $data['fname'] . ' ' . $data['lname']))
					->setFrom(array(Registry::get("Core")->site_email => Registry::get("Core")->company))
					->setBody($html_message, 'text/html');

              $mailer->send($msg);

          } else
              print Filter::msgStatus();
      }

      /**
       * Users::passReset()
       * 
       * @return
       */
      public function passReset()
      {
          if (empty($_POST['uname']))
              Filter::$msgs['uname'] = lang('USERNAME_R1');

          $uname = $this->usernameExists($_POST['uname']);
          if (strlen($_POST['uname']) < 4 || strlen($_POST['uname']) > 30 || !preg_match("/^([0-9a-z])+$/i", $_POST['uname']) || $uname != 3)
              Filter::$msgs['uname'] = lang('USERNAME_R5');

          if (empty($_POST['email']))
              Filter::$msgs['email'] = lang('EMAIL_R1');

          if (!$this->emailExists($_POST['email']))
              Filter::$msgs['uname'] = lang('EMAIL_R4');

          if (empty($_POST['captcha']))
              Filter::$msgs['captcha'] = lang('FORM_ERROR6');
			  
		  if ($_SESSION['captchacode'] != $_POST['captcha'])
			  Filter::$msgs['captcha'] = lang('FORM_ERROR7');

          if (empty(Filter::$msgs)) {

              $userdata = $this->getUserInfo($_POST['uname']);
              $randpass = $this->getUniqueCode(12);
              $newpass = sha1($randpass);

              $data['password'] = $newpass;

              self::$db->update(self::uTable, $data, "username = '" . $userdata->username . "'");

              require_once (BASEPATH . "lib/class_mailer.php");
              $mailer = $mail->sendMail();
              $subject = lang('PASS_ESUBJECT') . Registry::get("Core")->company;

              ob_start();
              require_once (BASEPATH . 'mailer/Password_Reset.tpl.php');
              $html_message = ob_get_contents();
              ob_end_clean();

              $msg = Swift_Message::newInstance()
					  ->setSubject($subject)
					  ->setTo(array($userdata->email => $userdata->fname . ' ' . $userdata->lname))
					  ->setFrom(array(Registry::get("Core")->site_email => Registry::get("Core")->company))
					  ->setBody($html_message, 'text/html');

              (self::$db->affected() && $mailer->send($msg)) ? Filter::msgOk(lang('PASS_OK'), false) : Filter::msgError(lang('PASS_ERR'), false);

          } else
              print Filter::msgStatus();
      }

      /**
       * Users::getProjects()
       * 
       * @return
       */
      public function getProjects()
      {
          $sql = "SELECT p.*, pt.title as typetitle," 
		  . "\n DATE_FORMAT(p.end_date, '" . Registry::get("Core")->short_date . "') as enddate" 
		  . "\n FROM projects as p" 
		  . "\n LEFT JOIN project_types as pt ON pt.id = p.project_type" 
		  . "\n WHERE client_id = " . $this->uid;
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getSubmissions()
       * 
       * @return
       */
      public function getSubmissions()
      {
          $sql = "SELECT s.*, p.title as ptitle," 
		  . "\n DATE_FORMAT(s.created, '" . Registry::get("Core")->short_date . "') as start" 
		  . "\n FROM submissions as s" 
		  . "\n LEFT JOIN projects as p ON p.id = s.project_id" 
		  . "\n WHERE p.client_id = " . $this->uid . " AND s.status <> 0" 
		  . "\n ORDER BY s.created DESC";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getProjectById()
       * 
       * @return
       */
      public function getProjectById()
      {
          $sql = "SELECT p.*, pt.title as typetitle, CONCAT(u.fname,' ',u.lname) as staffname," 
		  . "\n DATE_FORMAT(p.end_date, '" . Registry::get("Core")->short_date . "') as enddate," 
		  . "\n DATE_FORMAT(p.start_date, '" . Registry::get("Core")->short_date . "') as startdate" 
		  . "\n FROM projects as p" 
		  . "\n LEFT JOIN project_types as pt ON pt.id = p.project_type" 
		  . "\n LEFT JOIN users as u ON u.id = p.staff_id" 
		  . "\n WHERE p.id = " . Filter::$id . " AND client_id = " . $this->uid;
          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getSubmissionsByProjectId()
       * 
       * @return
       */
      public function getSubmissionsByProjectId()
      {
          $sql = "SELECT s.*, p.title as ptitle," 
		  . "\n DATE_FORMAT(s.created, '" . Registry::get("Core")->short_date . "') as start" 
		  . "\n FROM submissions as s" 
		  . "\n LEFT JOIN projects as p ON p.id = s.project_id" 
		  . "\n WHERE p.client_id = " . $this->uid . " AND s.status <> 0" 
		  . "\n AND p.id = " . Filter::$id 
		  . "\n ORDER BY s.created DESC";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getSingleSubmissionsById()
       * 
       * @param bool $subid
       * @return
       */
      public function getSingleSubmissionsById($subid = false)
      {
          $id = ($subid) ? $subid : Filter::$id;
          $sql = "SELECT s.*, p.title as ptitle, CONCAT(u.fname,' ',u.lname) as staffname, u.email," 
		  . "\n DATE_FORMAT(s.created, '" . Registry::get("Core")->short_date . "') as start" 
		  . "\n FROM submissions as s" 
		  . "\n LEFT JOIN projects as p ON p.id = s.project_id" 
		  . "\n LEFT JOIN users as u ON u.id = s.staff_id" 
		  . "\n WHERE p.client_id = " . $this->uid . " AND s.status <> 0" 
		  . "\n AND s.id = " . $id;
          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getTasksByProjectId()
       * 
       * @return
       */
      public function getTasksByProjectId()
      {
          $sql = "SELECT t.*, p.title as ptitle, p.id as pid," 
		  . "\n DATE_FORMAT(t.created, '" . Registry::get("Core")->short_date . "') as start," 
		  . "\n DATE_FORMAT(t.duedate, '" . Registry::get("Core")->short_date . "') as duedate" 
		  . "\n FROM tasks as t" 
		  . "\n LEFT JOIN projects as p ON p.id = t.project_id" 
		  . "\n WHERE p.client_id = " . $this->uid . " AND client_access = 1 AND p.id = " . Filter::$id 
		  . "\n ORDER BY t.created DESC";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getFilesByProject()
       * 
       * @param bool $project_id
       * @return
       */
      public function getFilesByProject($project_id = false)
      {
          $id = ($project_id) ? $project_id : Filter::$id;

          $sql = "SELECT f.*, p.title as ptitle, p.id as pid," 
		  . "\n DATE_FORMAT(f.created, '" . Registry::get("Core")->short_date . "') as start" 
		  . "\n FROM project_files as f" 
		  . "\n LEFT JOIN projects as p ON p.id = f.project_id" 
		  . "\n WHERE p.client_id = " . $this->uid . " AND project_id = " . $id 
		  . "\n AND f.client_id = 0" 
		  . "\n ORDER BY f.created";
          $row = self::$db->fetch_all($sql);
          return ($row) ? $row : 0;
      }

      /**
       * Users::processProjectFile()
       * 
       * @return
       */
      public function processProjectFile()
      {

          if (empty($_POST['title']))
              Filter::$msgs['title'] = "Please Enter Project File Name";

          if (empty($_FILES['filename']['name']))
              Filter::$msgs['filename'] = "Please Select File To Upload";

          $upl = Uploader::instance(Registry::get("Core")->file_max, Registry::get("Core")->file_types);
          if (!empty($_FILES['filename']['name']) and empty(Filter::$msgs)) {
              $dir = UPLOADS . 'data/';
              $upl->upload('filename', $dir);
          }

          if (empty(Filter::$msgs)) {
              $data = array(
				  'title' => sanitize($_POST['title']), 
				  'filedesc' => $_POST['filedesc'], 
				  'created' => "NOW()", 
				  'project_id' => intval($_POST['project_id']), 
				  'client_id' => Registry::get("Users")->uid, 
				  'filename' => $upl->fileInfo['fname'], 
				  'filesize' => $upl->fileInfo['size']
			  );

              self::$db->insert("project_files", $data);

              (self::$db->affected()) ? Filter::msgOk(lang('FPRO_FILESENTOK')) : Filter::msgAlert(lang('NOPROCCESS'));;
          } else
              print Filter::msgStatus();
      }

      /**
       * Users::getLatestNews()
       * 
       * @return
       */
      public function getLatestNews()
      {
          $sql = "SELECT *, DATE_FORMAT(created, '" . Registry::get("Core")->short_date . "') as start" 
		  . "\n FROM news" 
		  . "\n WHERE active = 1" 
		  . "\n AND created <= NOW()" 
		  . "\n ORDER BY created DESC";

          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getClientInvoices()
       * 
       * @param mixed $status
       * @return
       */
      public function getClientInvoices($status)
      {
          $sql = "SELECT i.*," 
		  . "\n DATE_FORMAT(i.created, '" . Registry::get("Core")->short_date . "') as cdate," 
		  . "\n DATE_FORMAT(i.duedate, '" . Registry::get("Core")->short_date . "') as ddate," 
		  . "\n p.title as ptitle, CONCAT(u.fname,' ',u.lname) as name" 
		  . "\n FROM invoices as i" 
		  . "\n LEFT JOIN projects as p ON p.id = i.project_id" 
		  . "\n LEFT JOIN users as u ON u.id = i.client_id" 
		  . "\n WHERE i.client_id = " . $this->uid 
		  . "\n AND i.status $status" 
		  . "\n ORDER BY i.created";

          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getInvoiceById()
       * 
       * @param bool $inv_id
       * @return
       */
      public function getInvoiceById($inv_id = false)
      {
          $id = ($inv_id) ? (int)$inv_id : Filter::$id;
          $sql = "SELECT i.*," 
		  . "\n DATE_FORMAT(i.created, '" . Registry::get("Core")->short_date . "') as cdate," 
		  . "\n DATE_FORMAT(i.duedate, '" . Registry::get("Core")->short_date . "') as ddate," 
		  . "\n p.title as ptitle" 
		  . "\n FROM invoices as i" 
		  . "\n LEFT JOIN projects as p ON p.id = i.project_id" 
		  . "\n WHERE i.client_id = " . $this->uid . " AND i.id = " . $id;

          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getProjectInvoiceById()
       * 
       * @return
       */
      public function getProjectInvoiceById()
      {
          $sql = "SELECT i.*," 
		  . "\n DATE_FORMAT(i.created, '" . Registry::get("Core")->short_date . "') as cdate," 
		  . "\n DATE_FORMAT(i.duedate, '" . Registry::get("Core")->short_date . "') as ddate," 
		  . "\n p.title as ptitle, CONCAT(u.fname,' ',u.lname) as name, u.email, u.address, u.city, u.zip, u.state, u.phone, u.company" 
		  . "\n FROM invoices as i" 
		  . "\n LEFT JOIN projects as p ON p.id = i.project_id" 
		  . "\n LEFT JOIN users as u ON u.id = i.client_id" 
		  . "\n WHERE i.client_id = " . $this->uid . " AND i.id = '" . Filter::$id . "'";

          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getProjectInvoiceData()
       * 
       * @param bool $invid
       * @return
       */
      public function getProjectInvoiceData($invid = false)
      {
          $id = ($invid) ? intval($invid) : Filter::$id;

          $sql = "SELECT * FROM invoice_data WHERE invoice_id = '" . (int)$id . "'";

          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getProjectInvoicePayments()
       * 
       * @param bool $invid
       * @return
       */
      public function getProjectInvoicePayments($invid = false)
      {
          $id = ($invid) ? intval($invid) : Filter::$id;

          $sql = "SELECT *," 
		  . "\n DATE_FORMAT(created, '" . Registry::get("Core")->short_date . "') as cdate" 
		  . "\n FROM invoice_payments" 
		  . "\n WHERE invoice_id = '" . (int)$id . "'";

          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getSupportTickets()
       * 
       * @param bool $invid
       * @return
       */
      public function getSupportTickets()
      {

          $sql = "SELECT t.*, CONCAT(us.fname,' ',us.lname) as staffname," 
		  . "\n DATE_FORMAT(t.created, '" . Registry::get("Core")->long_date . "') as cdate" 
		  . "\n FROM support_tickets as t" 
		  . "\n LEFT JOIN users as us ON us.id = t.staff_id"
		  . "\n WHERE client_id = " .$this->uid
		  . "\n ORDER BY t.created DESC";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }
	  
      /**
       * Users::getSupportTicketById()
       * 
       * @return
       */
      public function getSupportTicketById()
      {
          $sql = "SELECT t.*, CONCAT(us.fname,' ',us.lname) as staffname," 
		  . "\n DATE_FORMAT(t.created, '" . Registry::get("Core")->long_date . "') as cdate" 
		  . "\n FROM support_tickets as t" 
		  . "\n LEFT JOIN users as us ON us.id = t.staff_id" 
		  . "\n WHERE t.client_id = " . $this->uid . " AND t.id = " . Filter::$id;
          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getResponseByTicketId()
       * 
       * @return
       */
      public function getResponseByTicketId()
      {
          $sql = "SELECT r.*, CONCAT(u.fname,' ',u.lname) as name," 
		  . "\n DATE_FORMAT(r.created, '" . Registry::get("Core")->long_date . "') as cdate" 
		  . "\n FROM support_responses as r" 
		  . "\n LEFT JOIN users as u ON u.id = r.author_id" 
		  . "\n LEFT JOIN support_tickets as st ON st.id = r.ticket_id"
		  . "\n WHERE st.client_id = " . $this->uid . " AND  r.ticket_id = " . Filter::$id
		  . "\n ORDER BY r.created DESC";
          
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

	  /**
	   * Users::replySupportTicket()
	   * 
	   * @return
	   */
	  public function replySupportTicket()
	  {
		  if (empty($_POST['body']))
			  Filter::$msgs['body'] = lang('SUP_DETAIL_R');

		  if (empty(Filter::$msgs)) {
		  
			  $sql = "SELECT t.*, CONCAT(us.fname,' ',us.lname) as staffname, us.email" 
			  . "\n FROM support_tickets as t" 
			  . "\n LEFT JOIN users as us ON us.id = t.staff_id" 
			  . "\n WHERE t.id = " . Filter::$id;
			  $row = self::$db->first($sql);
			  
			  $data = array(
					'ticket_id' => $row->id, 
					'author_id' => $this->uid,
					'user_type' => 'client',
					'created' => "NOW()",
					'body' => $_POST['body']
			  );
	
			  self::$db->insert("support_responses", $data);
	
			  require_once (BASEPATH . "lib/class_mailer.php");
			  $mailer = $mail->sendMail();
			  $subject = lang('SUP_ESUBJECT') . $row->subject;
	
			  ob_start();
			  require_once (BASEPATH . 'mailer/Reply_Ticket_From_Client.tpl.php');
			  $html_message = ob_get_contents();
			  ob_end_clean();
	
			  $msg = Swift_Message::newInstance()
					  ->setSubject($subject)
					  ->setTo(array($row->email => $row->staffname))
					  ->setFrom(array(Registry::get("Users")->email => Registry::get("Users")->name))
					  ->setBody($html_message, 'text/html');
	
			  $numSent = $mailer->send($msg);
			  
			  (self::$db->affected()) ? Filter::msgOk(lang('SUP_SENTOK')) : Filter::msgAlert(lang('NOPROCCESS'));;

		  } else
			  print Filter::msgStatus();
	  }

	  /**
	   * Users::processSupportTicket()
	   * 
	   * @return
	   */
	  public function processSupportTicket()
	  {
		  if (empty($_POST['subject']))
			  Filter::$msgs['subject'] = lang('SUP_SUBJECT_R');

		  if (empty($_POST['body']))
			  Filter::$msgs['body'] = lang('SUP_DETAIL_R1');

		  if (empty(Filter::$msgs)) {
			  $data = array(
			        'staff_id' => 1,
					'client_id' => $this->uid, 
					'department' => 'Support', 
					'priority' => sanitize($_POST['priority']), 
					'subject' => sanitize($_POST['subject']), 
					'body' => sanitize($_POST['body']), 
					'status' => 'Open',
					'created' => "NOW()"
			  );

			  self::$db->insert("support_tickets", $data);
			  
			  require_once (BASEPATH . "lib/class_mailer.php");
			  $mailer = $mail->sendMail();
			  $subject = lang('SUP_ESUBJECT') . $data['subject'];
	
			  ob_start();
			  require_once (BASEPATH . 'mailer/Send_Ticket.tpl.php');
			  $html_message = ob_get_contents();
			  ob_end_clean();
	
			  $msg = Swift_Message::newInstance()
					  ->setSubject($subject)
					  ->setTo(array(Registry::get("Core")->site_email => Registry::get("Core")->company))
					  ->setFrom(array(Registry::get("Users")->email => Registry::get("Users")->name))
					  ->setBody($html_message, 'text/html');
	
			  $numSent = $mailer->send($msg);
			  
			  $message = lang('SUP_SENTOK1');

			  (self::$db->affected()) ? Filter::msgOk($message) : Filter::msgAlert(lang('NOPROCCESS'));;
		  } else
			  print Filter::msgStatus();
	  }

      /**
       * Users::getMessages()
       * 
       * @return
       */
      public function getMessages()
      {

          $sql = "SELECT m.*," 
		  . "\n CONCAT(us.fname,' ',us.lname) as staffname" 
		  . "\n FROM messages as m" 
		  . "\n LEFT JOIN users as us ON us.id = m.sender"
		  . "\n WHERE recipient = " .$this->uid
		  . "\n ORDER BY m.created DESC";
          $row = self::$db->fetch_all($sql);

          return ($row) ? $row : 0;
      }

      /**
       * Users::getMessageById()
       * 
       * @return
       */
      public function getMessageById()
      {
		  $sql = "SELECT m.*, CONCAT(u.fname,' ',u.lname) as name" 
		  . "\n FROM messages as m" 
		  . "\n LEFT JOIN users as u ON u.id = m.sender" 
		  . "\n WHERE m.id = " . Filter::$id
		  . "\n AND recipient = " .$this->uid;
          
          $row = self::$db->first($sql);

          return ($row) ? $row : Filter::error("You have selected an Invalid Id","Users::getMessageById()");
      }
	  
      /**
       * Users::checkProjectAccess()
       * 
       * @param mixed $pid
       * @return
       */
      public function checkProjectAccess($pid)
      {
          $array = $this->getProjectAccessData();

          $arr = explode(",", $this->getProjectAccess($array));
          reset($arr);
          if ($this->userlevel = 5 and in_array($pid, $arr))
              return true;
      }

      /**
       * Users::getProjectAccessData()
       * 
       * @return
       */
      private function getProjectAccessData()
      {
          $sql = "SELECT * FROM projects WHERE staff_id = {$this->uid}";
          $row = self::$db->fetch_all($sql, true);

          return ($row) ? $row : 0;

      }

      /**
       * Users::getProjectAccess()
       * 
       * @param mixed $data
       * @return
       */
      private function getProjectAccess($data)
      {
          if ($data) {
              foreach ($data as $pid) {
                  if (is_array($pid)) {
                      $res[] = $this->getProjectAccess($pid);
                  } else
                      $res[] = $pid;
              }
              return implode(',', $res);
          } else
              return false;
      }

      /**
       * Users::getUserData()
       * 
       * @return
       */
      public function getUserData()
      {
          $sql = "SELECT *, DATE_FORMAT(created, '" . Registry::get("Core")->long_date . "') as cdate," 
		  . "\n DATE_FORMAT(lastlogin, '" . Registry::get("Core")->long_date . "') as ldate" 
		  . "\n FROM " . self::uTable 
		  . "\n WHERE id = '" . $this->uid . "'";
          $row = self::$db->first($sql);

          return ($row) ? $row : 0;
      }


      /**
       * Users::usernameExists()
       * 
       * @param mixed $username
       * @return
       */
      private function usernameExists($username)
      {
          $username = sanitize($username);
          if (strlen(self::$db->escape($username)) < 4)
              return 1;

          $alpha_num = str_replace(" ", "", $username);
          if (!ctype_alnum($alpha_num))
              return 2;

          $sql = self::$db->query("SELECT username FROM users WHERE username = '" . $username . "' LIMIT 1");

          $count = self::$db->numrows($sql);

          return ($count > 0) ? 3 : false;
      }

      /**
       * Users::emailExists()
       * 
       * @param mixed $email
       * @return
       */
      private function emailExists($email)
      {
		  $email = self::$db->escape($email);
          $sql = self::$db->query("SELECT email FROM users WHERE email = '" . sanitize($email) . "' LIMIT 1");

          if (self::$db->numrows($sql) == 1) {
              return true;
          } else
              return false;
      }

      /**
       * Users::isValidEmail()
       * 
       * @param mixed $email
       * @return
       */
      private function isValidEmail($email)
      {
          if (function_exists('filter_var')) {
              if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                  return true;
              } else
                  return false;
          } else
              return preg_match('/^[a-zA-Z0-9._+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/', $email);
      }

      /**
       * Users::getUniqueCode()
       * 
       * @param string $length
       * @return
       */
      private function getUniqueCode($length = "")
      {
          $code = md5(uniqid(rand(), true));
          if ($length != "") {
              return substr($code, 0, $length);
          } else
              return $code;
      }

      /**
       * Users::generateRandID()
       * 
       * @return
       */
      private function generateRandID()
      {
          return sha1($this->getUniqueCode(24));
      }

      /**
       * Users::getClientFilter()
       * 
       * @return
       */
      public function getClientFilter()
      {
          $arr = array(
				'company-ASC' => lang('COMPANY').' &uarr;', 
				'company-DESC' => lang('COMPANY').' &darr;', 
				'fname-ASC' => lang('FNAME').' &uarr;', 
				'fname-DESC' => lang('FNAME').' &darr;', 
				'lname-ASC' => lang('LNAME').' &uarr;', 
				'lname-DESC' => lang('LNAME').' &darr;', 
				'email-ASC' => lang('EMAIL').' &uarr;', 
				'email-DESC' => lang('EMAIL').' &darr;'
		  );

          $filter = '';
          foreach ($arr as $key => $val) {
              if ($key == get('sort')) {
                  $filter .= "<option selected=\"selected\" value=\"$key\">$val</option>\n";
              } else
                  $filter .= "<option value=\"$key\">$val</option>\n";
          }
          unset($val);
          return $filter;
      }
  }
?>