<?php
  /**
   * Register
   *
   * @package Freelance Manager
   * @author wojoscripts.com
   * @copyright 2010
   * @version $Id: register.php, v2.00 2011-07-10 10:12:05 gewa Exp $
   */
  define("_VALID_PHP", true);
  require_once("init.php");
  
  if(!$core->enable_reg)
      redirect_to("index.php");
	  
  if ($user->logged_in)
      redirect_to("account.php");
?>
<?php include("header.php");?>
<h1><?php echo lang('REG_TITLE');?></h1>
<p class="info"><?php echo lang('REG_INFO') . lang('REQFIELD1') . required() . lang('REQFIELD2');?></p>
<div class="box">
  <form action="" method="post" name="user_form" id="user_form">
    <table width="100%" border="0" cellpadding="3" cellspacing="0" class="display">
      <thead>
        <tr>
          <th colspan="2" class="left"><?php echo lang('REG_SUB');?></th>
        </tr>
      </thead>
      <tr>
        <th width="250"><strong><?php echo lang('USERNAME');?>: <?php echo required();?></strong></th>
        <td><span id="getusername">
          <input name="username" type="text" class="inputbox"  id="username" size="45" />
          <img src="images/ok-ico.png" alt="" id="yes" style="display:none" class="tooltip" title="<?php echo lang('USERNAME_AVAIL');?>" /> <img src="images/error-ico.png" alt="" id="no" style="display:none" class="tooltip" title="<?php echo lang('USERNAME_NOAVAIL');?>" /> </span></td>
      </tr>
      <tr>
        <th><strong><?php echo lang('PASSWORD');?>: <?php echo required();?></strong></th>
        <td><input name="pass" type="password" class="inputbox"  size="45" />
          &nbsp; <?php echo tooltip(lang('PASSWORD_T2'));?></td>
      </tr>
      <tr>
        <th><strong>Repeat Password: <?php echo required();?></strong></th>
        <td><input name="pass2" type="password" class="inputbox"  size="45" /></td>
      </tr>
      <tr>
        <th><strong><?php echo lang('EMAIL');?>:</strong> <?php echo required();?></th>
        <td><input name="email" type="text" class="inputbox"  size="45" /></td>
      </tr>
      <tr>
        <th><strong><?php echo lang('FNAME');?>:</strong> <?php echo required();?></th>
        <td><input name="fname" type="text" class="inputbox" size="45"  /></td>
      </tr>
      <tr>
        <th><strong><?php echo lang('LNAME');?>:</strong> <?php echo required();?></th>
        <td><input name="lname" type="text" class="inputbox" size="45"  /></td>
      </tr>
      <tr>
        <th><?php echo lang('COMPANY');?>:</th>
        <td><input name="company" type="text" class="inputbox" size="45" /></td>
      </tr>
      <tr>
        <th><?php echo lang('ADDRESS');?>:</th>
        <td><input name="address" type="text" class="inputbox" size="45" /></td>
      </tr>
      <tr>
        <th><?php echo lang('CITY');?>:</th>
        <td><input name="city" type="text" class="inputbox" size="45" /></td>
      </tr>
      <tr>
        <th><?php echo lang('STATE');?>:</th>
        <td><input name="state" type="text" class="inputbox" size="45" /></td>
      </tr>
      <tr>
        <th><?php echo lang('COUNTRY');?>:</th>
        <td><input name="country" type="text" class="inputbox" size="45" /></td>
      </tr>
      <tr>
        <th><?php echo lang('ZIP');?>:</th>
        <td><input name="zip" type="text" class="inputbox" size="20" /></td>
      </tr>
      <tr>
        <th><?php echo lang('PHONE');?>:</th>
        <td><input name="phone" type="text" class="inputbox" size="20" /></td>
      </tr>
      <tr>
        <td><input class="button" name="submit" value="<?php echo lang('REG_SUBMIT');?>" type="submit" /></td>
        <td align="right"><a class="button-alt" href="index.php"><?php echo lang('REG_BACK');?></a></td>
      </tr>
    </table>
    <input name="doRegister" type="hidden" value="1" />
  </form>
</div>
<script type="text/javascript">
  // <![CDATA[
  function showLoader() {
	  $("#loader").fadeIn(200);
  }

  function hideLoader() {
	  $("#loader").fadeOut(200);
  };
  $(document).ready(function() {
	  $("#user_form").submit(function () {
		  var str = $(this).serialize();
		  showLoader();
		  $.ajax({
			  type: "POST",
			  url: "ajax/user.php",
			  data: str,
			  success: function (msg) {
				  $("#msgholder").ajaxComplete(function(event, request, settings) {
				  if(msg  == 'OK') {
					  hideLoader();
					  result = '<div class="msgOk"><?php echo lang('REG_MSGOK');?></div>';
				  $(".box").hide();
				  } else {
					  hideLoader();
				      result = msg;
				  }
				 $(this).html(result);
					  });
				  }
			  });
		  return false;
	  });
  });

$(document).ready(function() {
	$('#username').keyup(username_check);
});
function username_check() {
	var username = $('#username').val();
	if (username == "" || username.length < 4) {
		$('#yes').hide();
	} else {
		$.ajax({
			type: "POST",
			url: "ajax/user.php",
			data: 'checkUsername=' + username,
			cache: false,
			success: function(response) {
				if (response == 1) {
					$('#yes').hide();
					$('#no').fadeIn();
				} else {
					$('#no').hide();
					$('#yes').fadeIn();
				}

			}
		});
	}
}
// ]]>
</script>
<?php include("footer.php");?>